/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.ChildStorageHelper;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.IStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.data.DependencyResponse;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.SortTarget;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AStructuredSettingConfig
extends ASettingConfig
implements IStructuredSettingConfig {
    protected AStructuredSettingConfig(String id, String name, ISetting setting, AStoragePeriphsStructuredSetting storageSetting, ChildContext parentContext, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
    }

    @Override
    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative(this, childId);
    }

    protected String createChildId(String childName) {
        return SettingUtils.buildId(this.id, childName);
    }

    @Override
    public @Nullable String getNestedProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*nested_problems*" + (Object)((Object)level), () -> ChildValidationHelper.getChildrenProblemsWithPrefix(this, level));
    }

    @Override
    public @Nullable String getProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems*" + (Object)((Object)level), () -> IStructuredSettingConfig.super.getProblems(level));
    }

    @Override
    public List<String> getProblemsPaths(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems_paths*" + (Object)((Object)level), () -> IStructuredSettingConfig.super.getProblemsPaths(level));
    }

    @Override
    public void setId(String id) {
        List children = this.getChildren();
        super.setId(id);
        for (ISettingConfig child : children) {
            child.setId(SettingUtils.buildId(id, child.getName()));
        }
    }

    public AStoragePeriphsStructuredSetting getStorageSetting() {
        return (AStoragePeriphsStructuredSetting)this.storageSetting;
    }

    @Override
    public void updateStorageAvailability() {
        ChildStorageHelper.updateStorageAvailability(this.getStorageSetting().getSettings(), this.getChildren());
    }

    @Override
    public void initValue() {
        for (ISettingConfig child : this.getChildren()) {
            child.initValue();
        }
    }

    @Override
    public void deInitialize() {
        this.getChildren().forEach(x -> x.deInitialize());
    }

    @Override
    public String getTargetValue(SortTarget target, @Nullable String settingId, IContext context) {
        IChild children;
        if (settingId != null && (children = this.getChildById(settingId)) != null) {
            switch (target) {
                case LABEL: {
                    return children.getUiName();
                }
                case VALUE: {
                    return children.getValue().toString();
                }
            }
        }
        return super.getTargetValue(target, settingId, context);
    }

    @Override
    public List<DependencyResponseConfig> getDependencyResponses() {
        ArrayList<DependencyResponseConfig> result = new ArrayList<DependencyResponseConfig>();
        Validation validation = this.setting.getValidation();
        if (validation != null) {
            result.addAll((Collection)validation.getDependencyResponses().stream().map(r -> new DependencyResponseConfig(this, (DependencyResponse)r)).collect(CollectorsUtils.toList()));
        }
        for (ISettingConfig settingConfig : this.getChildren()) {
            result.addAll(settingConfig.getDependencyResponses());
        }
        return result;
    }

    @Override
    public void synchronizeValue(@Nullable IChild config) {
        if (this.isSynchronizationEnabled()) {
            if (config != null) {
                if (!(config instanceof AStructuredSettingConfig)) {
                    throw new IllegalArgumentException(String.format("[TOOL]Unexpected setting type with id %1s - expected %2s", config.getId(), AStructuredSettingConfig.class.getName()));
                }
                AStructuredSettingConfig structuredSetting = (AStructuredSettingConfig)config;
                this.applySynchronizedSetting(structuredSetting);
            } else {
                IChild mainSetting = this.childContext.getRoot().getSynchronizedSettingByChild(this);
                if (mainSetting != null) {
                    if (!(mainSetting instanceof AStructuredSettingConfig)) {
                        throw new IllegalArgumentException(String.format("[TOOL]Unexpected setting type with id %1s - expected %2s", mainSetting.getId(), AStructuredSettingConfig.class.getName()));
                    }
                    AStructuredSettingConfig structConfig = (AStructuredSettingConfig)mainSetting;
                    this.applySynchronizedSetting(structConfig);
                }
            }
            ChildProviderHelper.unsetParentQuickSelections(this);
        } else {
            this.getChildren().forEach(child -> child.synchronizeValue(null));
        }
    }

    @Override
    public List<AStoragePeriphsSetting> getStorageOfRelatedSettings() {
        ArrayList<AStoragePeriphsSetting> relSettStorage = new ArrayList<AStoragePeriphsSetting>(super.getStorageOfRelatedSettings());
        this.getChildren().forEach(child -> {
            boolean bl = relSettStorage.addAll(child.getStorageOfRelatedSettings());
        });
        return relSettStorage;
    }

    @Override
    public void populateRelatedSettingsList(@Nullable Map<String, AStoragePeriphsSetting> storageConfigs) {
        super.populateRelatedSettingsList(storageConfigs);
        this.getChildren().forEach(child -> child.populateRelatedSettingsList(storageConfigs));
    }

    @Override
    public void updateRelatedSettingsId() {
        super.updateRelatedSettingsId();
        this.getChildren().forEach(child -> child.updateRelatedSettingsId());
    }
}

