/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.datacollection.storage.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nxp.s32ds.ext.rcp.datacollection.storage.LogBuilder;
import com.nxp.s32ds.ext.rcp.datacollection.storage.json.EventProperty;
import com.nxp.s32ds.ext.rcp.datacollection.storage.json.EventSchema;
import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonBuilder
implements LogBuilder {
    @Override
    public String build(Map<String, String> map, String sessionId, String timestamp) {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = "";
        try {
            String topic = map.get("event.topics");
            List<EventProperty> properties = JsonBuilder.convertMapToProperties(map, sessionId, topic);
            EventSchema schema = new EventSchema(sessionId, timestamp, topic, properties);
            json = objectMapper.writeValueAsString((Object)schema);
        }
        catch (JsonProcessingException ex) {
            DataCollectionActivator.getInstance().logError(Messages.JsonBuilder_cannot_build_json, ex);
        }
        return json;
    }

    @Override
    public String wrapFirstRecord(String data) {
        return "[" + System.lineSeparator() + data + System.lineSeparator() + "]";
    }

    @Override
    public String wrapNextRecord(String data) {
        return "," + System.lineSeparator() + data + System.lineSeparator() + "]";
    }

    private static List<EventProperty> convertMapToProperties(Map<String, String> map, String sessionId, String topic) {
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        if (topic.equals("s32ds/data/collection/head")) {
            EventProperty p = new EventProperty("uuid", sessionId);
            properties.add(p);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equals("event.topics")) continue;
            EventProperty p = new EventProperty(entry.getKey(), entry.getValue());
            properties.add(p);
        }
        return properties;
    }
}

