/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.lauterbach;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LauterbachT32LaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String T32_LAUNCH_CONFIGURATION_TYPE_ID = "com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate";
    private static final String LTB_TYPE_PREFIX = "com.lauterbach.trace32.debug.t32.";
    private static final String T32_ATTRIBUTE_CPROJECT = "com.lauterbach.trace32.debug.t32.CPROJECT";
    private static final String T32_ATTRIBUTE_EXEC = "com.lauterbach.trace32.debug.t32.EXECUTABLE";
    private static final String T32_ATTRIBUTE_PROJECT_DIR = "com.lauterbach.trace32.debug.t32.PROJECT_DIR";
    private static final String T32_ATTRIBUTE_INVOKE_SCRIPT_AFTER_LAUNCH = "com.lauterbach.trace32.debug.t32.INVOKE_SCRIPT_AFTER_LAUNCH";
    private static final String T32_PROJECT_DIR_VALUE = "${ProjDirPath}";
    private static final String T32_EXEC_VALUE = "${S32DS_T32_PATH}/bin/%s/t32marm.exe";
    private static final String EMPTY_STRING = "";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> params) throws CoreException {
        String component;
        String configurationFileName;
        IResource launchResource;
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(T32_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debugerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(params);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(configurationFileName = String.valueOf(component = String.valueOf(project.getName()) + "_" + LaunchConfigurationUtil.extractConfigurationName(params)) + ".launch") + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debugerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, params);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> params) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(params);
        workingCopy.setAttribute(T32_ATTRIBUTE_CPROJECT, project.getName());
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(params);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        workingCopy.setAttribute(T32_ATTRIBUTE_EXEC, this.getExecValue(T32_EXEC_VALUE, EMPTY_STRING));
        workingCopy.setAttribute(T32_ATTRIBUTE_PROJECT_DIR, T32_PROJECT_DIR_VALUE);
        workingCopy.setAttribute(T32_ATTRIBUTE_INVOKE_SCRIPT_AFTER_LAUNCH, Boolean.TRUE.toString());
    }

    public String getExecValue(String execPath, String EMPTY_STRING) {
        File file;
        OperatingSystemMXBean oSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String osName = oSystemMXBean.getName().toLowerCase().replaceAll("\\d|\\h", EMPTY_STRING);
        String architecture = oSystemMXBean.getArch().replaceAll("\\D+", EMPTY_STRING);
        if (osName.contains("win")) {
            execPath = String.format(T32_EXEC_VALUE, osName.concat(architecture));
        }
        if (osName.contains("linux")) {
            IPath path = new Path(execPath).removeFileExtension();
            execPath = path.toString();
            execPath = String.format(execPath, "pc_" + osName.concat(architecture));
        }
        try {
            file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(execPath));
        }
        catch (CoreException coreException) {
            return EMPTY_STRING;
        }
        if (!file.exists()) {
            return EMPTY_STRING;
        }
        return execPath;
    }
}

