/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.ui.buildconfig;

import com.freescale.s32ds.cdt.ui.buildconfig.Activator;
import com.freescale.s32ds.cdt.ui.buildconfig.BuildPathUtils;
import com.freescale.s32ds.cdt.ui.buildconfig.Messages;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuildConfigurationsComposite
extends Composite {
    public BuildConfigurationsComposite(Composite parent, ICProjectDescription projectDescription) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        new TreeViewer(this, 67584, projectDescription){
            {
                this.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
                this.getTree().setHeaderVisible(true);
                this.createColumn("", 300, new ResourceLabelProvider());
                ICConfigurationDescription[] iCConfigurationDescriptionArray = iCProjectDescription.getConfigurations();
                int n = iCConfigurationDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription conf = iCConfigurationDescriptionArray[n2];
                    this.createColumn(conf.getName(), 100, new ConfigLabelProvider(conf)).setEditingSupport((EditingSupport)new ConfigEditingSupport((ColumnViewer)this, conf));
                    ++n2;
                }
                this.setContentProvider((IContentProvider)new ContentProvider());
                this.setInput(iCProjectDescription.getProject());
                this.expandAll();
            }

            private TreeViewerColumn createColumn(String text, int width, CellLabelProvider labelProvider) {
                TreeViewerColumn col = new TreeViewerColumn((TreeViewer)this, 0);
                col.getColumn().setText(text);
                col.getColumn().setAlignment(16384);
                col.getColumn().setWidth(width);
                col.setLabelProvider(labelProvider);
                return col;
            }
        };
    }

    public void dispose() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        super.dispose();
    }

    private static class ConfigEditingSupport
    extends EditingSupport {
        private final ICConfigurationDescription config;
        private final CheckboxCellEditor editor;

        public ConfigEditingSupport(ColumnViewer viewer, ICConfigurationDescription config) {
            super(viewer);
            this.config = config;
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return BuildPathUtils.canExclude((IResource)element, this.getValue(element), this.config.getSourceEntries());
        }

        protected Boolean getValue(Object element) {
            return BuildPathUtils.isOnSourcePath((IResource)element, this.config.getSourceEntries());
        }

        protected void setValue(Object element, Object value) {
            IResource resource = (IResource)element;
            try {
                String projectName = this.config.getProjectDescription().getProject().getFullPath().lastSegment();
                if (this.isLastEntrySource(value, projectName)) {
                    if (MessageDialog.openConfirm((Shell)this.getViewer().getControl().getShell(), (String)"Warnnig", (String)Messages.BuildConfigurationsComposite)) {
                        this.config.setSourceEntries(CDataUtil.setExcluded((IPath)resource.getFullPath(), (boolean)(resource instanceof IFolder), ((Boolean)value == false ? 1 : 0) != 0, (ICSourceEntry[])this.config.getSourceEntries()));
                    }
                } else {
                    this.config.setSourceEntries(CDataUtil.setExcluded((IPath)resource.getFullPath(), (boolean)(resource instanceof IFolder), ((Boolean)value == false ? 1 : 0) != 0, (ICSourceEntry[])this.config.getSourceEntries()));
                }
            }
            catch (Exception e) {
                Activator.log(e);
            }
            this.getViewer().refresh();
        }

        private boolean isLastEntrySource(Object value, String projectName) {
            return (Boolean)value == false && this.config.getSourceEntries().length == 1 && !projectName.equals(this.config.getSourceEntries()[0].getFullPath().lastSegment()) && !this.config.getSourceEntries()[0].getName().equals(projectName);
        }
    }

    private static class ConfigLabelProvider
    extends CellLabelProvider {
        private final ICConfigurationDescription config;
        private static final Image[][] ICONS;

        static {
            Image[][] imageArrayArray = new Image[2][];
            Image[] imageArray = new Image[2];
            imageArray[1] = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
            imageArrayArray[0] = imageArray;
            imageArrayArray[1] = new Image[]{PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD")};
            ICONS = imageArrayArray;
        }

        public ConfigLabelProvider(ICConfigurationDescription config) {
            this.config = config;
        }

        public void update(ViewerCell cell) {
            ICSourceEntry[] entries;
            IResource resource = (IResource)cell.getElement();
            boolean isExcluded = !BuildPathUtils.isOnSourcePath(resource, entries = this.config.getSourceEntries());
            boolean canExclude = BuildPathUtils.canExclude(resource, !isExcluded, entries);
            cell.setImage(ICONS[isExcluded ? 0 : 1][canExclude ? 1 : 0]);
        }
    }

    private static class ContentProvider
    extends BaseWorkbenchContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object element) {
            ArrayList<Resource> children = new ArrayList<Resource>();
            Object[] objectArray = ContentProvider.super.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r;
                Object o = objectArray[n2];
                if (o instanceof Resource && !(r = (Resource)o).getName().startsWith(".")) {
                    ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
                    ICProjectDescription desc = mngr.getProjectDescription(r.getProject(), 8);
                    ICConfigurationDescription[] cfgs = desc.getConfigurations();
                    Resource curResource = r;
                    while (!(curResource.getParent() instanceof IProject)) {
                        curResource = curResource.getParent();
                    }
                    boolean isGeneratedDirectory = false;
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                    int n3 = cfgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                        if (curResource.getName().equals(cfg.getName())) {
                            isGeneratedDirectory = true;
                        }
                        ++n4;
                    }
                    if (!isGeneratedDirectory) {
                        children.add(r);
                    }
                }
                ++n2;
            }
            return children.toArray(new Object[0]);
        }
    }

    private static class ResourceLabelProvider
    extends CellLabelProvider {
        private final WorkbenchLabelProvider parent = new WorkbenchLabelProvider();

        private ResourceLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.parent.getImage(cell.getElement()));
            cell.setText(this.parent.getText(cell.getElement()));
        }

        public void dispose() {
            this.parent.dispose();
            super.dispose();
        }
    }
}

