/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree.uiwidgets;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.event.PatternEvent;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UITextWidget
extends InputUIElement
implements ModifyListener {
    protected Text text;
    protected Label label;
    private String patternValue;
    protected UIComposite uiComposite;
    protected String textValue = "";

    public UITextWidget(UIAttributes uiAttribute) {
        super(uiAttribute);
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put((String)this.uiAttributes.get("id"), this.textValue);
        return retMap;
    }

    @Override
    public void setValues(Map<String, String> valueMap) {
        String val = valueMap.get(this.uiAttributes.get("id"));
        String key = null;
        String subString = null;
        if (val != null) {
            if (val.indexOf("$(") != -1) {
                key = TemplateEngineHelper.getFirstMarkerID((String)val);
                subString = val.substring(key.length() + 3, val.length());
                val = valueMap.get(key) != null ? String.valueOf(valueMap.get(key)) + subString : subString;
            }
            this.textValue = val = val.trim();
        }
    }

    @Override
    public void createWidgets(UIComposite uiComposite) {
        GridData gd = new GridData();
        this.uiComposite = uiComposite;
        this.label = new Label((Composite)uiComposite, 16384);
        this.label.setText((String)this.uiAttributes.get("label"));
        if (((String)this.uiAttributes.get("type")).equalsIgnoreCase("multiline")) {
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.verticalIndent = 5;
            this.label.setLayoutData((Object)gd);
        }
        if (this.uiAttributes.get("description") != null) {
            String tipText = (String)this.uiAttributes.get("description");
            tipText = tipText.replaceAll("\\\\r\\\\n", "\r\n");
            this.label.setToolTipText(tipText);
        }
        this.text = this.getTextWidget((String)this.uiAttributes.get("type"));
        this.text.addModifyListener((ModifyListener)this);
        this.text.setData(".uid", this.uiAttributes.get("id"));
        this.text.setText(this.textValue);
    }

    @Override
    public void disposeWidget() {
        this.label.dispose();
        this.text.dispose();
    }

    public void evaluatePattern(String labelText, String userInputText, String pattern) {
        String message = String.valueOf(labelText) + " contents";
        Pattern pattern2 = Pattern.compile(pattern);
        Matcher matcher = pattern2.matcher(userInputText);
        if (!matcher.matches()) {
            String[] failed = pattern2.split(userInputText);
            int i = 1;
            while (i < failed.length) {
                message = String.valueOf(message) + " " + failed[i];
                ++i;
            }
            message = String.valueOf(message) + " is Invalid. ";
            message = String.valueOf(message) + " Expected pattern is \"" + pattern + "\"";
            if (this.uiComposite != null) {
                this.uiComposite.firePatternEvent(new PatternEvent(this, message, false));
            }
        } else {
            String checkproject = (String)this.uiAttributes.get("checkproject");
            if (checkproject != null && checkproject.equalsIgnoreCase("true") && TemplateEngineHelper.checkDirectoryInWorkspace((String)userInputText)) {
                message = String.valueOf(userInputText) + Messages.getString("UITextWidget.0");
                this.uiComposite.firePatternEvent(new PatternEvent(this, message, false));
            } else if (this.uiComposite != null) {
                this.uiComposite.firePatternEvent(new PatternEvent(this, message, true));
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        String patternName = (String)this.uiAttributes.get("pattern");
        this.patternValue = patternName == null ? null : (patternName.equals("FreeText") || patternName.equals("Text") || patternName.equals("FileName") ? this.getPatternValue(patternName) : patternName);
        this.textValue = this.text.getText();
        if (this.patternValue == null || this.textValue == null) {
            return;
        }
        String mandatory = (String)this.uiAttributes.get("mandatory");
        if ((mandatory == null || !mandatory.equalsIgnoreCase("true")) && this.textValue.isEmpty()) {
            return;
        }
        this.evaluatePattern(this.label.getText(), this.textValue, this.patternValue);
    }

    private String getPatternValue(String patternName) {
        if (patternName.equals("Text")) {
            this.patternValue = "[A-Za-z0-9\\!\\?\\.: ]*";
        }
        if (patternName.equals("FreeText")) {
            this.patternValue = "[A-Za-z0-9() \\.\\s]*";
        }
        if (patternName.equals("FileName")) {
            this.patternValue = "([A-Za-z][:])?[[\\|\\\\|/]?[_!@#\\$%\\^()\\-+{}\\[\\]=;',A-Za-z0-9\\. ]*]*";
        }
        return this.patternValue;
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.uiAttributes.get("mandatory");
        if (mandatory != null && mandatory.equalsIgnoreCase("true") && (this.textValue == null || this.textValue.isEmpty() || this.textValue.trim().length() < 1)) {
            retVal = false;
        }
        return retVal;
    }

    private Text getTextWidget(String type) {
        Text retTextWidget = null;
        Composite textConatiner = new Composite((Composite)this.uiComposite, 0x100000);
        textConatiner.setLayout((Layout)new GridLayout());
        if (type.equalsIgnoreCase("input")) {
            GridData gridData = new GridData(768);
            gridData.widthHint = 70;
            textConatiner.setLayoutData((Object)gridData);
            retTextWidget = new Text(textConatiner, 2052);
            retTextWidget.setLayoutData((Object)new GridData(768));
        }
        if (type.equalsIgnoreCase("multiline")) {
            GridData multiTextData = new GridData(768);
            multiTextData.widthHint = 70;
            String line = (String)this.uiAttributes.get("size");
            int cnt = 1;
            if (line != null && (cnt = Integer.parseInt(line)) <= 0) {
                cnt = 1;
            }
            multiTextData.heightHint = 30 + 12 * cnt;
            textConatiner.setLayoutData((Object)multiTextData);
            retTextWidget = new Text(textConatiner, 2626);
            GridData textData = new GridData(4, 4, true, true);
            retTextWidget.setLayoutData((Object)textData);
        }
        return retTextWidget;
    }
}

