/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.core;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.File;
import java.util.Objects;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class SdkDescriptorUtils {
    private SdkDescriptorUtils() {
    }

    public static String makeId(SdkDescriptor descriptor) {
        return descriptor != null ? NLS.bind((String)Messages.SdkDescriptor_make_id_mask, (Object)descriptor.getName(), (Object)descriptor.getVersion()) : null;
    }

    public static String makeId(String name, String version) {
        return name != null && version != null ? NLS.bind((String)Messages.SdkDescriptor_make_id_mask, (Object)name, (Object)version) : null;
    }

    public static String makeId(Element sdkElement) {
        return sdkElement != null ? NLS.bind((String)Messages.SdkDescriptor_make_id_mask, (Object)sdkElement.getAttribute("name"), (Object)sdkElement.getAttribute("version")) : null;
    }

    public static String makeTargetFolderName(SdkDescriptor descriptor) {
        return SdkDescriptorUtils.makeTargetFolderName(descriptor.getTargetFolderName(), descriptor.getName(), descriptor.getVersion());
    }

    public static String makeTargetFolderName(String targetFolderName, String name, String version) {
        if (Objects.toString(name, "").isEmpty() || Objects.toString(version, "").isEmpty()) {
            return null;
        }
        String sdkFolderName = String.format("%s_%s", name, version);
        if (!Objects.toString(targetFolderName, "").isEmpty()) {
            return String.valueOf(targetFolderName) + File.separator + sdkFolderName;
        }
        return sdkFolderName;
    }

    public static String makeTargetFolderName(Element sdkElement) {
        return SdkDescriptorUtils.makeTargetFolderName(sdkElement.getAttribute("targetFolderName"), sdkElement.getAttribute("name"), sdkElement.getAttribute("version"));
    }
}

