/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.dsf;

import com.nxp.s32ds.cle.cdt.memory.spaces.dsf.S32DbgMemoryBlock;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.MemorySpaceActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.Messages;
import java.math.BigInteger;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class S32DbgMemoryRetrieval
extends DsfMemoryBlockRetrieval {
    private final int bytesPerAddress;
    private BigInteger maxAddress;

    public S32DbgMemoryRetrieval(String modelId, ILaunchConfiguration config, DsfSession session, int bytesPerAddress, BigInteger maxAddress) throws DebugException {
        super(modelId, config, session);
        this.bytesPerAddress = bytesPerAddress;
        this.maxAddress = maxAddress;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        BigInteger blockAddress;
        IMemory.IMemoryDMContext memoryDmc;
        block12: {
            memoryDmc = null;
            IDMContext dmc = null;
            if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
            }
            if (memoryDmc == null) {
                MemorySpaceActivator.getInstance().logError(Messages.MemoryRetrieval_error_no_memory_context);
                return null;
            }
            blockAddress = null;
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0b")) {
                    base = 2;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    blockAddress = this.resolveMemoryAddress(dmc, expression);
                }
                catch (DebugException e) {
                    MemorySpaceActivator.getInstance().logError(e.getMessage(), e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MemoryRetrieval_error_expression_evaluation_title, (String)NLS.bind((String)Messages.MemoryRetrieval_error_expression_cannot_be_resolved, (Object)expression));
                }
                if (blockAddress != null) break block12;
                MemorySpaceActivator.getInstance().logError(Messages.MemoryRetrieval_error_cannot_resolve_address);
                return null;
            }
        }
        if (this.maxAddress.compareTo(blockAddress) < 0) {
            throw new DebugException((IStatus)new Status(4, MemorySpaceActivator.getInstance().getBundleId(), NLS.bind((String)Messages.MemoryRetrieval_error_address_exceeds_limit, (Object)expression, (Object)this.maxAddress.toString(16))));
        }
        return new S32DbgMemoryBlock(this, memoryDmc, expression, blockAddress, this.getAddressableSize());
    }

    public int getAddressSize() {
        return (int)Math.ceil((double)this.maxAddress.bitLength() / 8.0);
    }

    public int getAddressableSize() {
        return this.bytesPerAddress;
    }

    protected DsfServicesTracker getDsfServiceTRacker(String sessionId) {
        return new DsfServicesTracker(MemorySpaceActivator.getInstance().getContext(), sessionId);
    }

    public String getModelId() {
        return super.getModelId();
    }

    public BigInteger resolveMemoryAddress(IDMContext dmc, String expression) throws DebugException {
        return super.resolveMemoryAddress(dmc, expression);
    }
}

