/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load;

import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.SdkPreferencesHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.Collections;
import java.util.List;

public class WorkspaceSdkLoader {
    private WorkspaceSdkLoader() {
    }

    public static List<SdkDescriptor> loadWorkspaceSdks() {
        String workspaceSdksXml = SdkPreferencesHelper.getPersistedSdksXml((SdkType)SdkType.WORKSPACE);
        if (workspaceSdksXml.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return new SdkDescriptorParser().loadSdks(workspaceSdksXml, null, null, null, SdkType.WORKSPACE);
        }
        catch (LoadSdkException loadSdkException) {
            SdkCoreActivator.getInstance().logError("Unable to load workspace SDKs");
            return Collections.emptyList();
        }
    }

    public static void updatePersistedWorkspaceSdks() {
        SdkPreferencesHelper.updatePersistedSdks((SdkType)SdkType.WORKSPACE);
    }
}

