/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class ConflictingSdksHandler {
    public static final ConflictingSdksHandler INSTANCE = new ConflictingSdksHandler();
    private static final String CONFLICT_SDK_MARKER_TYPE = "com.nxp.s32ds.cle.cdt.sdk.core.ConflictingSdkMarker";
    private static final String CONFLICT_SDK_MARKER_SDK_ID_ATTRIBUTE = "sdkId";
    private Map<IProject, Set<SdkDescriptor>> conflictedSDKs = new HashMap<IProject, Set<SdkDescriptor>>();

    public void addConflictedSdks(IProject project, List<SdkDescriptor> sdks) {
        Set<SdkDescriptor> sdksSet = this.conflictedSDKs.get(project);
        if (sdksSet == null) {
            sdksSet = new HashSet<SdkDescriptor>();
        }
        sdksSet.addAll(sdks);
        this.conflictedSDKs.put(project, sdksSet);
    }

    public Set<SdkDescriptor> getConflictedSdks(IProject project) {
        return this.conflictedSDKs.get(project);
    }

    public void handleConflictedSDKs(IProject project) {
        Set<SdkDescriptor> sdks = this.conflictedSDKs.get(project);
        ConflictingSdksHandler.handleProjectConflictedSDKs(project, sdks);
    }

    public void handleConflictedSDKs() {
        for (Map.Entry<IProject, Set<SdkDescriptor>> e : this.conflictedSDKs.entrySet()) {
            ConflictingSdksHandler.handleProjectConflictedSDKs(e.getKey(), e.getValue());
        }
    }

    public void cleanupConflictedSdks(IProject project) {
        this.conflictedSDKs.remove(project);
    }

    private static void handleProjectConflictedSDKs(IProject project, Set<SdkDescriptor> sdks) {
        if (sdks == null || sdks.isEmpty()) {
            return;
        }
        for (SdkDescriptor sdkDescriptor : sdks) {
            String sdkId = sdkDescriptor.getId();
            if (project != null && project.isAccessible()) {
                String projectName = project.getName();
                String message = NLS.bind((String)Messages.ConflictingSdksHandler_project_sdk_id_conflict, (Object)projectName, (Object)sdkId);
                SdkCoreActivator.getInstance().logError(message);
                ConflictingSdksHandler.createConflictedSdkMarker((IResource)project, message, sdkId);
                continue;
            }
            SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.ConflictingSdksHandler_sdk_id_conflict, (Object)sdkId));
        }
    }

    private static void createConflictedSdkMarker(IResource resource, String message, String sdkId) {
        try {
            IMarker marker = ConflictingSdksHandler.createErrorMarker(CONFLICT_SDK_MARKER_TYPE, resource, message);
            marker.setAttribute(CONFLICT_SDK_MARKER_SDK_ID_ATTRIBUTE, (Object)sdkId);
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError(Messages.ConflictingSdksHandler_error_creating_conflict_marker, ce);
        }
    }

    private static IMarker createErrorMarker(String type, IResource resource, String message) throws CoreException {
        IMarker marker = resource.createMarker(type);
        marker.setAttribute("severity", 2);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("location", (Object)resource.getLocation().toString());
        return marker;
    }
}

