/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.checkers;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class SdkAvailabilityChecker {
    private SdkAvailabilityChecker() {
    }

    public static IStatus checkAvailability(String sdkId) {
        if (SdkDescriptors.getSdkDescriptor((String)sdkId) == null) {
            return SdkAttachStatuses.ERROR_SDK_MISSED;
        }
        return SdkAvailabilityChecker.isLocationIncorrect(sdkId) ? SdkAttachStatuses.ERROR_SDK_LOCATION : Status.OK_STATUS;
    }

    private static boolean isLocationIncorrect(String sdkId) {
        IPath sdkPath = EnvironmentSdkCore.getResolvedSdkPath((String)sdkId);
        return sdkPath == null || sdkPath.isEmpty() || !sdkPath.toFile().exists() || ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty() && !SdkAvailabilityChecker.checkFilesPathsConsistency(sdkId, sdkPath);
    }

    private static boolean checkFilesPathsConsistency(String sdkId, IPath sdkPath) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId).stream().map(ResourceSdkDescriptor::getPath).filter(pathString -> !pathString.isEmpty()).map(Path::fromOSString).noneMatch(path -> !sdkPath.isPrefixOf(path));
    }
}

