/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachData;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.MissedSdkMarker;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdkAttachDataHelper {
    public static final String PROJDIRPATH = "${ProjDirPath}";

    private SdkAttachDataHelper() {
    }

    public static List<SdkAttachData> loadSdkAttachDataFromProjectPreferences(IProject project) {
        String sdksConfigData = new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk").get("com.freescale.s32ds.cross.sdk.support.attachedSDKs", "");
        if (sdksConfigData == null || sdksConfigData.trim().length() == 0) {
            return new ArrayList<SdkAttachData>();
        }
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        ArrayList<SdkAttachData> projectAttachData = new ArrayList<SdkAttachData>();
        String[] stringArray = sdksConfigData.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attachedSdkData = stringArray[n2];
            String[] attachedSdkParams = attachedSdkData.split(Pattern.quote("|"));
            SdkAttachData sdkAttachData = new SdkAttachData(attachedSdkParams[0].trim());
            int attachedConfigsCount = attachedSdkParams.length - 1;
            if (attachedConfigsCount > 0) {
                String[] attachedConfigurations = new String[attachedConfigsCount];
                System.arraycopy(attachedSdkParams, 1, attachedConfigurations, 0, attachedConfigsCount);
                Arrays.stream(attachedConfigurations).forEach(sdkAttachData::addConfiguration);
                SdkAttachDataHelper.initSdkConfigurationsAttachData(project, sdkAttachData);
            } else if (configurations != null) {
                configurations.stream().map(IBuildObject::getName).forEach(sdkAttachData::addConfiguration);
            }
            projectAttachData.add(sdkAttachData);
            ++n2;
        }
        return projectAttachData;
    }

    public static Set<UpdateStatus> getAttachUpdateStatuses(String sdkId, IConfiguration config) {
        Element root = SdkAttachDataHelper.createRootElement(sdkId, config);
        if (root == null) {
            return Collections.emptySet();
        }
        String configName = config.getName();
        NodeList configNodes = root.getElementsByTagName("config");
        int i = 0;
        while (i < configNodes.getLength()) {
            Element configElement = (Element)configNodes.item(i);
            if (configName.equals(configElement.getAttribute("name"))) {
                LinkedHashSet<UpdateStatus> attachUpdateStatuses = new LinkedHashSet<UpdateStatus>();
                NodeList sourceEntriesNodes = configElement.getElementsByTagName("sourceEntries");
                int j = 0;
                while (j < sourceEntriesNodes.getLength()) {
                    Element element = (Element)sourceEntriesNodes.item(j);
                    SdkAttachDataHelper.addAttachUpdateStatus(element, configName, attachUpdateStatuses);
                    ++j;
                }
                NodeList optionNodes = configElement.getElementsByTagName("option");
                int j2 = 0;
                while (j2 < optionNodes.getLength()) {
                    Element element = (Element)optionNodes.item(j2);
                    SdkAttachDataHelper.addAttachUpdateStatus(element, configName, attachUpdateStatuses);
                    ++j2;
                }
                NodeList buildStepNodes = configElement.getElementsByTagName("buildStep");
                int j3 = 0;
                while (j3 < buildStepNodes.getLength()) {
                    Element element = (Element)buildStepNodes.item(j3);
                    SdkAttachDataHelper.addAttachUpdateStatus(element, configName, attachUpdateStatuses);
                    ++j3;
                }
                NodeList launchAttributeNodes = configElement.getElementsByTagName("launchAttribute");
                int j4 = 0;
                while (j4 < launchAttributeNodes.getLength()) {
                    Element element = (Element)launchAttributeNodes.item(j4);
                    SdkAttachDataHelper.addAttachUpdateStatus(element, configName, attachUpdateStatuses);
                    ++j4;
                }
                NodeList builderAttributeNodes = configElement.getElementsByTagName("builderAttribute");
                int j5 = 0;
                while (j5 < builderAttributeNodes.getLength()) {
                    Element element = (Element)builderAttributeNodes.item(j5);
                    SdkAttachDataHelper.addAttachUpdateStatus(element, configName, attachUpdateStatuses);
                    ++j5;
                }
                return attachUpdateStatuses;
            }
            ++i;
        }
        return Collections.emptySet();
    }

    public static String getSourceEntryPath(IProject project, String sdkId, IConfiguration config) {
        Element rootElement = SdkAttachDataHelper.createRootElement(sdkId, config);
        if (rootElement == null) {
            return "";
        }
        return SdkAttachDataHelper.getSdkFolderPath(rootElement);
    }

    private static Element createRootElement(String sdkId, IConfiguration config) {
        IEclipsePreferences prefs = new ProjectScope((IProject)config.getOwner()).getNode("com.nxp.s32ds.cle.ide.sdk.attached.sdks.data");
        String sdkAttachDataXml = prefs.get(sdkId, null);
        if (sdkAttachDataXml == null || sdkAttachDataXml.isEmpty()) {
            return null;
        }
        Element root = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(sdkAttachDataXml.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                root = parser.parse(stream).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to parse SDK {0} attach data.", (Object)sdkId), e);
            return null;
        }
        if (!root.getNodeName().equals("attachData")) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to parse SDK {0} attach data: wrong format.", (Object)sdkId));
            return null;
        }
        return root;
    }

    private static String getSdkFolderPath(Element rootElement) {
        NodeList configNodes = rootElement.getElementsByTagName("entry");
        int i = 0;
        while (i < configNodes.getLength()) {
            Element configElement = (Element)configNodes.item(i);
            String newValue = configElement.getAttributes().getNamedItem("path").getNodeValue();
            if (newValue != null) {
                return newValue;
            }
            ++i;
        }
        return "";
    }

    public static List<SdkDescriptor> getSdksAttachedToProject(IProject project, boolean verbose) {
        if (project == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, String> unavailableSdks = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> missedSdks = new LinkedHashMap<String, String>();
        List<SdkDescriptor> result = SdkAttachDataHolder.verboseProjectAttachData(project, unavailableSdks, missedSdks);
        if (verbose) {
            MissedSdkMarker.delete((IProject)project);
            unavailableSdks.entrySet().forEach(e -> SdkAttachDataHelper.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
            missedSdks.entrySet().forEach(e -> SdkAttachDataHelper.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
        }
        return result;
    }

    public static IStatus checkStatusOfSdksAttachedToProject(IProject project) {
        LinkedHashMap<String, String> unavailableSdks = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> missedSdks = new LinkedHashMap<String, String>();
        SdkAttachDataHolder.verboseProjectAttachData(project, unavailableSdks, missedSdks);
        MissedSdkMarker.delete((IProject)project);
        if (unavailableSdks.isEmpty() && missedSdks.isEmpty()) {
            return Status.OK_STATUS;
        }
        unavailableSdks.entrySet().forEach(e -> SdkAttachDataHelper.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
        missedSdks.entrySet().forEach(e -> SdkAttachDataHelper.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
        return SdkCoreActivator.getInstance().createError(NLS.bind((String)"At least one of SDK(s) attached to project {0} is missed or unavailble", (Object)project.getName()));
    }

    public static void checkStatusOfAttachedSdks() {
        for (IProject project : SdkManagementUtils.getAvailableProjects()) {
            if (project == null || !SdkAttachDataHolder.hasProjectAttachedSdks(project.getName())) continue;
            SdkAttachDataHelper.checkStatusOfSdksAttachedToProject(project);
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    private static void handleNotAvailableSDKError(String sdkId, IProject project, String errorMessage) {
        MissedSdkMarker.create((String)sdkId, (IProject)project, (String)errorMessage);
        SdkCoreActivator.getInstance().logError(errorMessage);
    }

    private static void addAttachUpdateStatus(Element element, String configName, Set<UpdateStatus> attachUpdateStatuses) {
        UpdateStatus updateStatus = UpdateStatus.createUpdateStatus((Element)element, (String)configName);
        if (updateStatus != null) {
            attachUpdateStatuses.add(updateStatus);
        }
    }

    private static void initSdkConfigurationsAttachData(IProject project, SdkAttachData sdkAttachData) {
        String sdkId = sdkAttachData.getSdkId();
        String sdkAttachDataXml = new ProjectScope(project).getNode("com.nxp.s32ds.cle.ide.sdk.attached.sdks.data").get(sdkId, "");
        if (sdkAttachDataXml == null || sdkAttachDataXml.trim().length() == 0) {
            SdkCoreActivator.getInstance().logWarning(NLS.bind((String)"Unable to load SDK {0} attach data for project {1}.", (Object)sdkId, (Object)project.getName()));
            return;
        }
        try {
            Element rootElement = null;
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(sdkAttachDataXml.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                rootElement = parser.parse(bais).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!"attachData".equals(rootElement.getNodeName())) {
                SdkCoreActivator.getInstance().logWarning(NLS.bind((String)"Unable to load SDK {0} attach data for project {1}: wrong format.", (Object)sdkId, (Object)project.getName()));
                return;
            }
            NodeList configElements = rootElement.getElementsByTagName("config");
            int i = 0;
            while (i < configElements.getLength()) {
                Element configElement = (Element)configElements.item(i);
                String configurationName = configElement.getAttribute("name");
                if (!configurationName.isEmpty()) {
                    SdkAttachDataHelper.loadAttachedSdkChangedAttributeData(configElement, "option", configurationName, sdkAttachData);
                }
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to load SDK {0} attach data for project {1}.", (Object)sdkId, (Object)project.getName()), e);
        }
    }

    private static void loadAttachedSdkChangedAttributeData(Element configElement, String elementName, String configurationName, SdkAttachData sdkAttachData) {
        NodeList changesElements = configElement.getElementsByTagName(elementName);
        int i = 0;
        while (i < changesElements.getLength()) {
            UpdateStatus updateStatus = UpdateStatus.createUpdateStatus((Element)((Element)changesElements.item(i)), (String)configurationName);
            if (updateStatus != null) {
                sdkAttachData.getAttachData().computeIfAbsent(configurationName, s -> new ArrayList()).add(updateStatus);
            }
            ++i;
        }
    }
}

