/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core;

import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HeadlessSdkLoad
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Map args = context.getArguments();
        String[] appArgs = (String[])args.get("application.args");
        String dirPath = "";
        if (appArgs != null && appArgs.length > 1) {
            if (!appArgs[0].equals("-sdkPath")) {
                SdkCoreActivator.getInstance().logError("Headless: Please add mandatory arguments -sdkPath followed by the location of the SDK");
                return IApplication.EXIT_OK;
            }
            dirPath = appArgs[1];
            HeadlessSdkLoad.execute(dirPath);
        } else {
            SdkCoreActivator.getInstance().logError("Headless: Please add mandatory arguments -sdkPath %SDKDirectory% ");
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    public void run() {
    }

    private static void execute(String dirPath) throws Exception {
        try {
            File file = new File(dirPath).getCanonicalFile();
            File swintegrationDir = new File(file.getParent()).getCanonicalFile();
            ArrayList<String> sdkIntegrationManifests = HeadlessSdkLoad.getMainIntegrationManifests(String.valueOf(swintegrationDir.getParent().toString()) + File.separator + "integration");
            int i = 0;
            while (i < sdkIntegrationManifests.size()) {
                String sdkIntegrationManifestFilePath = sdkIntegrationManifests.get(i);
                HeadlessSdkLoad.readFromManifest(sdkIntegrationManifestFilePath);
                ++i;
            }
            ArrayList<String> sdkManifests = HeadlessSdkLoad.getAllSDKManifests(dirPath);
            int i2 = 0;
            while (i2 < sdkManifests.size()) {
                String sdkManifestFilePath = sdkManifests.get(i2);
                String sdkManifestXml = HeadlessSdkLoad.getSdkManifestXml(sdkManifestFilePath);
                SdkDescriptorParser parser = new SdkDescriptorParser();
                parser.loadSdks(sdkManifestXml, sdkManifestFilePath, null, dirPath, SdkType.EXTERNAL);
                ++i2;
            }
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError("Headless: Cannot properly load SDK", e);
        }
    }

    private static String getSdkManifestXml(String sdkManifestFilePath) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Paths.get(sdkManifestFilePath, new String[0]).toFile()));){
            return SdkManagementUtils.getSdksManifestXml(bis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayList<String> getAllSDKManifests(String SDKDir) {
        ArrayList<String> sdkManifests = new ArrayList<String>();
        try {
            File dir = new File(SDKDir);
            String manifests = "";
            String[] extensions = new String[]{"xml"};
            List files = (List)FileUtils.listFiles((File)dir.getCanonicalFile(), (String[])extensions, (boolean)true);
            for (File file : files) {
                if (!file.getName().startsWith("itm") || file.getName().contains("collateral")) continue;
                manifests = file.getAbsolutePath();
                sdkManifests.add(manifests);
            }
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError("Headless: Unable to get manifests from SDK folder", e);
        }
        return sdkManifests;
    }

    public static ArrayList<String> getMainIntegrationManifests(String SDKIntegrationDir) {
        ArrayList<String> sdkManifests = new ArrayList<String>();
        try {
            File dir = new File(SDKIntegrationDir);
            String swintegrationmanifests = "";
            String[] extensions = new String[]{"xml"};
            List files = (List)FileUtils.listFiles((File)dir.getCanonicalFile(), (String[])extensions, (boolean)true);
            for (File file : files) {
                swintegrationmanifests = file.getAbsolutePath();
                sdkManifests.add(swintegrationmanifests);
            }
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError("Headless: Unable to get manifests from integration folder", e);
        }
        return sdkManifests;
    }

    public static void readFromManifest(String strFile) {
        try {
            String swintegrationmanifests = strFile;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(swintegrationmanifests);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("variable");
            int temp = 0;
            while (temp < nList.getLength()) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() == 1) {
                    Element eElement = (Element)nNode;
                    HeadlessSdkLoad.createEnvironment(eElement.getAttribute("name").toString(), eElement.getAttribute("value").toString(), "", true, false);
                }
                ++temp;
            }
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError("Headless: Unable to get environment variable from manifest", e);
        }
    }

    public static void createEnvironment(String name, String value, String description, boolean isSystem, boolean isReadOnly) {
        IValueVariable valueVariable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        if (valueVariable != null) {
            if (valueVariable.isReadOnly() != isReadOnly) {
                HeadlessSdkLoad.addEnvironment(name, value, description, isReadOnly);
            } else {
                valueVariable.setValue(value);
            }
        } else {
            HeadlessSdkLoad.addEnvironment(name, value, description, isReadOnly);
        }
    }

    private static void addEnvironment(String name, String value, String description, boolean readOnly) {
        String existingValue;
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable existingValueVariable = stringVariableManager.getValueVariable(name);
        if (existingValueVariable != null && (existingValue = existingValueVariable.getValue()) != null && existingValue.equals(value)) {
            return;
        }
        IValueVariable valueVariable = stringVariableManager.newValueVariable(name, description, readOnly, value);
        try {
            stringVariableManager.addVariables(new IValueVariable[]{valueVariable});
        }
        catch (Exception e) {
            SdkCoreActivator.getInstance().logError("Headless: Unable to add value to environment variable", e);
        }
    }
}

