/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.Arrays;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;

public class CrossTriggerSetupConditionTester
extends PropertyTester {
    private static final String CROSS_TRIGGER_SETUP_PROPERTY = "crossTriggerSetupProperty";
    private static final ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (CROSS_TRIGGER_SETUP_PROPERTY.equals(property)) {
            return this.crossTriggerSetupProperty(expectedValue);
        }
        return false;
    }

    private boolean crossTriggerSetupProperty(Object expectedValue) {
        boolean hasGroupLaunch = Arrays.stream(manager.getLaunches()).anyMatch(launch -> this.getLaunchConfigurationTypeId((ILaunch)launch).equals("com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchConfigurationType"));
        if (expectedValue == null || !hasGroupLaunch) {
            return false;
        }
        ILaunch[] launches = (ILaunch[])Arrays.stream(manager.getLaunches()).filter(launch -> !launch.isTerminated() && this.getLaunchConfigurationTypeId((ILaunch)launch).equals("com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType")).toArray(ILaunch[]::new);
        if (launches.length < 2) {
            return Boolean.FALSE.equals(expectedValue);
        }
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch2 = iLaunchArray[n2];
            DeviceCoreDescriptor deviceDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)this.getDeviceCoreId(launch2));
            if (!deviceDescriptor.getCrossTriggerSupport()) {
                return Boolean.FALSE.equals(expectedValue);
            }
            ++n2;
        }
        return Boolean.TRUE.equals(expectedValue);
    }

    private String getDeviceCoreId(ILaunch launch) {
        String deviceCoreId = "";
        try {
            deviceCoreId = (String)launch.getLaunchConfiguration().getAttributes().get("com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId");
        }
        catch (CoreException coreException) {
            deviceCoreId = "";
        }
        return deviceCoreId;
    }

    private String getLaunchConfigurationTypeId(ILaunch launch) {
        String launchConfigTypeID = "";
        try {
            launchConfigTypeID = launch.getLaunchConfiguration().getType().getIdentifier();
        }
        catch (CoreException coreException) {
            launchConfigTypeID = "";
        }
        return launchConfigTypeID;
    }
}

