/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui;

import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DSMultipleElfTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerStartupTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerUIActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DSMultipleElfParams;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class MultipleElf {
    public static final String ATTRIBUTE = "com.nxp.s32ds.debug.ide.s32debugger.core.multiple.elf";
    private static final int BINARY_COMBO_WIDTH_HINT = 100;
    private static final int PATH_COMBO_WIDTH_HINT = 555;
    private static final String DEFAULT_STRING = "";
    private static final String[] ELF_FORMAT_TYPES = S32DSMultipleElfParams.MULTIPLE_OBJECTS_ELF_FORMAT_TYPES;
    private static final String[] BIN_FORMAT_TYPES = S32DSMultipleElfParams.MULTIPLE_OBJECTS_BIN_FORMAT_TYPES;
    private static final String ALL_FILES_FORMAT = "*.*";
    private static final String HEX_CHARACTERS = "abcdef";
    private static final String FILE_SYSTEM_EXTENSION_DELIMITATOR = ";";
    private static final String WORKSPACELOC_VAR = "workspace_loc";
    private static final String MAP_ERROR = "No mapped element to this composite was found";
    private ScrolledComposite parentScrolledComposite;
    private Composite mainComposite;
    private Map<Composite, MultipleElfElement> composite2object;
    private Runnable scheduleUpdateJob;

    public MultipleElf(Composite parent, ScrolledComposite scrolledComposite, Runnable update) {
        this.parentScrolledComposite = scrolledComposite;
        this.scheduleUpdateJob = update;
        this.composite2object = new LinkedHashMap<Composite, MultipleElfElement>();
        this.createControl(parent);
    }

    private void createControl(Composite parent) {
        Composite addNewElement = new Composite(parent, 0);
        addNewElement.setLayout((Layout)new GridLayout(2, false));
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        SWTUtils.createLabel((Composite)addNewElement, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Specify_additional_source_object_to_be_loaded);
        Button addButton = SWTUtils.createButton((Composite)addNewElement, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Add, (int)8);
        addButton.addSelectionListener((SelectionListener)this.addObjectFileUI(parent));
    }

    private SelectionAdapter addObjectFileUI(Composite parent) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleElf.this.createUIForElement(new MultipleElfElement());
            }
        };
    }

    private SelectionAdapter removeObjectElement() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Button) {
                    Button but = (Button)obj;
                    Composite parent = but.getParent();
                    if (MultipleElf.this.composite2object.containsKey(parent)) {
                        MultipleElf.this.composite2object.remove(parent);
                    }
                    parent.dispose();
                    MultipleElf.this.resizeComposite();
                    MultipleElf.this.scheduleUpdateJob.run();
                }
            }
        };
    }

    private ModifyListener checkAndSetType() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Object obj = event.getSource();
                if (!(obj instanceof Text)) {
                    return;
                }
                Text text = (Text)obj;
                Composite parent = text.getParent();
                if (!MultipleElf.this.composite2object.containsKey(parent)) {
                    S32DebuggerUIActivator.getInstance().logError(MultipleElf.MAP_ERROR, new Exception());
                    return;
                }
                MultipleElfElement element = MultipleElf.this.composite2object.get(parent);
                element.setPath(text.getText());
                if (!MultipleElf.setType(element)) {
                    MultipleElf.this.scheduleUpdateJob.run();
                    return;
                }
                for (Control control : element.getHelpControls()) {
                    control.dispose();
                }
                element.newList();
                if (element.getType().equals((Object)MultipleElfType.BINARY_FORMAT)) {
                    MultipleElf.this.createOffsetControlsForBinary(parent, element);
                    MultipleElf.this.createAddSymbolsForBin(parent, element);
                    MultipleElf.this.scheduleUpdateJob.run();
                    return;
                }
                if (element.getType().equals((Object)MultipleElfType.ELF_FORMAT)) {
                    MultipleElf.this.createAddSymbolsControl(parent, element);
                    MultipleElf.this.resizeComposite();
                    return;
                }
                MultipleElf.this.resizeComposite();
                MultipleElf.this.scheduleUpdateJob.run();
            }
        };
    }

    private void createAddSymbolsForBin(Composite parent, final MultipleElfElement element) {
        element.addHelpControl((Control)SWTUtils.createLabel((Composite)parent, (String)DEFAULT_STRING));
        Button loadSymbols = SWTUtils.createButton((Composite)parent, (String)S32DebuggerStartupTabMessages.S32DebuggerStartupTab_load_symbols_button, (int)32);
        element.addHelpControl((Control)loadSymbols);
        element.addHelpControl((Control)SWTUtils.createLabelWithHorizontalSpan((Composite)parent, (String)DEFAULT_STRING, (int)3));
        element.addHelpControl((Control)SWTUtils.createLabel((Composite)parent, (String)DEFAULT_STRING));
        final Composite composite2 = SWTUtils.createGridCellComposite((Composite)parent, (int)4, (int)4);
        element.addHelpControl((Control)composite2);
        final Text symbolsFilePath = SWTUtils.createWideText((Composite)composite2, (int)2052, (boolean)true, (int)1);
        symbolsFilePath.setText(element.getSymbolsPath());
        symbolsFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!(event.getSource() instanceof Text)) {
                    return;
                }
                Text symbolPath = (Text)event.getSource();
                element.setSymbolsPath(symbolPath.getText());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
        final Button browseWorkspaceForSymbols = SWTUtils.createButton((Composite)composite2, (String)S32DebuggerStartupTabMessages.S32DebuggerStartupTab_browse_workspace_button, (int)0);
        browseWorkspaceForSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleElf.this.handleBrowseWorkspaceButton(MultipleElf.DEFAULT_STRING, symbolsFilePath);
            }
        });
        final Button browseFileSystemForSymbols = SWTUtils.createButton((Composite)composite2, (String)S32DebuggerStartupTabMessages.S32DebuggerStartupTab_browse_file_system_button, (int)0);
        browseFileSystemForSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleElf.this.handleBrowseFileSystemButton(MultipleElf.DEFAULT_STRING, symbolsFilePath);
            }
        });
        loadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                element.setLoadSymbols(((Button)e.getSource()).getSelection());
                composite2.setEnabled(((Button)e.getSource()).getSelection());
                symbolsFilePath.setEnabled(((Button)e.getSource()).getSelection());
                browseWorkspaceForSymbols.setEnabled(((Button)e.getSource()).getSelection());
                browseFileSystemForSymbols.setEnabled(((Button)e.getSource()).getSelection());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
        loadSymbols.setSelection(element.isLoadSymbols());
        loadSymbols.notifyListeners(13, new Event());
        this.resizeComposite();
    }

    private String handleBrowseWorkspaceButton(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(DEFAULT_STRING);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        String fileLoc = null;
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(WORKSPACELOC_VAR, arg);
            text.setText(fileLoc);
        }
        return Objects.requireNonNullElse(fileLoc, DEFAULT_STRING);
    }

    private String handleBrowseFileSystemButton(String title, Text text) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        CharSequence[] extension = Arrays.copyOf(ELF_FORMAT_TYPES, ELF_FORMAT_TYPES.length + BIN_FORMAT_TYPES.length);
        System.arraycopy(BIN_FORMAT_TYPES, 0, extension, ELF_FORMAT_TYPES.length, BIN_FORMAT_TYPES.length);
        extension = (String[])Arrays.stream(extension).map(ext -> "*" + ext).toArray(String[]::new);
        dialog.setFilterExtensions(new String[]{String.join((CharSequence)FILE_SYSTEM_EXTENSION_DELIMITATOR, extension), ALL_FILES_FORMAT});
        dialog.setText(title);
        String path = dialog.open();
        if (path != null) {
            text.setText(path);
        }
        return Objects.requireNonNullElse(path, DEFAULT_STRING);
    }

    private void createAddSymbolsControl(Composite parent, final MultipleElfElement element) {
        element.addHelpControl((Control)SWTUtils.createLabel((Composite)parent, (String)DEFAULT_STRING));
        final Button loadSymbols = SWTUtils.createButtonWithHorizontalSpan((Composite)parent, (String)S32DebuggerStartupTabMessages.S32DebuggerStartupTab_load_symbols_button, (int)32, (int)2);
        element.addHelpControl((Control)loadSymbols);
        loadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                element.setLoadSymbols(loadSymbols.getSelection());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
        loadSymbols.setSelection(element.isLoadSymbols());
        loadSymbols.notifyListeners(13, new Event());
    }

    private void createOffsetControlsForBinary(Composite parent, final MultipleElfElement element) {
        element.addHelpControl((Control)SWTUtils.createLabel((Composite)parent, (String)DEFAULT_STRING));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        element.addHelpControl((Control)composite);
        element.addHelpControl((Control)SWTUtils.createLabel((Composite)composite, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Binary_offset_hex));
        Text offset = SWTUtils.createTextWithWidthHint((Composite)composite, (int)2048, (int)100, (int)0);
        offset.setText(element.getOffset());
        offset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!(event.getSource() instanceof Text)) {
                    return;
                }
                Text offset = (Text)event.getSource();
                element.setOffset(offset.getText());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
        offset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = MultipleElf.this.verifyHex(e);
            }
        });
        element.addHelpControl((Control)offset);
        element.addHelpControl((Control)SWTUtils.createLabelWithHorizontalSpan((Composite)parent, (String)DEFAULT_STRING, (int)3));
        this.resizeComposite();
    }

    private boolean verifyHex(VerifyEvent e) {
        return Character.isDigit(e.character) || Character.isISOControl(e.character) || HEX_CHARACTERS.contains(String.valueOf(e.character).toLowerCase());
    }

    private static boolean setType(MultipleElfElement element) {
        String path = element.getPath();
        MultipleElfType lastType = element.getType();
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        }
        catch (CoreException e) {
            element.setType(MultipleElfType.UNDEFINED);
            S32DebuggerUIActivator.getInstance().log(e.getStatus());
            return !element.getType().equals((Object)lastType);
        }
        if (!new File(path).exists()) {
            element.setType(MultipleElfType.UNDEFINED);
            return !element.getType().equals((Object)lastType);
        }
        if (Arrays.stream(ELF_FORMAT_TYPES).anyMatch(path::endsWith)) {
            element.setType(MultipleElfType.ELF_FORMAT);
            return !element.getType().equals((Object)lastType);
        }
        if (Arrays.stream(BIN_FORMAT_TYPES).anyMatch(path::endsWith)) {
            element.setType(MultipleElfType.BINARY_FORMAT);
            return !element.getType().equals((Object)lastType);
        }
        element.setType(MultipleElfType.UNDEFINED);
        return !lastType.equals((Object)element.getType());
    }

    private void resizeComposite() {
        this.parentScrolledComposite.setMinSize(this.parentScrolledComposite.getContent().computeSize(-1, -1));
        this.parentScrolledComposite.layout(true, true);
    }

    public String getValueForAttribute() {
        StringBuilder buffer = new StringBuilder();
        for (MultipleElfElement command : this.composite2object.values()) {
            if (command.getType().equals((Object)MultipleElfType.BINARY_FORMAT)) {
                buffer.append(command.getPath()).append("#").append(command.getOffset().isEmpty() ? "0" : command.getOffset()).append("#").append(command.loadSymbols).append("#").append(command.loadSymbols ? command.symbolsPath : DEFAULT_STRING).append(FILE_SYSTEM_EXTENSION_DELIMITATOR);
                continue;
            }
            if (command.getType().equals((Object)MultipleElfType.ELF_FORMAT)) {
                buffer.append(command.getPath()).append("#").append(command.isLoadSymbols()).append(FILE_SYSTEM_EXTENSION_DELIMITATOR);
                continue;
            }
            if (command.getPath().isEmpty()) continue;
            buffer.append(command.getPath()).append(FILE_SYSTEM_EXTENSION_DELIMITATOR);
        }
        return buffer.toString();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        for (Composite composite : this.composite2object.keySet()) {
            composite.dispose();
        }
        this.resizeComposite();
        this.composite2object = new LinkedHashMap<Composite, MultipleElfElement>();
        List<MultipleElfElement> elemens = MultipleElf.getElements(config);
        for (MultipleElfElement element : elemens) {
            element.setType(MultipleElfType.UNDEFINED);
            this.createUIForElement(element);
        }
    }

    private void createUIForElement(final MultipleElfElement element) {
        Composite composite = new Composite(this.mainComposite, 0);
        this.composite2object.put(composite, element);
        composite.setLayout((Layout)new GridLayout(5, false));
        SWTUtils.createLabel((Composite)composite, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Object_file);
        final Text file = SWTUtils.createTextWithWidthHint((Composite)composite, (int)2048, (int)555, (int)0);
        file.addModifyListener(this.checkAndSetType());
        Button workspaceButton = SWTUtils.createButton((Composite)composite, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Workspace, (int)8);
        Button fileSystemButton = SWTUtils.createButton((Composite)composite, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_File_System, (int)8);
        Button removeButton = SWTUtils.createButton((Composite)composite, (String)S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Remove, (int)8);
        removeButton.addSelectionListener((SelectionListener)this.removeObjectElement());
        this.resizeComposite();
        file.setText(element.getPath());
        workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = MultipleElf.this.handleBrowseWorkspaceButton(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Select_file_from_Workspace, file);
                element.setPath(path != MultipleElf.DEFAULT_STRING ? path : element.getPath());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
        fileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = MultipleElf.this.handleBrowseFileSystemButton(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Choose_object_file, file);
                element.setPath(path != MultipleElf.DEFAULT_STRING ? path : element.getPath());
                MultipleElf.this.scheduleUpdateJob.run();
            }
        });
    }

    public static List<MultipleElfElement> getElements(ILaunchConfiguration lc) {
        String[] split;
        String value = DEFAULT_STRING;
        ArrayList<MultipleElfElement> list = new ArrayList<MultipleElfElement>();
        try {
            value = lc.getAttribute(ATTRIBUTE, DEFAULT_STRING);
        }
        catch (CoreException e) {
            S32DebuggerUIActivator.getInstance().log(e.getStatus());
            return Collections.emptyList();
        }
        String[] stringArray = split = value.split(FILE_SYSTEM_EXTENSION_DELIMITATOR);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.isEmpty()) {
                String[] argSplit = arg.split("#");
                MultipleElfElement element = new MultipleElfElement();
                element.setPath(argSplit[0]);
                MultipleElf.setType(element);
                if (element.getType().equals((Object)MultipleElfType.BINARY_FORMAT)) {
                    element.setOffset(argSplit.length > 1 ? argSplit[1] : "0");
                    if (argSplit.length > 2) {
                        boolean loadSymbols = Boolean.parseBoolean(argSplit[2]);
                        element.setLoadSymbols(loadSymbols);
                        element.setSymbolsPath(loadSymbols && argSplit.length > 3 ? argSplit[3] : DEFAULT_STRING);
                    }
                }
                if (element.getType().equals((Object)MultipleElfType.ELF_FORMAT)) {
                    element.setLoadSymbols(argSplit.length > 1 ? Boolean.parseBoolean(argSplit[1]) : false);
                }
                list.add(element);
            }
            ++n2;
        }
        return list;
    }

    public void clearView() {
        for (Composite composite : this.composite2object.keySet()) {
            composite.dispose();
        }
        this.composite2object.clear();
    }

    public static class MultipleElfElement {
        public static final String DEFAULT_HEXA = "0";
        private String path = "";
        private MultipleElfType type = MultipleElfType.UNDEFINED;
        private String offset = "0";
        private boolean loadSymbols;
        private String symbolsPath = "";
        private List<Control> helpControls = new ArrayList<Control>();

        public String getPath() {
            return this.path;
        }

        public boolean isLoadSymbols() {
            return this.loadSymbols;
        }

        public void setLoadSymbols(boolean loadSymbols) {
            this.loadSymbols = loadSymbols;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public MultipleElfType getType() {
            return this.type;
        }

        public void setType(MultipleElfType type) {
            this.type = type;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public void addHelpControl(Control control) {
            this.helpControls.add(control);
        }

        public void removeHelpControl(Control control) {
            this.helpControls.remove(control);
        }

        public void newList() {
            this.helpControls = new ArrayList<Control>();
        }

        public List<Control> getHelpControls() {
            return this.helpControls;
        }

        public String getSymbolsPath() {
            return this.symbolsPath;
        }

        public void setSymbolsPath(String symbolsPath) {
            this.symbolsPath = symbolsPath;
        }

        public IStatus getStatus() {
            boolean isBinAndLoadSymbols;
            String path = this.path;
            String symbolsPath = this.symbolsPath;
            try {
                path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
                symbolsPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsPath);
            }
            catch (CoreException e) {
                S32DebuggerUIActivator.getInstance().log(e.getStatus());
                return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Something_went_wrong);
            }
            if (!new File(path).exists()) {
                return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), String.format(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_File_does_not_exist, path));
            }
            if (this.type == MultipleElfType.UNDEFINED) {
                return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), String.format(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_The_file_type_was_not_recognized, path));
            }
            boolean bl = isBinAndLoadSymbols = this.type == MultipleElfType.BINARY_FORMAT && this.loadSymbols;
            if (isBinAndLoadSymbols && symbolsPath.isEmpty()) {
                return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Specify_Symbols_binary);
            }
            String sPath = symbolsPath;
            if (isBinAndLoadSymbols) {
                if (Arrays.stream(ELF_FORMAT_TYPES).noneMatch(sPath::endsWith)) {
                    return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), String.format(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_Symbol_file_is_not_in_elf_format, symbolsPath, String.join((CharSequence)" ", ELF_FORMAT_TYPES)));
                }
            }
            if (isBinAndLoadSymbols && !new File(symbolsPath).exists()) {
                return new Status(4, S32DebuggerUIActivator.getInstance().getBundleId(), String.format(S32DSMultipleElfTabMessages.S32DSMultipleElfTab_File_does_not_exist, symbolsPath));
            }
            return new Status(0, S32DebuggerUIActivator.getInstance().getBundleId(), MultipleElf.DEFAULT_STRING);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultipleElfElement)) {
                return false;
            }
            MultipleElfElement element = (MultipleElfElement)obj;
            if (element == this) {
                return true;
            }
            return this.path.equals(element.path) && this.type.equals((Object)element.type) && (!this.type.equals((Object)MultipleElfType.BINARY_FORMAT) || this.offset.equals(element.offset));
        }
    }

    public static enum MultipleElfType {
        ELF_FORMAT,
        BINARY_FORMAT,
        UNDEFINED;

    }
}

