/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.entity.core;

import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntity;
import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntityDescriptor;
import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntityRegistry;
import com.nxp.s32ds.cle.runtime.migration.internal.entity.core.MigrationEntityCoreActivator;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MigrationEntityDescriptors {
    public static MigrationEntityRegistry getMigrationEntitesRegistry() {
        return MigrationEntityCoreActivator.getInstance().getMigrationEntitesRegistry();
    }

    public static List<MigrationEntityDescriptor> getMigrationEntityDescriptors() {
        return MigrationEntityDescriptors.getMigrationEntitesRegistry().getMigrationEntityDescriptors();
    }

    public static List<MigrationEntityDescriptor> getMigrationEntityDescriptorsByPorvider(String providerId) {
        return MigrationEntityDescriptors.getMigrationEntitesRegistry().getMigrationEntityDescriptors().stream().filter(p -> p.getProviderId().equals(providerId)).sorted(new Comparator<MigrationEntityDescriptor>(){

            @Override
            public int compare(MigrationEntityDescriptor o1, MigrationEntityDescriptor o2) {
                if (o2.getRank() > o1.getRank()) {
                    return 1;
                }
                return -1;
            }
        }).collect(Collectors.toList());
    }

    public static MigrationEntityDescriptor getMigrationEntityDescriptor(String entityId) {
        return MigrationEntityDescriptors.getMigrationEntitesRegistry().getMigrationEntityDescriptorById(entityId);
    }

    public static void addMigrationEntityDescriptor(MigrationEntityDescriptor descriptor) {
        MigrationEntityDescriptors.getMigrationEntitesRegistry().addMigrationEntityDescriptor(descriptor);
    }

    public static void removeMigrationEntityDescriptor(MigrationEntityDescriptor descriptor) {
        MigrationEntityDescriptors.getMigrationEntitesRegistry().removeMigrationEntityDescriptor(descriptor);
    }

    public static void removeMigrationEntityDescriptor(String entityId) {
        MigrationEntityDescriptors.getMigrationEntitesRegistry().removeMigrationEntityDescriptorById(entityId);
    }

    public static IStatus executeMigration(MigrationEntityDescriptor descriptor, Map<String, Object> attributes, IProgressMonitor monitor) {
        MigrationEntity migrationEntity = descriptor.getMigrationEntity();
        if (migrationEntity == null) {
            return Status.CANCEL_STATUS;
        }
        return migrationEntity.migrate(descriptor.getSourceId(), descriptor.getTargetId(), attributes, monitor);
    }
}

