/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.property;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.nxp.s32ds.cle.cdt.sdk.core.load.SdksLoader;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class SdkLoadPropertyTesters
extends PropertyTester {
    private static final String jobsDoneProperty = "jobsDone";
    private static final String isArmProperty = "isArm";
    private static final String RISC_V_PROJECT = "riscv";
    private static final String ARCH_ID = "arm";
    private static final String CONFIG_DATA_TAG = "hardware";
    private static IJobManager jobManager = Job.getJobManager();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (jobsDoneProperty.equals(property)) {
            return Objects.equals(expectedValue, SdkLoadPropertyTesters.testSdkJob()) && this.isArmProject();
        }
        if (isArmProperty.equals(property)) {
            return this.isArmProject();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isArmProject() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection == null || !(selection.getFirstElement() instanceof IProject)) {
            return false;
        }
        IProject project = (IProject)selection.getFirstElement();
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(project);
        String deviceCore = projectContextSettings.getDeviceCore2Context();
        Optional<CoreData> coreData = Hardware.instance().getModel(ARCH_ID).getCores().stream().filter(c -> c.getId().equalsIgnoreCase(deviceCore)).findFirst();
        ConfigurationData configData = null;
        if (!coreData.isPresent()) return true;
        configData = (ConfigurationData)coreData.get();
        while (configData.getParent() != null) {
            if (CONFIG_DATA_TAG.equalsIgnoreCase((configData = configData.getParent()).getTag())) return project != null && !RISC_V_PROJECT.equalsIgnoreCase(configData.getId());
        }
        return project != null && !RISC_V_PROJECT.equalsIgnoreCase(configData.getId());
    }

    public static boolean testSdkJob() {
        Job[] allJobs = jobManager.find(SdksLoader.class);
        return allJobs.length == 0;
    }
}

