/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.edit;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsImplementation;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkDescriptorBuilder;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameExistsValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkTargetFolderNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.SdkHeader;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.AbstractSdkResourceControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.BinaryResourcesControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.HeaderResourcesControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.LinkerFilesControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.OtherResourcesControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.SourceResourcesControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.SymbolsControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbol;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbolsHolder;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.LocationEditDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkDialogUsageMode;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkEditDialogConstants;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SdkEditDialog
extends TitleAreaDialog {
    private static final String EMPTY_PATH = "";
    private static final String BASE_PATH_PREFIX = "${";
    private static final String BASE_PATH_SUFFIX = "}";
    private static final int DEFAULT = 2052;
    private boolean helpDisplayed = false;
    private Button okButton;
    private Text sdkNameField;
    private Text sdkVersionField;
    private Text sdkTargetFolderNameField;
    private Text sdkDescField;
    private Text sdkEnvField;
    private Text sdkEnvType;
    private Text sdkPathField;
    private SourceResourcesControl sdkSourceFilesViewer;
    private HeaderResourcesControl sdkHeaderFilesViewer;
    private BinaryResourcesControl sdkBinaryFilesViewer;
    private OtherResourcesControl sdkOthersFilesViewer;
    private LinkerFilesControl sdkLinkerFilesViewer;
    private SdkType sdkType;
    private String sdkName;
    private String sdkVersion;
    private String sdkTargetFolderName;
    private String sdkDescription;
    private String oldSdkName;
    private String oldSdkVersion;
    private boolean isSdkChanged;
    private Map<String, Map<String, Set<SdkResource>>> sdkBinaries;
    private Map<String, Map<String, Set<SdkResource>>> sdkHeaders;
    private Map<String, Map<String, Set<SdkResource>>> sdkLinkerFiles;
    private Map<String, Map<String, Set<SdkResource>>> sdkResources;
    private Map<String, Map<String, Set<SdkResource>>> sdkSources;
    private Map<String, Map<String, Set<SdkResource>>> sdkIncludeFiles;
    private EnvironmetBackupData sdkEnv;
    private EnvironmetBackupData sdkEnvBackup;
    private IProject project;
    private FilterOptions filterOptions;
    private Map<String, SdkSymbolsHolder> symbolHoldersMap;
    private Map<String, ToolChainHolder> toolChainHolders;
    private ToolChainHolder rootToolChainHolder;
    private IValidator<String> nameValidator = new SdkNameValidator();
    private IValidator<String> versionValidator = new SdkVersionValidator();
    private IValidator<String> targetFolderNameValidator = new SdkTargetFolderNameValidator();
    private IValidator<String> environmentNameValidator = new SdkEnvironmentNameValidator();
    private IValidator<String> environmentNameExistsValidator = new SdkEnvironmentNameExistsValidator();
    private ModelSdk sdk;
    private SdkDescriptor sdkDescriptor;
    private final SdkDialogUsageMode dialogUsageMode;
    private EnvironmentGroup environmentGroup;
    private ResourcesGroup resourcesGroup;

    public static SdkEditDialog newCreateSdkDialog(Shell parentShell, SdkType sdkType, IProject project, FilterOptions filterOptions) {
        SdkEditDialog dialog = new SdkEditDialog(parentShell, SdkDialogUsageMode.CREATE_MODE, sdkType, project, filterOptions);
        ToolChainHolder rootToolChainHolder = filterOptions != null ? new ToolChainHolder(filterOptions.getToolChainsIdsString()) : new ToolChainHolder(null);
        dialog.setRootToolchainHolder(rootToolChainHolder);
        dialog.setToolChainHolders(new ToolChainHolder[0]);
        String toolChainId = rootToolChainHolder.getTCId();
        dialog.setSymbolHolders(Collections.singletonMap(toolChainId, new SdkSymbolsHolder(toolChainId)));
        return dialog;
    }

    public static SdkEditDialog newEditSdkDialog(Shell parentShell, SdkDescriptor sdkDescriptor, IProject project, FilterOptions filterOptions) {
        return new SdkEditDialog(parentShell, SdkDialogUsageMode.EDIT_MODE, sdkDescriptor, project, filterOptions);
    }

    public static SdkEditDialog newViewSdkDialog(Shell parentShell, SdkDescriptor sdkDescriptor, IProject project) {
        return new SdkEditDialog(parentShell, SdkDialogUsageMode.VIEW_MODE, sdkDescriptor, project, null);
    }

    private SdkEditDialog(Shell parentShell, SdkDialogUsageMode dialogUsageMode, SdkType sdkType, IProject project, FilterOptions filterOptions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.dialogUsageMode = dialogUsageMode;
        this.sdkType = sdkType;
        this.project = project;
        this.filterOptions = filterOptions != null ? filterOptions : FilterOptionsImplementation.EMPTY_FILTER;
    }

    private SdkEditDialog(Shell parentShell, SdkDialogUsageMode dialogUsageMode, SdkDescriptor sdkDescriptor, IProject project, FilterOptions filterOptions) {
        this(parentShell, dialogUsageMode, sdkDescriptor.getType(), project, filterOptions);
        this.sdk = Objects.requireNonNull(SdkDescriptorParser.getSdkByDescriptor(sdkDescriptor));
        this.sdkDescriptor = sdkDescriptor;
        SdkHeader.SdkHeaderParameters parameters = this.sdk.getHeader().getSdkHeaderParameters();
        this.setSdkHeaderParameters(parameters);
        this.setSymbolHolders(this.sdk.getSymbols(null));
        this.setToolChainHolders(this.sdk.getToolchains());
        this.setRootToolchainHolder(this.sdk.getRoot());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogUsageMode.getDialogTitle());
        shell.setSize(600, 800);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).applyTo((Control)contents);
        this.setTitle(this.dialogUsageMode.getDialogTitle());
        this.setMessage(this.dialogUsageMode.getDialogHeader());
        this.createNames(contents);
        this.environmentGroup = new EnvironmentGroup();
        this.environmentGroup.create(contents);
        this.resourcesGroup = new ResourcesGroup();
        this.resourcesGroup.create(contents);
        this.fillEnvData(this.isCreateMode());
        this.sdkEnvBackup = new EnvironmetBackupData(this.sdk != null ? EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)this.sdk.getHeader().getId()) : null);
        Dialog.applyDialogFont((Control)parentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.dialogUsageMode.getContextHelpId());
        return contents;
    }

    protected void okPressed() {
        if (!this.isMissingSdksInfoDialog(Display.getCurrent().getActiveShell(), this.sdkDescriptor)) {
            this.cancelPressed();
            return;
        }
        if (this.isEditableMode()) {
            String rootToolChainHolderId = this.rootToolChainHolder != null ? this.rootToolChainHolder.getTCId() : null;
            this.sdkBinaries = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkBinaries.put(rootToolChainHolderId, this.sdkBinaryFilesViewer.getChecked());
            this.sdkHeaders = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkHeaders.put(rootToolChainHolderId, this.sdkHeaderFilesViewer.getChecked());
            this.sdkLinkerFiles = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkLinkerFiles.put(rootToolChainHolderId, this.sdkLinkerFilesViewer.getChecked());
            this.sdkResources = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkResources.put(rootToolChainHolderId, this.sdkOthersFilesViewer.getChecked());
            this.sdkSources = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkSources.put(rootToolChainHolderId, this.sdkSourceFilesViewer.getChecked());
            this.sdkIncludeFiles = new LinkedHashMap<String, Map<String, Set<SdkResource>>>();
            this.sdkIncludeFiles.put(rootToolChainHolderId, this.sdkHeaderFilesViewer.getIncludeFiles());
            if (this.sdkEnv != null) {
                this.sdkEnv.create(true);
            }
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.rollbackEnvironmentChanges();
        super.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    private void createNames(Composite contents) {
        this.sdkNameField = this.fieldWithLabel(contents, Messages.SdkDialog_label_name, this.getSDKName(), 2052, Id.NAME, SdkEditDialogConstants.NAME_FIELD_CONTEXT_HELP_ID);
        this.sdkVersionField = this.fieldWithLabel(contents, Messages.SdkDialog_label_version, this.getSDKVersion(), 2052, Id.VERSION, SdkEditDialogConstants.VERSION_FIELD_CONTEXT_HELP_ID);
        this.sdkTargetFolderNameField = this.fieldWithLabel(contents, Messages.SdkDialog_label_target_folder_name, this.getSdkTargetFolderName(), 2052, Id.TARGET_FOLDER_NAME, SdkEditDialogConstants.TARGET_FOLDER_NAME_FIELD_CONTEXT_HELP_ID);
        this.sdkDescField = this.fieldWithLabel(contents, Messages.SdkDialog_label_description, this.getSDKDescription(), 2116, Id.DESCRIPTION, SdkEditDialogConstants.DESCRIPTION_FIELD_CONTEXT_HELP_ID);
    }

    private void setViewerInput(AbstractSdkResourceControl control, AbstractSdkResourceControl.InputWrapper inputWrapper, boolean isExpand) {
        if (inputWrapper != null) {
            control.setInput(inputWrapper, this.isCreateMode(), isExpand);
        }
    }

    private AbstractSdkResourceControl.InputWrapper getInputWrapper(String rootPath) {
        String substitutedRootPath = null;
        if (rootPath != null) {
            try {
                substitutedRootPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(rootPath);
            }
            catch (CoreException coreException) {
                SdkUiActivator.getInstance().logError("Unable to substitute SDK base path");
            }
        }
        if (substitutedRootPath != null) {
            return AbstractSdkResourceControl.wrap(new AbstractSdkResourceControl.SdkDataHolder(this.sdk, substitutedRootPath));
        }
        return null;
    }

    private Text fieldOnly(Composite parent, String fieldText, int fieldStyle, Id validationId, GridData fieldLayoutData, String context) {
        int readOnlyStyle = this.isReadonlyMode() ? 8 : 0;
        Text field = new Text(parent, fieldStyle | readOnlyStyle);
        field.setText(fieldText);
        field.setLayoutData((Object)(fieldLayoutData != null ? fieldLayoutData : new GridData(4, 0x1000000, true, false, 2, 1)));
        field.addModifyListener((ModifyListener)new ValidatingModificationListener(validationId));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)field, context);
        field.addFocusListener((org.eclipse.swt.events.FocusListener)new FocusListener(context));
        return field;
    }

    private Text fieldWithLabel(Composite parent, String labelText, String fieldText, int fieldStyle, Id validationId, String context) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return this.fieldOnly(parent, fieldText, fieldStyle, validationId, null, context);
    }

    private boolean validate() {
        IStatus status;
        this.setErrorMessage(null);
        if (this.sdkVersion == null) {
            this.sdkVersion = EMPTY_PATH;
        }
        if ((status = SdkEditDialog.validateField(this.sdkName, this.nameValidator)).isOK()) {
            status = SdkEditDialog.validateField(this.sdkVersion, this.versionValidator);
        }
        if (status.isOK() && (this.isCreateMode() || this.isEditMode() && (!this.sdkName.equals(this.oldSdkName) || !this.sdkVersion.equals(this.oldSdkVersion))) && SdkManagementUtils.isSdkExists((String)this.sdkName, (String)this.sdkVersion)) {
            status = SdkUiActivator.getInstance().createError(com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages.SdkValidation_error_sdk_with_same_name_version_exists);
        }
        boolean isNameVersionValid = status.isOK();
        String envName = this.sdkEnvField.getText();
        if (status.isOK()) {
            status = SdkEditDialog.validateField(this.sdkTargetFolderName, this.targetFolderNameValidator);
        }
        if (status.isOK() && (status = SdkEditDialog.validateField(envName, this.environmentNameValidator)).isOK() && this.sdkEnv != null && !this.sdkEnv.isSystem) {
            status = SdkEditDialog.validateField(envName, this.environmentNameExistsValidator);
        }
        if (status.isOK() && this.sdkPathField.getText().trim().isEmpty()) {
            status = SdkUiActivator.getInstance().createError(Messages.SdkEditDialog_error_empty_sdk_location);
        }
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setMessage(this.dialogUsageMode.getDialogHeader());
        } else {
            this.setErrorMessage(status.getMessage());
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(status.isOK());
        }
        this.environmentGroup.enableChangeLocation(isNameVersionValid && this.isEditableMode());
        this.environmentGroup.showResolvedLocation(this.getErrorMessage() == null);
        return status.isOK();
    }

    private static IStatus validateField(String fieldValue, IValidator<String> validator) {
        return validator.validate((Object)fieldValue);
    }

    private String getSDKName() {
        return Objects.toString(this.sdkName, EMPTY_PATH);
    }

    private void setSDKName(String sdkName) {
        this.oldSdkName = sdkName;
        this.sdkName = sdkName;
    }

    private String getSDKVersion() {
        return Objects.toString(this.sdkVersion, EMPTY_PATH).trim();
    }

    private void setSDKVersion(String sdkVersion) {
        this.oldSdkVersion = sdkVersion;
        this.sdkVersion = sdkVersion;
    }

    private String getSdkTargetFolderName() {
        return Objects.toString(this.sdkTargetFolderName, EMPTY_PATH);
    }

    private void setSdkTargetFolderName(String sdkTargetFolderName) {
        this.sdkTargetFolderName = sdkTargetFolderName;
    }

    private String getSDKDescription() {
        return Objects.toString(this.sdkDescription, EMPTY_PATH);
    }

    private void setSDKDescription(String sdkDescription) {
        this.sdkDescription = sdkDescription;
    }

    private String getSDKPath() {
        return this.sdkEnv == null ? EMPTY_PATH : Objects.toString(this.sdkEnv.value, EMPTY_PATH);
    }

    private void setSymbolHolders(Map<String, SdkSymbolsHolder> symbolHolders) {
        this.symbolHoldersMap = symbolHolders;
    }

    private void setToolChainHolders(ToolChainHolder[] toolChainHolders) {
        this.toolChainHolders = new LinkedHashMap<String, ToolChainHolder>();
        if (toolChainHolders == null) {
            return;
        }
        Arrays.stream(toolChainHolders).forEach(tch -> {
            ToolChainHolder toolChainHolder = this.toolChainHolders.put(tch.getTCId(), (ToolChainHolder)tch);
        });
    }

    private void setRootToolchainHolder(ToolChainHolder rootToolChainHolder) {
        this.rootToolChainHolder = rootToolChainHolder;
    }

    private void setSdkHeaderParameters(SdkHeader.SdkHeaderParameters parameters) {
        this.setSDKName(parameters.getName());
        this.setSDKVersion(parameters.getVersion());
        this.setSDKDescription(parameters.getDescription());
        this.setSdkTargetFolderName(parameters.getTargetFolderName());
        this.sdkEnv = new EnvironmetBackupData(this.sdk != null ? EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)this.sdk.getHeader().getId()) : null);
    }

    private boolean isCreateMode() {
        return this.dialogUsageMode.isCreateMode();
    }

    private boolean isEditMode() {
        return this.dialogUsageMode.isEditMode();
    }

    private boolean isEditableMode() {
        return this.dialogUsageMode.isCreateMode() || this.dialogUsageMode.isEditMode();
    }

    private boolean isReadonlyMode() {
        return this.dialogUsageMode.isReadonlyMode();
    }

    private List<SdkDescriptor> getVariableLinkedSdks(String sdkId) {
        return SdkDescriptors.getSdkDescriptors().stream().filter(sdkDescriptor -> sdkDescriptor.getBasePath().equals(BASE_PATH_PREFIX + sdkId.toUpperCase() + BASE_PATH_SUFFIX)).collect(Collectors.toList());
    }

    private String getVariableAffectedSdksBriefInfo(List<SdkDescriptor> varLinkedSdks) {
        return String.join((CharSequence)", ", varLinkedSdks.stream().map(sdk -> SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdk, (boolean)false)).collect(Collectors.toList()));
    }

    public boolean isMissingSdksInfoDialog(Shell parentShell, SdkDescriptor sdkDescriptor) {
        if (sdkDescriptor == null) {
            return true;
        }
        List<SdkDescriptor> varLinkedSdks = this.getVariableLinkedSdks(sdkDescriptor.getId());
        if (!varLinkedSdks.isEmpty() && (this.isSdkEnvironmentBackupHasChanged() || this.isSdkChanged)) {
            return MessageDialog.openConfirm((Shell)parentShell, (String)NLS.bind((String)Messages.SdkEditDialog_linked_variable_missing_sdks_warning_message_title, (Object)this.sdk.getId().toUpperCase()), (String)NLS.bind((String)Messages.SdkEditDialog_linked_variable_missing_sdks_warning_message_dialog, (Object)SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdkDescriptor, (boolean)false), (Object)this.getVariableAffectedSdksBriefInfo(varLinkedSdks)));
        }
        return true;
    }

    public SdkDescriptor getSdkDescriptor() {
        String foToolChainId;
        if (this.isReadonlyMode()) {
            return null;
        }
        if (!this.isCreateMode()) {
            SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)this.sdk.getHeader().getId());
        }
        SdkDescriptorBuilder builder = new SdkDescriptorBuilder();
        builder.createHeader(this.getSDKName(), this.getSDKVersion(), this.getSDKPath(), this.sdkType, this.getSDKDescription(), this.getSdkTargetFolderName());
        builder.setEnvironment(this.sdkEnv.name, this.sdkEnv.value, this.sdkEnv.isSystem);
        if (SdkType.WORKSPACE != this.sdkType) {
            builder.setFilterOptions(this.filterOptions);
        }
        String rootToolChainHolderId = null;
        rootToolChainHolderId = !this.isCreateMode() ? this.sdk.getRoot().getTCId() : ((foToolChainId = this.filterOptions.getToolChainsIdsString()) != null && !foToolChainId.isEmpty() ? foToolChainId : null);
        this.sdkBinaries.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.BINARY_FILE, path.isCopy());
        });
        this.sdkHeaders.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.HEADER_FILE, path.isCopy());
        });
        this.sdkIncludeFiles.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.INCLUDE_FILE, path.isCopy());
        });
        this.sdkLinkerFiles.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.LINKER_FILE, path.isCopy());
        });
        this.sdkResources.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.RESOURCE_FILE, path.isCopy());
        });
        this.sdkSources.getOrDefault(rootToolChainHolderId, Collections.emptyMap()).values().stream().flatMap(Collection::stream).map(SdkResource::getPath).filter(path -> !path.toFile().isDirectory()).forEach(path -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(path.toOSString(), ResourceSdkKind.SOURCE_FILE, path.isCopy());
        });
        SdkSymbolsHolder symbolsHolder = this.symbolHoldersMap.get(rootToolChainHolderId);
        if (symbolsHolder != null) {
            symbolsHolder.getSymbolsByType(SymbolSdkKind.DEFINED_SYMBOL).stream().map(SdkSymbol::getSymbolName).forEach(symbolName -> {
                SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addSymbol(symbolName, SymbolSdkKind.DEFINED_SYMBOL);
            });
            symbolsHolder.getSymbolsByType(SymbolSdkKind.UNDEFINED_SYMBOL).stream().map(SdkSymbol::getSymbolName).forEach(symbolName -> {
                SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addSymbol(symbolName, SymbolSdkKind.UNDEFINED_SYMBOL);
            });
        }
        if (SdkType.PROJECT_LOCAL == this.sdkType && this.project != null) {
            builder.setProjectName(this.project.getName());
        }
        return builder.buildAndRegister();
    }

    private void fillEnvData(boolean update) {
        if (this.sdkEnv != null) {
            this.sdkEnvField.setText(this.sdkEnv.name);
            this.sdkEnvType.setText(this.sdkEnv.isSystem ? Messages.SdkDialog_text_system_environment_type : Messages.SdkDialog_text_user_environment_type);
            this.sdkPathField.setText(this.sdkEnv.value);
            boolean expand = false;
            String sdkPath = this.sdkPathField.getText();
            if (update) {
                ExtendedPath.setSilentMode(true);
                AbstractSdkResourceControl.InputWrapper inputWrapper = this.getInputWrapper(sdkPath);
                this.setViewerInput(this.sdkSourceFilesViewer, inputWrapper, expand);
                this.setViewerInput(this.sdkHeaderFilesViewer, inputWrapper, expand);
                this.setViewerInput(this.sdkBinaryFilesViewer, inputWrapper, expand);
                this.setViewerInput(this.sdkOthersFilesViewer, inputWrapper, expand);
                this.setViewerInput(this.sdkLinkerFilesViewer, inputWrapper, expand);
                ExtendedPath.setSilentMode(false);
            }
        } else {
            this.sdkEnvField.setText(EMPTY_PATH);
            this.sdkEnvType.setText(Messages.SdkDialog_text_environment_not_set);
            this.sdkPathField.setText(EMPTY_PATH);
            this.resourcesGroup.clearSelectedComponentsOnChangeSDKLocation();
        }
    }

    private void rollbackEnvironmentChanges() {
        if (this.sdkEnv == null) {
            return;
        }
        if (this.isCreateMode()) {
            SdkEnvironmentUtils.removeEnvironment((String)this.sdkEnv.name, (boolean)this.sdkEnv.isSystem);
        } else if (this.isEditMode() && this.isSdkEnvironmentBackupHasChanged()) {
            SdkEnvironmentUtils.removeEnvironment((String)this.sdkEnv.name, (boolean)this.sdkEnv.isSystem);
            this.sdkEnvBackup.create(true);
        }
    }

    private boolean isSdkEnvironmentBackupHasChanged() {
        return this.sdkEnvBackup != null && this.sdkEnvBackup.isValid() && this.sdkEnv != null && this.sdkEnvBackup.hasChanged(this.sdkEnv);
    }

    private class EnvironmentGroup {
        private Composite fieldsComposite;
        private Label reslovedLocationLabel;
        private Label resolvedLocationText;
        private Button changeButton;

        private EnvironmentGroup() {
        }

        private void create(Composite contents) {
            String envName = SdkEditDialog.this.sdkEnv != null ? SdkEditDialog.this.sdkEnv.name : SdkEditDialog.EMPTY_PATH;
            Group group = new Group(contents, 0);
            group.setText(Messages.SdkDialog_label_environment_group);
            group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
            group.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(3, 1).create());
            this.fieldsComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).create())).create((Widget)group);
            WidgetFactory.label((int)0).text(Messages.SdkDialog_label_variable).create((Widget)this.fieldsComposite);
            SdkEditDialog.this.sdkEnvField = (Text)((TextFactory)WidgetFactory.text((int)18440).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).text(envName).create((Widget)this.fieldsComposite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)SdkEditDialog.this.sdkEnvField, SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID);
            SdkEditDialog.this.sdkEnvField.addFocusListener((org.eclipse.swt.events.FocusListener)new FocusListener(SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID));
            SdkEditDialog.this.sdkEnvType = (Text)((TextFactory)WidgetFactory.text((int)16392).enabled(false)).create((Widget)this.fieldsComposite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)SdkEditDialog.this.sdkEnvType, SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID);
            SdkEditDialog.this.sdkEnvType.addFocusListener((org.eclipse.swt.events.FocusListener)new FocusListener(SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID));
            WidgetFactory.label((int)0).text(Messages.SdkDialog_label_location).create((Widget)this.fieldsComposite);
            SdkEditDialog.this.sdkPathField = (Text)((TextFactory)WidgetFactory.text((int)18506).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).create())).text(SdkEditDialog.this.getSDKPath()).create((Widget)this.fieldsComposite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)SdkEditDialog.this.sdkPathField, SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID);
            SdkEditDialog.this.sdkPathField.addFocusListener((org.eclipse.swt.events.FocusListener)new FocusListener(SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID));
            File path = new File(SdkManagementUtils.performStringSubstitution((String)SdkEditDialog.this.getSDKPath(), (String)SdkEditDialog.this.getSDKName()));
            if (!path.exists()) {
                SdkEditDialog.this.setMessage(NLS.bind((String)Messages.SdkDialog_error_path_not_exists, (Object)path), 2);
            }
            ((LabelFactory)WidgetFactory.label((int)0).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)group);
            if (!SdkEditDialog.this.isReadonlyMode()) {
                this.changeButton = (Button)((ButtonFactory)WidgetFactory.button((int)8).text(Messages.SdkDialog_button_change).layoutData((Object)GridDataFactory.swtDefaults().exclude(SdkEditDialog.this.isReadonlyMode()).create())).onSelect(e -> this.selectLocation()).create((Widget)group);
                SdkEditDialog.this.setButtonLayoutData(this.changeButton);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.changeButton, SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID);
            }
        }

        private void selectLocation() {
            String envVariableName = SdkEditDialog.this.sdkEnv != null && SdkEditDialog.this.sdkEnv.isSystem ? SdkEnvironmentUtils.getEnviromnentName((String)SdkEditDialog.this.getSDKName(), (String)SdkEditDialog.this.getSDKVersion()) : SdkEditDialog.this.sdkEnvField.getText();
            LocationEditDialog dialog = new LocationEditDialog(SdkEditDialog.this.getShell(), SdkEditDialog.this.sdkEnv, envVariableName, SdkEditDialog.this.sdkDescField.getText());
            if (dialog.open() == 0) {
                SdkEditDialog.this.sdkEnv = dialog.getEnv();
                if (dialog.isSDKLocationChanged()) {
                    SdkEditDialog.this.isSdkChanged = true;
                    SdkEditDialog.this.resourcesGroup.clearSelectedComponentsOnChangeSDKLocation();
                }
                SdkEditDialog.this.fillEnvData(!SdkEditDialog.this.sdkEnvField.getText().equals(SdkEditDialog.this.sdkEnv.value));
            }
            SdkEditDialog.this.validate();
        }

        private void showResolvedLocation(boolean isShow) {
            String pathVariable;
            if (this.reslovedLocationLabel != null && !this.reslovedLocationLabel.isDisposed()) {
                this.reslovedLocationLabel.dispose();
            }
            if (this.resolvedLocationText != null && !this.resolvedLocationText.isDisposed()) {
                this.resolvedLocationText.dispose();
            }
            String name = SdkEditDialog.EMPTY_PATH;
            if (SdkEditDialog.this.sdkEnv != null && SdkEditDialog.this.sdkEnv.name != null) {
                name = SdkEditDialog.this.sdkEnv.name;
            }
            if (!(pathVariable = SdkManagementUtils.performStringSubstitution((String)SdkEditDialog.this.getSDKPath(), (String)name)).isEmpty()) {
                String aPath = Paths.get(pathVariable, new String[0]).normalize().toAbsolutePath().toString();
                if (isShow && !SdkEditDialog.this.getSDKPath().isEmpty() && !aPath.equals(SdkEditDialog.this.getSDKPath())) {
                    this.reslovedLocationLabel = (Label)WidgetFactory.label((int)0).text(Messages.SdkDialog_label_resolved_location).create((Widget)this.fieldsComposite);
                    this.resolvedLocationText = (Label)((LabelFactory)WidgetFactory.label((int)64).text(aPath).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).create())).create((Widget)this.fieldsComposite);
                }
                this.fieldsComposite.layout();
            }
        }

        private void enableChangeLocation(boolean isEnableChangeLocation) {
            if (this.changeButton != null) {
                this.changeButton.setEnabled(isEnableChangeLocation);
            }
        }
    }

    static class EnvironmetBackupData {
        final String name;
        final boolean isSystem;
        final String value;
        private final String description;

        private EnvironmetBackupData(EnvironmentSdkDescriptor env) {
            this.name = env != null ? env.getName() : SdkEditDialog.EMPTY_PATH;
            this.isSystem = env != null && env.isSystem();
            this.value = env != null ? env.getValue() : SdkEditDialog.EMPTY_PATH;
            this.description = env != null ? env.getDescription() : SdkEditDialog.EMPTY_PATH;
        }

        EnvironmetBackupData(String name, String value, String description, boolean isSystem) {
            this.name = name;
            this.value = value;
            this.description = description;
            this.isSystem = isSystem;
        }

        private boolean hasChanged(EnvironmetBackupData env) {
            return !env.name.equals(this.name) || env.isSystem != this.isSystem || !env.value.equals(this.value);
        }

        private boolean isValid() {
            return !this.name.isEmpty() && !this.value.isEmpty();
        }

        private void create(boolean isReadOnly) {
            SdkEnvironmentUtils.createEnvironment((String)this.name, (String)this.value, (String)this.description, (boolean)this.isSystem, (boolean)isReadOnly);
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private String helpContext;

        private FocusListener(String helpContext) {
            this.helpContext = helpContext;
        }

        public void focusGained(FocusEvent arg0) {
            final Text field = (Text)arg0.getSource();
            if (SdkEditDialog.this.getTray() != null && !SdkEditDialog.this.helpDisplayed) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
                SdkEditDialog.this.helpDisplayed = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!field.isDisposed()) {
                            field.setFocus();
                        }
                    }
                });
            }
        }

        public void focusLost(FocusEvent e) {
            SdkEditDialog.this.helpDisplayed = false;
        }
    }

    private static enum Id {
        NAME,
        VERSION,
        DESCRIPTION,
        TARGET_FOLDER_NAME;

    }

    private class ResourcesGroup {
        private ResourcesGroup() {
        }

        private void create(Composite parent) {
            Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(3, 1).create())).create((Widget)parent);
            TabFolder resourcesViewersComposite = new TabFolder(composite, 0);
            resourcesViewersComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createResourcesTabItems(resourcesViewersComposite);
            this.createSymbolsTabItem(resourcesViewersComposite);
            if (!SdkEditDialog.this.isCreateMode()) {
                this.initializeResourceTabsContent();
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)resourcesViewersComposite, SdkEditDialogConstants.SDK_CONTENT_CONTROLS_HELP_CONTEXT_ID);
            resourcesViewersComposite.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionListener(SdkEditDialogConstants.SDK_CONTENT_CONTROLS_HELP_CONTEXT_ID));
            composite.layout();
        }

        private void createResourcesTabItems(TabFolder parent) {
            TabItem sourceTabItem = this.createPathsControlTabItem(parent, Messages.SdkDialog_label_sources_control);
            SdkEditDialog.this.sdkSourceFilesViewer = new SourceResourcesControl((Composite)sourceTabItem.getControl(), SdkEditDialog.this.isEditableMode(), SdkEditDialog.this.toolChainHolders);
            TabItem headerTabItem = this.createPathsControlTabItem(parent, Messages.SdkDialog_label_headers_control);
            SdkEditDialog.this.sdkHeaderFilesViewer = new HeaderResourcesControl((Composite)headerTabItem.getControl(), SdkEditDialog.this.isEditableMode(), SdkEditDialog.this.toolChainHolders, SdkEditDialog.this.rootToolChainHolder);
            TabItem binaryTabItem = this.createPathsControlTabItem(parent, Messages.SdkDialog_label_binary_files_control);
            SdkEditDialog.this.sdkBinaryFilesViewer = new BinaryResourcesControl((Composite)binaryTabItem.getControl(), SdkEditDialog.this.isEditableMode(), SdkEditDialog.this.toolChainHolders);
            TabItem linkerTabItem = this.createPathsControlTabItem(parent, Messages.SdkDialog_label_linker_files_control);
            SdkEditDialog.this.sdkLinkerFilesViewer = new LinkerFilesControl((Composite)linkerTabItem.getControl(), SdkEditDialog.this.isEditableMode(), SdkEditDialog.this.toolChainHolders);
            TabItem othersTabItem = this.createPathsControlTabItem(parent, Messages.SdkDialog_label_other_resources_control);
            SdkEditDialog.this.sdkOthersFilesViewer = new OtherResourcesControl((Composite)othersTabItem.getControl(), SdkEditDialog.this.isEditableMode(), SdkEditDialog.this.toolChainHolders);
        }

        private TabItem createPathsControlTabItem(TabFolder parent, String label) {
            TabItem item = new TabItem(parent, 0);
            item.setText(label);
            Composite group = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
            item.setControl((Control)group);
            return item;
        }

        private void createSymbolsTabItem(TabFolder parent) {
            TabItem item = new TabItem(parent, 0);
            item.setText(Messages.SdkDialog_label_symbols_control);
            Composite group = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
            Map<String, SymbolsControl.SymbolsHolderWrapper> symbolsHoldersWrapper = this.wrapSymbolHoldersMap();
            new SymbolsControl(group, !SdkEditDialog.this.dialogUsageMode.isReadonlyMode(), symbolsHoldersWrapper);
            item.setControl((Control)group);
        }

        private void initializeResourceTabsContent() {
            AbstractSdkResourceControl.InputWrapper inputWrapper = SdkEditDialog.this.getInputWrapper(SdkEditDialog.this.sdkPathField.getText());
            Display display = Display.getCurrent();
            try {
                new ProgressMonitorDialog(SdkEditDialog.this.getShell()).run(true, false, monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SdkEditDialog_ResourceGroup_task_name_loading_sdk_resources, (int)5);
                    subMonitor.subTask(Messages.SdkEditDialog_ResourceGroup_subtask_name_loading_source_files);
                    display.syncExec(() -> SdkEditDialog.this.setViewerInput(SdkEditDialog.this.sdkSourceFilesViewer, inputWrapper, false));
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.SdkEditDialog_ResourceGroup_subtask_name_loading_header_files);
                    display.syncExec(() -> SdkEditDialog.this.setViewerInput(SdkEditDialog.this.sdkHeaderFilesViewer, inputWrapper, false));
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.SdkEditDialog_ResourceGroup_subtask_name_loading_binary_files);
                    display.syncExec(() -> SdkEditDialog.this.setViewerInput(SdkEditDialog.this.sdkBinaryFilesViewer, inputWrapper, false));
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.SdkEditDialog_ResourceGroup_subtask_name_loading_linker_files);
                    display.syncExec(() -> SdkEditDialog.this.setViewerInput(SdkEditDialog.this.sdkLinkerFilesViewer, inputWrapper, false));
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.SdkEditDialog_ResourceGroup_subtask_name_loading_other_files);
                    display.asyncExec(() -> SdkEditDialog.this.setViewerInput(SdkEditDialog.this.sdkOthersFilesViewer, inputWrapper, false));
                    subMonitor.worked(1);
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                SdkUiActivator.getInstance().logError("Unable to load resources due to error", e);
                Thread.currentThread().interrupt();
            }
        }

        private void clearSelectedComponentsOnChangeSDKLocation() {
            SdkEditDialog.this.sdkSourceFilesViewer.clearSelected();
            SdkEditDialog.this.sdkHeaderFilesViewer.clearSelected();
            SdkEditDialog.this.sdkBinaryFilesViewer.clearSelected();
            SdkEditDialog.this.sdkHeaderFilesViewer.clearSelected();
            SdkEditDialog.this.sdkLinkerFilesViewer.clearSelected();
            SdkEditDialog.this.sdkOthersFilesViewer.clearSelected();
        }

        private Map<String, SymbolsControl.SymbolsHolderWrapper> wrapSymbolHoldersMap() {
            if (SdkEditDialog.this.symbolHoldersMap == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, SymbolsControl.SymbolsHolderWrapper> result = new LinkedHashMap<String, SymbolsControl.SymbolsHolderWrapper>();
            for (Map.Entry<String, SdkSymbolsHolder> e : SdkEditDialog.this.symbolHoldersMap.entrySet()) {
                String toolChainId = e.getKey();
                ToolChainHolder toolChainHolder = SdkEditDialog.this.toolChainHolders.get(toolChainId);
                if (toolChainHolder == null) {
                    result.put(toolChainId, new SymbolsControl.SymbolsHolderWrapper(e.getValue(), SdkEditDialog.this.rootToolChainHolder, true));
                    continue;
                }
                result.put(toolChainId, new SymbolsControl.SymbolsHolderWrapper(e.getValue(), SdkEditDialog.this.toolChainHolders.get(toolChainId), false));
            }
            return result;
        }
    }

    private class SelectionListener
    extends SelectionAdapter {
        private String helpContext;

        private SelectionListener(String helpContext) {
            this.helpContext = helpContext;
        }

        public void widgetSelected(SelectionEvent e) {
            if (SdkEditDialog.this.getTray() != null) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
            }
        }
    }

    private final class ValidatingModificationListener
    implements ModifyListener {
        private final Id fieldId;

        public ValidatingModificationListener(Id fieldId) {
            this.fieldId = fieldId;
        }

        public void modifyText(ModifyEvent e) {
            if (this.fieldId != null) {
                this.modifyField();
            }
            if (SdkEditDialog.this.validate()) {
                this.reCreateVariable();
            }
        }

        private void modifyField() {
            switch (this.fieldId) {
                case NAME: {
                    SdkEditDialog.this.sdkName = SdkEditDialog.this.sdkNameField.getText().trim();
                    this.updateEnvName();
                    break;
                }
                case VERSION: {
                    SdkEditDialog.this.sdkVersion = SdkEditDialog.this.sdkVersionField.getText().trim();
                    this.updateEnvName();
                    break;
                }
                case TARGET_FOLDER_NAME: {
                    SdkEditDialog.this.sdkTargetFolderName = SdkEditDialog.this.sdkTargetFolderNameField.getText().trim();
                    break;
                }
                case DESCRIPTION: {
                    SdkEditDialog.this.sdkDescription = SdkEditDialog.this.sdkDescField.getText();
                }
            }
        }

        private void updateEnvName() {
            if (SdkEditDialog.this.sdkEnv == null || !SdkEditDialog.this.sdkEnv.isSystem) {
                SdkEditDialog.this.sdkEnvField.setText(SdkEnvironmentUtils.getEnviromnentName((String)Objects.toString(SdkEditDialog.this.sdkName), (String)Objects.toString(SdkEditDialog.this.sdkVersion)));
            }
        }

        private void reCreateVariable() {
            if (!SdkEditDialog.this.isReadonlyMode() && SdkEditDialog.this.sdkEnv != null && !SdkEditDialog.this.sdkEnv.isSystem) {
                String location = SdkEditDialog.this.sdkEnv.value;
                SdkEnvironmentUtils.removeEnvironment((String)SdkEditDialog.this.sdkEnv.name, (boolean)false);
                SdkEnvironmentUtils.createEnvironment((String)SdkEditDialog.this.sdkEnvField.getText(), (String)location, (String)Objects.toString(SdkEditDialog.this.sdkDescription, SdkEditDialog.EMPTY_PATH), (boolean)false, (boolean)false);
                SdkEditDialog.this.sdkEnv = new EnvironmetBackupData(SdkEditDialog.this.sdkEnvField.getText(), location, Objects.toString(SdkEditDialog.this.sdkDescription, SdkEditDialog.EMPTY_PATH), false);
            }
        }
    }
}

