/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.edit;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameExistsValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkEditDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkEditDialogConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.cdt.internal.ui.wizards.indexwizards.StringVariableLabelProvider;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.osgi.service.prefs.BackingStoreException;

class LocationEditDialog
extends TitleAreaDialog {
    private static final String DIR_KEY = "SDK_DIR_KEY";
    private static final String ASK_KEY = "SDK_ASK_KEY";
    private static final Point HINT = new Point(300, 250);
    private static final int MAX_FILES = 1000;
    private static final int STATE_LOC = 18506;
    private SdkEditDialog.EnvironmetBackupData env;
    private final String defaultName;
    private final String defaultDesc;
    private ILocationGroup userLocationGroup;
    private ILocationGroup systemLocationGroup;
    private Button okButton;
    private boolean isSystemEnvMode;
    private boolean isSDKLocationChanged;
    private IValidator<String> basePathValidator = new SdkBasePathValidator();
    private IValidator<String> environmentNameValidator = new SdkEnvironmentNameValidator();
    private IValidator<String> environmentNameExistsValidator = new SdkEnvironmentNameExistsValidator();

    LocationEditDialog(Shell parentShell, SdkEditDialog.EnvironmetBackupData env, String name, String desc) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.env = env;
        this.defaultName = name == null ? "" : name.trim();
        this.defaultDesc = desc == null ? this.defaultName : desc;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LocationEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().hint(HINT).applyTo((Control)contents);
        this.setTitle(Messages.LocationEditDialog_title);
        contents.setLayout((Layout)new GridLayout());
        this.createWidgets(contents);
        Dialog.applyDialogFont((Control)parentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID);
        return contents;
    }

    SdkEditDialog.EnvironmetBackupData getEnv() {
        return this.env;
    }

    private void createWidgets(Composite contents) {
        Group group = new Group(contents, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(4, false));
        this.userLocationGroup = new UserLocationGroup((Composite)group);
        this.systemLocationGroup = new SystemLocationGroup(group);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)contents, SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID);
        this.setInitData();
        this.validate();
    }

    private void setInitData() {
        this.isSystemEnvMode = this.env != null && this.env.isSystem;
        this.getLocationGroup().init();
    }

    private String getLocation() {
        return this.env != null && this.env.value != null ? this.env.value.trim() : "";
    }

    private String getNewLocation() {
        return this.getLocationGroup().getLocation();
    }

    private String getEnvironmentName() {
        return this.getLocationGroup().getEnvironmentName();
    }

    private ILocationGroup getLocationGroup() {
        return this.isSystemEnvMode ? this.systemLocationGroup : this.userLocationGroup;
    }

    private static void createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    private static Text createField(Composite parent, int fieldStyle, String context) {
        Text field = new Text(parent, fieldStyle);
        field.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)field, context);
        return field;
    }

    private static void savePref(String key, String val) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
        prefs.put(key, val);
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkUiActivator.getInstance().logError("Unable to store prefs", bse);
        }
    }

    protected void okPressed() {
        String newLocation;
        String oldLocation = this.getLocation();
        if (this.showWarning(oldLocation, newLocation = this.getNewLocation())) {
            if (this.env != null) {
                SdkEnvironmentUtils.removeEnvironment((String)this.env.name, (boolean)this.env.isSystem);
            }
            this.env = new SdkEditDialog.EnvironmetBackupData(this.getEnvironmentName(), newLocation, this.defaultDesc, this.isSystemEnvMode);
            SdkEnvironmentUtils.createEnvironment((String)this.getEnvironmentName(), (String)newLocation, (String)this.defaultDesc, (boolean)this.isSystemEnvMode, (boolean)false);
            if (!oldLocation.equals(newLocation)) {
                this.isSDKLocationChanged = true;
            }
            super.okPressed();
        }
    }

    boolean isSDKLocationChanged() {
        return this.isSDKLocationChanged;
    }

    private boolean showWarning(String oldLoc, String newLoc) {
        boolean yes;
        if (InstanceScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk").get(ASK_KEY, "").equals(ASK_KEY)) {
            return true;
        }
        if (oldLoc.isEmpty()) {
            return true;
        }
        if (oldLoc.equals(newLoc)) {
            return true;
        }
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)Messages.LocationEditDialog_change_sdk_location_message_title, (String)NLS.bind((String)Messages.LocationEditDialog_change_sdk_location_message_text, (Object)oldLoc, (Object)newLoc), (String)Messages.LocationEditDialog_change_sdk_location_message_dont_ask_again_checkbox, (boolean)false, null, null);
        boolean bl = yes = toggleDialog.getReturnCode() == 2;
        if (yes && toggleDialog.getToggleState()) {
            LocationEditDialog.savePref(ASK_KEY, ASK_KEY);
        }
        return yes;
    }

    private IStatus handleValidationStatus(IStatus validationStatus) {
        if (!validationStatus.isOK()) {
            if (validationStatus.isMultiStatus()) {
                IStatus[] statuses = validationStatus.getChildren();
                this.setErrorMessage(String.join((CharSequence)"\n", Arrays.stream(statuses).filter(status -> !status.isOK()).map(IStatus::getMessage).collect(Collectors.toList())));
            } else {
                this.setErrorMessage(validationStatus.getMessage());
            }
        }
        return validationStatus;
    }

    private void validate() {
        this.setErrorMessage(null);
        String envName = this.getEnvironmentName();
        String envPath = this.getNewLocation();
        IStatus status = Status.OK_STATUS;
        if (envPath.isEmpty()) {
            status = this.handleValidationStatus(SdkUiActivator.getInstance().createError(Messages.SdkEditDialog_error_empty_sdk_location));
        }
        if (status.isOK()) {
            try {
                SdkManagementUtils.substituteSystemVars((String)envPath, (String)envName, (boolean)true);
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                this.setErrorMessage(NLS.bind((String)Messages.LocationEditDialog_error_invalid_location, (Object)ce.getMessage()));
            }
        }
        if (status.isOK()) {
            status = this.handleValidationStatus(this.basePathValidator.validate((Object)envPath));
        }
        if (status.isOK() && (status = this.handleValidationStatus(this.environmentNameValidator.validate((Object)envName))).isOK() && !this.isSystemEnvMode) {
            status = this.handleValidationStatus(this.environmentNameExistsValidator.validate((Object)envName));
        }
        if (status.isOK()) {
            status = this.checkEnvVariableExist(envName);
        }
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.checkFilesCount(envPath);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(status.isOK());
        }
        this.getLocationGroup().showResolvedPath(status.isOK() && LocationEditDialog.needResolvePath(this.getLocationGroup().getLocation()));
    }

    private static boolean needResolvePath(String s) {
        return s != null && !s.isEmpty() && (s.contains("${") || s.equals("."));
    }

    private void checkFilesCount(String envPath) {
        try {
            String newLocation;
            File file = new File(SdkManagementUtils.performStringSubstitution((String)envPath, (String)this.getEnvironmentName()));
            String string = newLocation = file.toPath().getNameCount() > 0 ? file.getAbsolutePath() : String.valueOf(file.getPath()) + File.separator;
            if (newLocation == null) {
                return;
            }
            String currentLocation = new File(SdkManagementUtils.performStringSubstitution((String)this.getLocation(), (String)this.getEnvironmentName())).getAbsolutePath();
            File f = new File(newLocation);
            if (f.exists() && f.isDirectory() && f.canRead()) {
                int counter = LocationEditDialog.calculateFilesCount(f.toPath(), 1000);
                if (!currentLocation.equals(newLocation) && counter > 1000) {
                    this.setMessage(NLS.bind((String)Messages.LocationEditDialog_question_change_location, (Object)1000), 2);
                } else {
                    String message = counter <= 1000 ? NLS.bind((String)Messages.LocationEditDialog_message_total_files_detected, (Object)counter) : NLS.bind((String)Messages.LocationEditDialog_message_total_files_detected_more_than, (Object)1000);
                    this.setMessage(message, 1);
                }
            } else {
                this.setErrorMessage(String.format(Messages.LocationEditDialog_error_invalid_location, envPath));
            }
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage(String.format(Messages.LocationEditDialog_error_invalid_location, envPath));
        }
    }

    private IStatus checkEnvVariableExist(String name) {
        if (this.isSystemEnvMode) {
            return Status.OK_STATUS;
        }
        if (!(this.env != null && name.equals(this.env.name) || VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name) == null || System.getenv().get(name) != null)) {
            return this.handleValidationStatus(SdkUiActivator.getInstance().createError(NLS.bind((String)Messages.LocationEditDialog_error_environment_with_same_name_exists, (Object)name)));
        }
        return Status.OK_STATUS;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    private static int calculateFilesCount(java.nio.file.Path startPath, final int limit) {
        final int[] counter = new int[1];
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes ba) throws IOException {
                    return this.getCountCheckResult();
                }

                @Override
                public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                    return this.getCountCheckResult();
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                private FileVisitResult getCountCheckResult() {
                    counter[0] = counter[0] + 1;
                    return counter[0] > limit ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioe) {
            SdkUiActivator.getInstance().logError(NLS.bind((String)"Fail files count calcultaion on path {0}", (Object)startPath), ioe);
        }
        if (counter[0] > 0 && counter[0] <= limit) {
            counter[0] = counter[0] - 1;
        }
        return counter[0];
    }

    static interface ILocationGroup {
        public void init();

        public String getEnvironmentName();

        public String getLocation();

        public void disable();

        public void showResolvedPath(boolean var1);
    }

    class SystemLocationGroup
    implements ILocationGroup {
        private Button toggleButton;
        private CCombo systemVariablesCombo;
        private String variableName;
        private Text locationField;

        SystemLocationGroup(Group parent) {
            new Label((Composite)parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            this.toggleButton = new Button((Composite)parent, 16);
            this.toggleButton.setText(Messages.LocationEditDialog_button_select_system_variable);
            this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemLocationGroup.this.toggleButton.setSelection(true);
                    ((SystemLocationGroup)SystemLocationGroup.this).LocationEditDialog.this.isSystemEnvMode = true;
                    SystemLocationGroup.this.systemVariablesCombo.setEnabled(true);
                    ((SystemLocationGroup)SystemLocationGroup.this).LocationEditDialog.this.userLocationGroup.disable();
                    LocationEditDialog.this.validate();
                }
            });
            this.systemVariablesCombo = this.createCombo((Composite)parent, this.getSystemVariables(), SdkEditDialogConstants.SYSTEM_VARIABLES_FIELD_CONTEXT_HELP_ID);
            this.systemVariablesCombo.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            LocationEditDialog.createLabel((Composite)parent, Messages.SdkDialog_label_location);
            this.locationField = LocationEditDialog.createField((Composite)parent, 18506, SdkEditDialogConstants.LOCATION_FIELD_CONTEXT_HELP_ID);
            this.locationField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            this.systemVariablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemLocationGroup.this.variableName = SystemLocationGroup.this.systemVariablesCombo.getText();
                    String value = null;
                    if (SystemLocationGroup.this.variableName != null) {
                        value = System.getenv(SystemLocationGroup.this.variableName);
                    }
                    SystemLocationGroup.this.locationField.setText(value == null ? "" : value.trim());
                    LocationEditDialog.this.validate();
                }
            });
        }

        @Override
        public void init() {
            this.toggleButton.setSelection(true);
            LocationEditDialog.this.userLocationGroup.disable();
            this.systemVariablesCombo.setText(LocationEditDialog.this.env.name);
            this.variableName = this.systemVariablesCombo.getText();
            this.locationField.setText(LocationEditDialog.this.env.value);
            LocationEditDialog.this.isSystemEnvMode = true;
        }

        @Override
        public String getEnvironmentName() {
            return this.variableName;
        }

        @Override
        public String getLocation() {
            return this.locationField.getText().trim();
        }

        @Override
        public void disable() {
            LocationEditDialog.this.isSystemEnvMode = false;
            this.toggleButton.setSelection(false);
            this.systemVariablesCombo.setEnabled(false);
            this.locationField.setEnabled(false);
        }

        @Override
        public void showResolvedPath(boolean isShow) {
        }

        private String[] getSystemVariables() {
            Map<String, String> sysEnvVariables = System.getenv();
            ArrayList<String> items = new ArrayList<String>();
            for (Map.Entry<String, String> e : sysEnvVariables.entrySet()) {
                String resolvedPath;
                String systemVariableName = e.getKey();
                String systemVariableValue = Objects.toString(e.getValue(), "");
                if (systemVariableValue.isEmpty() || !LocationEditDialog.this.basePathValidator.validate((Object)(resolvedPath = SdkManagementUtils.performStringSubstitution((String)systemVariableValue, (String)systemVariableName))).isOK() || !LocationEditDialog.this.environmentNameValidator.validate((Object)systemVariableName).isOK()) continue;
                items.add(systemVariableName);
            }
            items.sort(Comparator.naturalOrder());
            return items.toArray(new String[items.size()]);
        }

        private CCombo createCombo(Composite parent, String[] items, String context) {
            CCombo combo = new CCombo(parent, 2060);
            if (items != null) {
                combo.setItems(items);
            }
            combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, context);
            return combo;
        }
    }

    class UserLocationGroup
    implements ILocationGroup {
        private Button toggleButton;
        private Text envNameField;
        private Text locationField;
        private Button variableButton;
        private Button browseButton;
        private Label resolvedLabel;
        private Label resolvedText;

        UserLocationGroup(Composite parent) {
            this.toggleButton = new Button(parent, 16);
            this.toggleButton.setText(Messages.LocationEditDialog_label_define_new_variable_button);
            this.envNameField = LocationEditDialog.createField(parent, 2052, SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID);
            this.envNameField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            LocationEditDialog.createLabel(parent, Messages.SdkDialog_label_location);
            this.locationField = LocationEditDialog.createField(parent, 18498, SdkEditDialogConstants.ENVIRONMENT_FIELD_CONTEXT_HELP_ID);
            this.locationField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            this.resolvedLabel = new Label(parent, 0);
            this.resolvedLabel.setText(Messages.SdkDialog_label_resolved_location);
            this.resolvedLabel.setVisible(false);
            this.resolvedText = new Label(parent, 64);
            this.resolvedText.setVisible(false);
            this.resolvedText.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.variableButton = new Button(parent, 8);
            this.variableButton.setText(Messages.LocationEditDialog_button_variable);
            this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            LocationEditDialog.this.setButtonLayoutData(this.variableButton);
            this.browseButton = new Button(parent, 8);
            this.browseButton.setText(Messages.LocationEditDialog_button_browse);
            this.browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            LocationEditDialog.this.setButtonLayoutData(this.browseButton);
            this.addListeners();
        }

        @Override
        public void init() {
            LocationEditDialog.this.isSystemEnvMode = false;
            this.toggleButton.setSelection(true);
            this.envNameField.setText(LocationEditDialog.this.env != null ? LocationEditDialog.this.env.name : LocationEditDialog.this.defaultName);
            this.locationField.setText(LocationEditDialog.this.env != null ? LocationEditDialog.this.env.value : "");
            LocationEditDialog.this.systemLocationGroup.disable();
        }

        @Override
        public String getEnvironmentName() {
            return this.envNameField.getText();
        }

        @Override
        public String getLocation() {
            return this.locationField.getText().trim();
        }

        @Override
        public void disable() {
            LocationEditDialog.this.isSystemEnvMode = true;
            this.toggleButton.setSelection(false);
            this.envNameField.setEnabled(false);
            this.variableButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.locationField.setEnabled(false);
        }

        @Override
        public void showResolvedPath(boolean isShow) {
            String location = this.locationField.getText();
            String aPath = new File(SdkManagementUtils.performStringSubstitution((String)location, (String)this.getEnvironmentName())).getAbsolutePath();
            this.resolvedLabel.setVisible(isShow &= !location.isEmpty() && !aPath.equals(location));
            this.resolvedText.setText(isShow ? aPath : "");
            this.resolvedText.setVisible(isShow);
        }

        private void selectFolder() {
            DirectoryDialog dialog = new DirectoryDialog(LocationEditDialog.this.getShell(), 0x10000000);
            dialog.setText(Messages.SdkDialog_folder_selection_dialog_title);
            dialog.setMessage(Messages.SdkDialog_folder_selection_dialog_message);
            dialog.setFilterPath(InstanceScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk").get(LocationEditDialog.DIR_KEY, ""));
            String selectedFolder = dialog.open();
            if (selectedFolder != null) {
                this.locationField.setText(new Path(selectedFolder).makeAbsolute().toOSString());
                LocationEditDialog.savePref(LocationEditDialog.DIR_KEY, this.locationField.getText());
                LocationEditDialog.this.validate();
            }
        }

        private void selectVariable() {
            Object[] result;
            ElementListSelectionDialog variableSelectionDialog = new ElementListSelectionDialog(LocationEditDialog.this.getShell(), (ILabelProvider)new StringVariableLabelProvider()){

                protected Control createDialogArea(Composite parent) {
                    Composite c = (Composite)super.createDialogArea(parent);
                    c.addHelpListener(new HelpListener(){

                        public void helpRequested(HelpEvent e) {
                        }
                    });
                    return parent;
                }
            };
            variableSelectionDialog.setHelpAvailable(false);
            variableSelectionDialog.setElements((Object[])this.getInternalVariables());
            variableSelectionDialog.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_2);
            variableSelectionDialog.setMessage(StringSubstitutionMessages.StringVariableSelectionDialog_3);
            if (variableSelectionDialog.open() == 0 && (result = variableSelectionDialog.getResult()) != null && result.length > 0) {
                IValueVariable vv = (IValueVariable)result[0];
                this.locationField.setText("${" + vv.getName() + "}");
            }
        }

        private IValueVariable[] getInternalVariables() {
            IValueVariable[] vars;
            TreeSet<IValueVariable> variables = new TreeSet<IValueVariable>((vv1, vv2) -> vv1.getName().compareTo(vv2.getName()));
            IValueVariable[] iValueVariableArray = vars = VariablesPlugin.getDefault().getStringVariableManager().getValueVariables();
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                String resolvedPath;
                IValueVariable variable = iValueVariableArray[n2];
                String variableName = variable.getName();
                String variableValue = Objects.toString(variable.getValue(), "");
                if (!variableValue.isEmpty() && LocationEditDialog.this.basePathValidator.validate((Object)(resolvedPath = SdkManagementUtils.performStringSubstitution((String)variable.getValue(), (String)variableName))).isOK() && LocationEditDialog.this.environmentNameValidator.validate((Object)variableName).isOK()) {
                    variables.add(variable);
                }
                ++n2;
            }
            return variables.toArray(new IValueVariable[variables.size()]);
        }

        private void addListeners() {
            this.locationField.addModifyListener(e -> {
                String sourceText = this.locationField.getText();
                String trimmedText = sourceText.replace("\r\n", "");
                if (!trimmedText.equals(sourceText)) {
                    this.locationField.setText(trimmedText);
                    this.locationField.setSelection(trimmedText.length());
                }
                LocationEditDialog.this.validate();
            });
            this.locationField.addTraverseListener(e -> {
                if (e.detail == 4) {
                    e.doit = true;
                }
            });
            this.envNameField.addModifyListener(e -> LocationEditDialog.this.validate());
            this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.isSystemEnvMode = false;
                    UserLocationGroup.this.envNameField.setEnabled(true);
                    UserLocationGroup.this.envNameField.setText(((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.env != null && !((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.env.isSystem ? ((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.env.name : ((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.defaultName);
                    UserLocationGroup.this.variableButton.setEnabled(true);
                    UserLocationGroup.this.browseButton.setEnabled(true);
                    ((UserLocationGroup)UserLocationGroup.this).LocationEditDialog.this.systemLocationGroup.disable();
                    UserLocationGroup.this.toggleButton.setSelection(true);
                    UserLocationGroup.this.locationField.setEnabled(true);
                    LocationEditDialog.this.validate();
                }
            });
            this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserLocationGroup.this.selectVariable();
                }
            });
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserLocationGroup.this.selectFolder();
                }
            });
        }
    }
}

