/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageContentProvider;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageLabelProvider;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SdkAttachConfigurationsDialog
extends TitleAreaDialog {
    private static final int MAX_VISIBLE_ROWS_NUMBER = 5;
    private final Collection<SdkDescriptor> selectedSDKs;
    private final IProject project;
    private final Map<String, List<IStatus>> selectedConfigs;
    private Button selectAllButton;
    private Button selectNoneButton;
    private CheckboxTableViewer tableViewer;

    public SdkAttachConfigurationsDialog(Shell parentShell, Collection<SdkDescriptor> selectedSDKs, IProject project, Map<String, List<IStatus>> selectedConfigs) {
        super(parentShell);
        this.selectedSDKs = selectedSDKs;
        this.project = project;
        this.selectedConfigs = selectedConfigs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SdkAttachConfigurationsDialog_text);
        this.setMessage(Messages.SdkAttachConfigurationsDialog_message);
        Composite body = new Composite(content, 0);
        GridDataFactory.fillDefaults().applyTo((Control)body);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)body, (int)68096);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setComparator(SdkAttachConfigurationsDialog.getComparator());
        this.tableViewer.addCheckStateListener(this.getCheckStateListener());
        this.tableViewer.setCheckStateProvider(this.getCheckStateProvider());
        this.setupTable(body);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 7 * this.tableViewer.getTable().getItemHeight();
        body.setLayoutData((Object)data);
        this.setHelpAvailable(false);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SdkAttachConfigurationsDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.selectAllButton = this.createButton(parent, 18, Messages.SdkAttachConfigurationsDialog_button_label_select_all, false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SdkAttachConfigurationsDialog.this.changeAttachStatusesTo(SdkAttachStatuses.OK_SDK_ATTACHED);
            }
        });
        this.selectNoneButton = this.createButton(parent, 19, Messages.SdkAttachConfigurationsDialog_button_label_select_none, false);
        this.selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SdkAttachConfigurationsDialog.this.changeAttachStatusesTo(SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
            }
        });
        this.enableSelectButtons();
        super.createButtonsForButtonBar(parent);
    }

    private void setupTable(Composite body) {
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        nameColumn.getColumn().setText(Messages.SdkTableViewerHolder_name_column_text);
        nameColumn.setLabelProvider(SdkPageLabelProvider.getNameLabelProvider());
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        versionColumn.getColumn().setText(Messages.SdkTableViewerHolder_version_column_text);
        versionColumn.setLabelProvider(SdkPageLabelProvider.getVersionLabelProvider());
        ArrayList<TableViewerColumn> configColumns = new ArrayList<TableViewerColumn>();
        if (this.project != null && this.project.isAccessible()) {
            List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)this.project);
            int i = 0;
            while (i < projectConfigurations.size()) {
                String configName = ((IConfiguration)projectConfigurations.get(i)).getName();
                TableViewerColumn configColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0x1000000);
                configColumn.getColumn().setAlignment(0x1000000);
                configColumn.getColumn().setText(configName);
                configColumn.getColumn().setToolTipText(configName);
                configColumn.setLabelProvider(SdkAttachConfigurationsDialog.getConfigColumnLabelProvider(i, this.selectedConfigs));
                configColumn.setEditingSupport(this.getConfigColumnEditingSupport(i));
                configColumns.add(configColumn);
                ++i;
            }
        }
        TableColumnLayout tableLayout = new TableColumnLayout();
        body.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(170));
        tableLayout.setColumnData((Widget)versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60));
        configColumns.forEach(col -> tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(80)));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)SdkPageContentProvider.getStructuredContentProvider());
        this.tableViewer.setInput(this.selectedSDKs);
    }

    private static ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof SdkDescriptor && e2 instanceof SdkDescriptor) {
                    SdkDescriptor sdk1 = (SdkDescriptor)e1;
                    SdkDescriptor sdk2 = (SdkDescriptor)e2;
                    Boolean isSdk1Attached = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdk1.getId()).contains(SdkAttachStatuses.OK_SDK_ATTACHED);
                    Boolean isSdk2Attached = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdk2.getId()).contains(SdkAttachStatuses.OK_SDK_ATTACHED);
                    if (isSdk1Attached.booleanValue() && isSdk2Attached.booleanValue()) {
                        return sdk1.getName().toLowerCase().compareTo(sdk2.getName().toLowerCase());
                    }
                    return isSdk2Attached.compareTo(isSdk1Attached);
                }
                return 0;
            }
        };
    }

    private ICheckStateListener getCheckStateListener() {
        return event -> {
            Object element = event.getElement();
            if (element instanceof SdkDescriptor) {
                IStatus switchFromStatus = event.getChecked() ? SdkAttachStatuses.OK_SDK_NOT_ATTACHED : SdkAttachStatuses.OK_SDK_ATTACHED;
                List statuses = this.selectedConfigs.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList());
                int i = 0;
                while (i < statuses.size()) {
                    statuses.set(i, SdkAttachConfigurationsDialog.switchAttachStatus((IStatus)statuses.get(i), switchFromStatus));
                    ++i;
                }
                this.enableSelectButtons();
                this.tableViewer.refresh();
            }
        };
    }

    private ICheckStateProvider getCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof SdkDescriptor) {
                    List statuses = SdkAttachConfigurationsDialog.this.selectedConfigs.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList());
                    return statuses.contains(SdkAttachStatuses.OK_SDK_ATTACHED) && statuses.contains(SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof SdkDescriptor) {
                    return !SdkAttachConfigurationsDialog.this.selectedConfigs.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList()).contains(SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
                }
                return false;
            }
        };
    }

    private EditingSupport getConfigColumnEditingSupport(int configColumnIndex) {
        return new SdkPageLabelProvider.CfgEditingSupport((ColumnViewer)this.tableViewer, configColumnIndex, this.selectedConfigs){

            @Override
            protected void setValue(Object element, Object value) {
                if (Boolean.TRUE.equals(this.getValue(element))) {
                    super.setValue(element, value);
                    SdkAttachConfigurationsDialog.this.enableSelectButtons();
                }
            }
        };
    }

    private static CellLabelProvider getConfigColumnLabelProvider(int idx, Map<String, List<IStatus>> data) {
        return new SdkPageLabelProvider.CfgCellLabelProvider(idx, (Map)data){

            @Override
            protected Image getImage(IStatus status) {
                if (SdkAttachStatuses.OK_SDK_ATTACHED.equals(status)) {
                    return SdkUiActivator.getInstance().getImage("SDK_COMMON_CHECK_ICON");
                }
                if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(status)) {
                    return SdkUiActivator.getInstance().getImage("SDK_COMMON_UNCHECK_ICON");
                }
                return super.getImage(status);
            }
        };
    }

    private void changeAttachStatusesTo(IStatus newStatus) {
        IStatus changeFromStatus = SdkAttachStatuses.OK_SDK_ATTACHED.equals(newStatus) ? SdkAttachStatuses.OK_SDK_NOT_ATTACHED : SdkAttachStatuses.OK_SDK_ATTACHED;
        for (Map.Entry<String, List<IStatus>> e : this.selectedConfigs.entrySet()) {
            List<IStatus> sdkAttachStatuses = e.getValue();
            int i = 0;
            while (i < sdkAttachStatuses.size()) {
                sdkAttachStatuses.set(i, SdkAttachConfigurationsDialog.switchAttachStatus(sdkAttachStatuses.get(i), changeFromStatus));
                ++i;
            }
        }
        this.enableSelectButtons();
        this.tableViewer.refresh();
    }

    private static IStatus switchAttachStatus(IStatus currentAttachStatus, IStatus switchFromStatus) {
        if (SdkAttachStatuses.OK_SDK_ATTACHED.equals(switchFromStatus) && SdkAttachStatuses.OK_SDK_ATTACHED.equals(currentAttachStatus)) {
            return SdkAttachStatuses.OK_SDK_NOT_ATTACHED;
        }
        if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(switchFromStatus) && SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(currentAttachStatus)) {
            return SdkAttachStatuses.OK_SDK_ATTACHED;
        }
        return currentAttachStatus;
    }

    private void enableSelectButtons() {
        this.selectAllButton.setEnabled(this.selectedConfigs.values().stream().flatMap(Collection::stream).anyMatch(SdkAttachStatuses.OK_SDK_NOT_ATTACHED::equals));
        this.selectNoneButton.setEnabled(this.selectedConfigs.values().stream().flatMap(Collection::stream).anyMatch(SdkAttachStatuses.OK_SDK_ATTACHED::equals));
    }
}

