/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class PropertyPageSelection {
    private Table table;
    private int lastSelectionIndex;

    PropertyPageSelection(Table table) {
        this.table = table;
        this.lastSelectionIndex = -1;
    }

    Collection<String> save() {
        this.lastSelectionIndex = this.table.getSelectionIndex();
        return Arrays.asList(this.table.getSelection()).stream().map(this::getItemKey).collect(Collectors.toList());
    }

    void restore(Collection<String> savedSelectedItems) {
        if (savedSelectedItems != null && !savedSelectedItems.isEmpty()) {
            TableItem[] selectedItems = (TableItem[])Arrays.stream(this.table.getItems()).filter(tableItem -> savedSelectedItems.contains(this.getItemKey((TableItem)tableItem))).collect(Collectors.toList()).toArray(TableItem[]::new);
            if (selectedItems.length > 0) {
                this.table.setSelection(selectedItems);
            } else {
                int max = this.table.getItemCount() - 1;
                this.table.setSelection(this.lastSelectionIndex != -1 && max >= this.lastSelectionIndex ? this.lastSelectionIndex : max);
            }
            this.table.setFocus();
        }
    }

    private String getItemKey(TableItem tableItem) {
        return String.valueOf(tableItem.getText(0)) + tableItem.getText(1);
    }
}

