/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkTableViewerHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.AbstractSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageButtonBar;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageFilterBar;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.DetachUnavailableSdksDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectSdksPropertyPage
extends AbstractSdksPropertyPage {
    private static final String HELP_CONTEXT_PROJECT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_PROJECT_context";
    private IProject project;

    public ProjectSdksPropertyPage(IProject project) {
        this.project = project;
        this.buttonIds = new PropertyPageButtonBar.PropertyPageButtons[]{PropertyPageButtonBar.PropertyPageButtons.ATTACH, PropertyPageButtonBar.PropertyPageButtons.RELOAD, PropertyPageButtonBar.PropertyPageButtons.EDIT, PropertyPageButtonBar.PropertyPageButtons.REMOVE, PropertyPageButtonBar.PropertyPageButtons.EXPORT, PropertyPageButtonBar.PropertyPageButtons.CREATE, PropertyPageButtonBar.PropertyPageButtons.CONVERT};
        this.filterIds = new PropertyPageFilterBar.PropertyPageFilters[]{PropertyPageFilterBar.PropertyPageFilters.SHOW_ALL_SDKS, PropertyPageFilterBar.PropertyPageFilters.LATEST_VERSION};
    }

    @Override
    protected SdkTableViewerHolder createTableViewerHolder(Composite parent) {
        SdkAttachStatusesHolder.INSTANCE.loadAvailableSDKsAttachStates(this.project);
        return SdkTableViewerHolder.newSelList(parent, this.getProject(), SdkAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates());
    }

    @Override
    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_PROJECT_ID);
    }

    @Override
    protected IProject getProject() {
        return this.project;
    }

    @Override
    protected FilterOptions getFilterOptions() {
        return ProjectCompatibleSdksFilter.options((IProject)this.getProject());
    }

    @Override
    protected SdkType getSdkType() {
        return SdkType.PROJECT_LOCAL;
    }

    private static Map<SdkDescriptor, IStatus> detachUnavailableSdksFromProject(Collection<SdkDescriptor> sdksDescriptors, IProject project) {
        if (sdksDescriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<SdkDescriptor, IStatus> result = new HashMap<SdkDescriptor, IStatus>();
        sdksDescriptors.forEach(sdkDescriptor -> {
            IStatus iStatus = result.put((SdkDescriptor)sdkDescriptor, Status.CANCEL_STATUS);
        });
        Display display = Display.getDefault();
        Shell activeShell = display.getActiveShell();
        display.syncExec(() -> {
            List<SdkDescriptor> preparedSdksList = ProjectSdksPropertyPage.prepareDetachingSdksList(sdksDescriptors, project);
            ArrayList<SdkDescriptor> sdksToDetach = new ArrayList<SdkDescriptor>(preparedSdksList);
            for (SdkDescriptor sdk : preparedSdksList) {
                Path path = Paths.get(sdk.getBasePath(), new String[0]);
                if (Files.exists(path, new LinkOption[0])) continue;
                sdksToDetach.remove(sdk);
            }
            if (!sdksToDetach.isEmpty()) {
                DetachUnavailableSdksDialog detachUnavailableSdksDialog = new DetachUnavailableSdksDialog(activeShell, sdksToDetach, project);
                ProjectSdksPropertyPage.performOperation(sdksDescriptors, project, activeShell, result, detachUnavailableSdksDialog.open());
            }
        });
        return result;
    }

    private static List<SdkDescriptor> prepareDetachingSdksList(Collection<SdkDescriptor> sdksList, IProject project) {
        if (sdksList == null) {
            return Collections.emptyList();
        }
        ArrayList<SdkDescriptor> preparedSdksList = new ArrayList<SdkDescriptor>(sdksList);
        Map<Boolean, List<SdkDescriptor>> sdksMap = sdksList.stream().collect(Collectors.partitioningBy(sdk -> !ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdk.getId()).isEmpty()));
        sdksMap.get(true).stream().flatMap(moduleSdk -> SdkModulesHelper.getRefModulesSdksDescriptors((String)moduleSdk.getId()).stream()).forEach(preparedSdksList::remove);
        sdksMap.get(false).stream().filter(plainSdk -> SdkType.UNKNOWN != plainSdk.getType()).forEach(plainSdk -> {
            Collection referringModuleSdks = SdkModulesHelper.getReferringModuleSdks((String)plainSdk.getId());
            if (!referringModuleSdks.isEmpty()) {
                referringModuleSdks.stream().filter(moduleSdk -> SdkAttachDataHolder.isSdkAttachedToProject((SdkDescriptor)moduleSdk, (IProject)project) && !preparedSdksList.contains(moduleSdk)).forEach(preparedSdksList::add);
                preparedSdksList.remove(plainSdk);
            }
        });
        return preparedSdksList;
    }

    private static void performOperation(final Collection<SdkDescriptor> sdksToBeDetached, final IProject project, Shell activeShell, final Map<SdkDescriptor, IStatus> result, final int operation) {
        if (sdksToBeDetached.isEmpty()) {
            return;
        }
        ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(activeShell);
        try {
            pmDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SdkPreferencesPage_detach_unavailable_sdks_task_name, sdksToBeDetached.size());
                    for (SdkDescriptor sdkToBeDetached : sdksToBeDetached) {
                        monitor.setTaskName(SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdkToBeDetached));
                        if (operation == 0) {
                            result.put(sdkToBeDetached, SdkAttachProcessor.detachUnresolvedSdk((SdkDescriptor)sdkToBeDetached, (IProject)project));
                            ProjectSdksPropertyPage.attachAvailableSDK(sdkToBeDetached, project, result);
                        }
                        monitor.worked(1);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            MessageDialog.openError((Shell)activeShell, (String)Messages.SdkPreferencesPage_detach_unavailable_sdks_task_name, (String)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private static void attachAvailableSDK(SdkDescriptor sdkToBeDetached, IProject project, Map<SdkDescriptor, IStatus> result) {
        Optional<SdkDescriptor> compSdk = SdkManagementUtils.getFilteredSdks((SdkFilter)new ProjectCompatibleSdksFilter(project)).stream().filter(sdk -> sdk.getName().equals(sdkToBeDetached.getName())).findFirst();
        if (compSdk.isPresent()) {
            result.put(sdkToBeDetached, SdkAttachProcessor.attachSdkToProjectConfigurations((String)compSdk.get().getId(), (Collection)ProjectConfigurationUtils.getProjectConfigurations((IProject)project), (IProject)project, (boolean)false));
            SdkAttachStatusesHolder.INSTANCE.addSdkAttachStates(compSdk.get(), project);
        }
    }

    @Override
    protected void updateViewerInput() {
        Collection<SdkDescriptor> sdks = this.getSDKs();
        List missedSdks = SdkAttachDataHolder.getUndefinedSdksByProject((IProject)this.project);
        if (!missedSdks.isEmpty()) {
            Map<SdkDescriptor, IStatus> missedSdksDetachStatuses = ProjectSdksPropertyPage.detachUnavailableSdksFromProject(missedSdks, this.project);
            for (SdkDescriptor missedSdkDescriptor : missedSdks) {
                IStatus missedSdkDetachStatus;
                if (SdkType.INTERNAL == missedSdkDescriptor.getType() || sdks.contains(missedSdkDescriptor) || (missedSdkDetachStatus = missedSdksDetachStatuses.get(missedSdkDescriptor)) != null && 8 != missedSdkDetachStatus.getSeverity()) continue;
                sdks.add(missedSdkDescriptor);
                SdkAttachStatusesHolder.INSTANCE.addSdkAttachStates(missedSdkDescriptor, this.project);
            }
        }
        this.viewer.setInput(sdks);
        this.viewer.setItemCount(sdks.size());
    }

    @Override
    protected Collection<SdkDescriptor> getFilteredSdks(SdkFilter filter) {
        return super.getFilteredSdks(filter).stream().filter(sdk -> !sdk.getTags().contains("mcal")).collect(Collectors.toList());
    }
}

