/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFileResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;

public class SdkFolderResource
extends SdkResource {
    protected PathMatcher pathMatcher;

    public SdkFolderResource(Element element, String sdkBasePath, PathMatcher pathMatcher) {
        super(element, sdkBasePath);
        this.pathMatcher = Objects.requireNonNull(pathMatcher);
    }

    public SdkFolderResource(ResourceSdkKind type, ExtendedPath path, PathMatcher pathMatcher) {
        super(type, path);
        this.pathMatcher = Objects.requireNonNull(pathMatcher);
    }

    public Set<SdkResource> getResources() {
        LinkedHashSet<SdkResource> resources = new LinkedHashSet<SdkResource>();
        this.processFolder().stream().map(path -> new SdkFileResource(this.getFileResourceKind(), (ExtendedPath)((Object)path), this.getLangId(), this.getRelatedConfigurations())).forEach(res -> {
            resources.removeIf(r -> SdkFolderResource.isResourceOverridenByLangId(r, res));
            resources.add((SdkResource)res);
        });
        return resources;
    }

    private ResourceSdkKind getFileResourceKind() {
        switch (this.type) {
            case HEADER_FOLDER: {
                return ResourceSdkKind.HEADER_FILE;
            }
            case RESOURCE_FOLDER: {
                return ResourceSdkKind.RESOURCE_FILE;
            }
            case SOURCE_FOLDER: {
                return ResourceSdkKind.SOURCE_FILE;
            }
        }
        return this.type;
    }

    private Set<ExtendedPath> processFolder() {
        final LinkedHashSet<ExtendedPath> paths = new LinkedHashSet<ExtendedPath>();
        File folder = this.path.toFile();
        if (folder.exists()) {
            String absolutePath = folder.getAbsolutePath();
            try {
                Files.walkFileTree(Paths.get(absolutePath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (SdkFolderResource.this.pathMatcher.matches(file.getFileName())) {
                            paths.add(ExtendedPath.fromOSString(file.toString(), SdkFolderResource.this.path.isCopy(), SdkFolderResource.this.path.copyPath(), SdkFolderResource.this.path.renameTo(), SdkFolderResource.this.path.toOpen(), false));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ioe) {
                SdkUiActivator.getInstance().logError(String.format("Unable to process folder %s due to error.", absolutePath), ioe);
            }
        }
        return paths;
    }

    private static boolean isResourceOverridenByLangId(SdkResource resourceToCheck, SdkResource newResource) {
        return resourceToCheck.getPath().equals((Object)newResource.getPath()) && resourceToCheck.getType() == newResource.getType() && resourceToCheck.getLangId().isEmpty() && !newResource.getLangId().isEmpty();
    }
}

