/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SourceEntriesUpdateStatus
extends UpdateStatus {
    public static final String SOURCE_ENTRIES_UPDATE_STATUS_ELEMENT = "sourceEntries";
    public static final String SOURCE_ENTRIES_UPDATE_NEW_VALUES_ELEMENT = "newValues";
    public static final String SOURCE_ENTRIES_UPDATE_ENTRY_ELEMENT = "entry";
    public static final String SOURCE_ENTRIES_UPDATE_ENTRY_PATH_ATTRIBUTE = "path";
    public static final String SOURCE_ENTRIES_UPDATE_ENTRY_FLAGS_ATTRIBUTE = "flags";
    public static final String SOURCE_ENTRIES_UPDATE_ENTRY_EXCLUSIONS_ATTRIBUTE = "exclusionPatterns";
    private ICSourceEntry[] sourceEntries;

    public SourceEntriesUpdateStatus(String configurationName) {
        super(configurationName, "");
    }

    public SourceEntriesUpdateStatus(Element updateStatusElement, String configurationName) {
        super(updateStatusElement, configurationName);
    }

    @Override
    public String getIdentifier() {
        return null;
    }

    public void setSourceEntries(ICSourceEntry[] targetEntries) {
        this.sourceEntries = targetEntries;
    }

    public ICSourceEntry[] getSourceEntries() {
        return this.sourceEntries;
    }

    @Override
    public Element convertToXml(Document document, Element holderElement) {
        Element element = document.createElement(SOURCE_ENTRIES_UPDATE_STATUS_ELEMENT);
        this.convertAttributesToXml(element);
        holderElement.appendChild(element);
        return element;
    }

    @Override
    protected void convertAttributesToXml(Element holderElement) {
        if (this.sourceEntries != null && this.sourceEntries.length > 0) {
            Element targetValuesElement = holderElement.getOwnerDocument().createElement(SOURCE_ENTRIES_UPDATE_NEW_VALUES_ELEMENT);
            SourceEntriesUpdateStatus.convertSourceEntryToXml(this.sourceEntries, targetValuesElement);
            holderElement.appendChild(targetValuesElement);
        }
    }

    private static void convertSourceEntryToXml(ICSourceEntry[] sourceEntries, Element valuesElement) {
        Document document = valuesElement.getOwnerDocument();
        ICSourceEntry[] iCSourceEntryArray = sourceEntries;
        int n = sourceEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry e = iCSourceEntryArray[n2];
            Element entryElement = document.createElement(SOURCE_ENTRIES_UPDATE_ENTRY_ELEMENT);
            entryElement.setAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_PATH_ATTRIBUTE, e.getName());
            entryElement.setAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_EXCLUSIONS_ATTRIBUTE, String.join((CharSequence)",", Arrays.stream(e.getExclusionPatterns()).map(IPath::toString).collect(Collectors.toSet())));
            entryElement.setAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_FLAGS_ATTRIBUTE, String.valueOf(e.getFlags()));
            valuesElement.appendChild(entryElement);
            ++n2;
        }
    }

    @Override
    protected void initializeAttributesFromXml(Element element) {
        NodeList newValuesElements = element.getElementsByTagName(SOURCE_ENTRIES_UPDATE_NEW_VALUES_ELEMENT);
        if (newValuesElements.getLength() == 1) {
            this.sourceEntries = SourceEntriesUpdateStatus.getEntries((Element)newValuesElements.item(0));
        }
    }

    private static ICSourceEntry[] getEntries(Element valuesElement) {
        ArrayList<CSourceEntry> entries = new ArrayList<CSourceEntry>();
        NodeList entryNodes = valuesElement.getElementsByTagName(SOURCE_ENTRIES_UPDATE_ENTRY_ELEMENT);
        int i = 0;
        while (i < entryNodes.getLength()) {
            Element entryElement = (Element)entryNodes.item(i);
            String path = entryElement.getAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_PATH_ATTRIBUTE);
            int flags = Integer.parseInt(entryElement.getAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_FLAGS_ATTRIBUTE));
            IPath[] exclusionPatterns = null;
            String exclusionPatternsValue = entryElement.getAttribute(SOURCE_ENTRIES_UPDATE_ENTRY_EXCLUSIONS_ATTRIBUTE);
            List excludedPaths = Arrays.stream(exclusionPatternsValue.split(",")).map(String::trim).filter(exludedPath -> !exludedPath.isEmpty()).collect(Collectors.toList());
            if (!excludedPaths.isEmpty()) {
                exclusionPatterns = excludedPaths.stream().map(Path::new).collect(Collectors.toSet()).toArray(new IPath[0]);
            }
            entries.add(new CSourceEntry(path, exclusionPatterns, flags));
            ++i;
        }
        return entries.toArray(new ICSourceEntry[0]);
    }
}

