/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.internal.refactoring;

import com.nxp.s32ds.ext.cdt.internal.refactoring.CdtRefactoringActivator;
import com.nxp.s32ds.ext.cdt.internal.refactoring.CdtRenameRefactoring;
import com.nxp.s32ds.ext.cdt.internal.refactoring.CdtRenameRefactoringArgument;
import com.nxp.s32ds.ext.cdt.internal.refactoring.CdtRenameRefactoringContext;
import com.nxp.s32ds.ext.cdt.internal.refactoring.LocalIndexFilter;
import com.nxp.s32ds.ext.cdt.internal.refactoring.Messages;
import com.nxp.s32ds.ext.cdt.refactoring.CdtElementType;
import com.nxp.s32ds.ext.cdt.refactoring.CdtRenameFlag;
import com.nxp.s32ds.ext.ide.refactoring.IdeRefactorings;
import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScope;
import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScopes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringContext;

public class CdtRefactoringsInternal {
    public static List<ICElement> find(IProgressMonitor monitor, IProject project, IdeSearchScope scope, CdtElementType type, String name, String ... params) throws CoreException {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        if (!indexManager.isIndexerIdle() && !indexManager.joinIndexer(10000, monitor)) {
            throw new CoreException(CdtRefactoringActivator.getInstance().createError(Messages.CdtRefactoringsInternal_indexer_is_busy));
        }
        return CdtRefactoringsInternal.doWithIndex(IdeSearchScopes.getProjectsByScope((IProject)project, (IdeSearchScope)scope), index -> {
            IIndexBinding[] bindings = index.findBindings(Pattern.compile(name), false, (IndexFilter)new LocalIndexFilter(type, params), monitor);
            return Arrays.stream(bindings).map(b -> IndexTypeInfo.create((IIndex)index, (IIndexBinding)b)).map(ti -> ti.getResolvedReference().getCElements()).filter(e -> e != null).flatMap(Arrays::stream).collect(Collectors.toList());
        });
    }

    public static void rename(IProgressMonitor monitor, ICElement element, String newName, IdeSearchScope scope, EnumSet<CdtRenameFlag> flags) throws CoreException {
        CdtRenameRefactoringArgument arg = new CdtRenameRefactoringArgument(element, newName, scope, flags);
        CdtRenameRefactoringContext context = CdtRenameRefactoring.createContext(arg);
        IdeRefactorings.perform((RefactoringContext)context, (IProgressMonitor)monitor);
    }

    private static <T> T doWithIndex(Collection<IProject> scope, CoreFunction<IIndex, T> function) throws CoreException {
        ICProject[] projects = (ICProject[])scope.stream().map(p -> CoreModel.getDefault().create(p)).toArray(ICProject[]::new);
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects, 512);
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        try {
            T t = function.apply(index);
            return t;
        }
        finally {
            index.releaseReadLock();
        }
    }

    static List<String> getParameterTypes(IFunction function) {
        Stream<String> stream = Arrays.stream(function.getParameters()).map(p -> ASTTypeUtil.getType((IType)p.getType(), (boolean)false));
        if (function.takesVarArgs()) {
            stream = Stream.concat(stream, Stream.of("..."));
        }
        return stream.collect(Collectors.toList());
    }

    private static interface CoreFunction<T, R> {
        public R apply(T var1) throws CoreException;
    }
}

