/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.internal.registry.core;

import com.nxp.s32ds.cle.ide.debugger.internal.registry.core.DebuggerRegistryCoreActivator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ConfigurationElementDescriptor;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class DebuggerLaunchConfigurationDescriptorImplementation
extends ConfigurationElementDescriptor
implements DebuggerLaunchConfigurationDescriptor {
    private LaunchConfigurationCreator launchConfigurationCreator;
    private String pluginCondition;
    public static final String PLUGIN_CONDITION = "pluginCondition";

    public DebuggerLaunchConfigurationDescriptorImplementation(IConfigurationElement element) {
        super(element);
        this.addSubstitution("sourceId", "debuggerId");
        this.addSubstitution("targetId", "launchConfigurationTypeId");
        this.pluginCondition = element.getAttribute(PLUGIN_CONDITION) != null ? element.getAttribute(PLUGIN_CONDITION) : "";
        try {
            Object executableObject = element.createExecutableExtension("launchConfigurationCreator");
            if (executableObject instanceof LaunchConfigurationCreator) {
                this.launchConfigurationCreator = (LaunchConfigurationCreator)executableObject;
            }
        }
        catch (CoreException e) {
            DebuggerRegistryCoreActivator.getDefault().logError(e.getMessage());
        }
    }

    public String getDebuggerId() {
        return this.getSourceId();
    }

    public String getLaunchConfigurationTypeIdentifier() {
        return this.getTargetId();
    }

    public LaunchConfigurationCreator getLaunchConfigurationCreator() {
        return this.launchConfigurationCreator;
    }

    public int hashCode() {
        return Objects.hash(this.getTargetId(), this.getSourceId());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DebuggerLaunchConfigurationDescriptorImplementation)) {
            return false;
        }
        DebuggerLaunchConfigurationDescriptorImplementation descriptor = (DebuggerLaunchConfigurationDescriptorImplementation)((Object)obj);
        return Objects.equals(this.getTargetId(), descriptor.getTargetId()) && Objects.equals(this.getSourceId(), descriptor.getSourceId());
    }

    public String getPluginCondition() {
        return this.pluginCondition;
    }
}

