/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.AGtmAction;
import com.nxp.swtools.gtm.gui.utils.GtmDisableTreeItemAction;
import com.nxp.swtools.gtm.gui.utils.GtmEnableTreeItemAction;
import com.nxp.swtools.gtm.gui.utils.GtmOpenDocumentationAction;
import com.nxp.swtools.gtm.gui.utils.GtmSetVisibleControlAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;

public class GtmToolActions {
    public static final Pattern SET_VISIBLE_REGEX = Pattern.compile("(setVisible)\\((.*)\\)", 8);
    public static final Pattern OPEN_DOCUMENTATION_REGEX = Pattern.compile("(openDocumentation)\\((.*)\\)", 8);
    private static final Pattern DISABLE_TREE_ITEM = Pattern.compile("(disableTreeItem)\\((.*)\\)", 8);
    private static final Pattern ENABLE_TREE_ITEM = Pattern.compile("(enableTreeItem)\\((.*)\\)", 8);
    public static final String SET_VISIBLE_FORMAT = "setVisible(%s)";
    private static final List<@NonNull AGtmAction> gtmToolPossibleActions = new ArrayList<AGtmAction>(Arrays.asList(new GtmSetVisibleControlAction(SET_VISIBLE_REGEX), new GtmOpenDocumentationAction(OPEN_DOCUMENTATION_REGEX), new GtmDisableTreeItemAction(DISABLE_TREE_ITEM), new GtmEnableTreeItemAction(ENABLE_TREE_ITEM)));

    public static void removeRefreshListeners(String action) {
        Node node;
        String controlID;
        Matcher setVisibleControlActionMatcher = SET_VISIBLE_REGEX.matcher(action);
        if (setVisibleControlActionMatcher.find() && setVisibleControlActionMatcher.groupCount() == 2 && (controlID = setVisibleControlActionMatcher.group(2)) != null && (node = GtmSceneCreator.getNodeById(controlID)) instanceof IRefreshableBaseControl) {
            ((IRefreshableBaseControl)node).removeRefreshListeners();
        }
    }

    public static void executeAction(String action) {
        for (AGtmAction gtmAction : gtmToolPossibleActions) {
            if (!gtmAction.isActionMatching(action)) continue;
            gtmAction.doAction();
        }
    }
}

