/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.GridPaneStructNode;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.AGtmAction;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;

public class GtmSetVisibleControlAction
extends AGtmAction {
    private static final Logger LOGGER = LogManager.getLogger(GtmSetVisibleControlAction.class);

    protected GtmSetVisibleControlAction(Pattern actionPattern) {
        super(actionPattern);
    }

    @Override
    public void doAction() {
        try {
            ABaseUIComponentSetting componentSetting;
            String controlID;
            if (this.actionMatcher != null && (controlID = this.actionMatcher.group(2)) != null && (componentSetting = UctUtils.getComponentSettingById((IMcu)GtmController.getInstance().getGtmMcu(), (String)controlID)) instanceof GtmStructSetting) {
                GtmStructSetting gtmStructSetting = (GtmStructSetting)componentSetting;
                Node node = GtmSceneCreator.getNodeById(controlID);
                if (node == null) {
                    Node parentNode;
                    String parentId = GtmUtils.getParentId((GtmStructSetting)GtmController.getInstance().getGtmMcu().getGtmLayoutContent(), (String)controlID);
                    if (parentId != null && (parentNode = GtmSceneCreator.getNodeById(parentId)) instanceof GridPaneStructNode) {
                        GridPaneStructNode gpNode = (GridPaneStructNode)parentNode;
                        GtmController.getInstance().markCurrentPanelSetting(gtmStructSetting);
                        GtmController.getInstance().checkRemainingVisibleSettings();
                        GtmController.getInstance().validate();
                        gtmStructSetting.setVisibleState(true);
                        StructSettingNode stSetting = new StructSettingNode(gtmStructSetting);
                        UctLayoutUtils.updateNodeState((Node)stSetting.getRegion(), (ABaseUIComponentSetting)gtmStructSetting);
                        gpNode.getChildren().add((Object)stSetting.getRegion());
                        GridPane.setFillWidth((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                        GridPane.setFillHeight((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                        GridPane.setValignment((Node)stSetting.getRegion(), (VPos)VPos.TOP);
                        GtmLayoutUtils.ensureVisible(parentNode, 0.0);
                    }
                } else {
                    GtmController.getInstance().markCurrentPanelSetting(gtmStructSetting);
                    GtmController.getInstance().checkRemainingVisibleSettings();
                    GtmController.getInstance().validate();
                    gtmStructSetting.setVisibleState(true);
                    UctLayoutUtils.updateNodeState((Node)node, (ABaseUIComponentSetting)componentSetting);
                    GtmLayoutUtils.ensureVisible(node, 0.0);
                    if (node instanceof IRefreshableBaseControl) {
                        ((IRefreshableBaseControl)node).refresh();
                        ((IRefreshableBaseControl)node).addRefreshListeners();
                    }
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.log(Level.SEVERE, "The action cannot be performed since there is no match");
        }
    }
}

