/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlTabular;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContext;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContextHorizontal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlTabularHorizontalProvider;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.TabularHorizontalItem;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ArrayControlTabularHorizontal
extends AArrayControlTabular {
    private static final String INDICES_LABEL = "#";
    private static final int OFFSET_HEADER_COLUMN = 1;
    protected static final int STATUS_ROW_OFFSET = 1;

    protected ArrayControlTabularHorizontal(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    @Override
    protected void tableViewerHandling(@NonNull TableViewer tableViewerLoc) {
        Table table = tableViewerLoc.getTable();
        ArrayControlTabularHorizontal.setTableLayout(table, this.arrayConfig.getId(), false);
        table.setHeaderVisible(false);
        this.createTableViewerHeaderColumn(tableViewerLoc);
        int column = 0;
        while (column < this.children.size()) {
            this.createTableViewerColumnHorizontal(column, tableViewerLoc);
            ++column;
        }
    }

    @Override
    protected @NonNull ArrayControlItemMenuContext getMenuContext(@NonNull TableViewer tableViewerLoc) {
        return new ArrayControlItemMenuContextHorizontal(this, tableViewerLoc);
    }

    @Override
    protected void updateTableViewer(@NonNull TableViewer viewerLoc) {
        int index;
        int columnCount;
        int childrenSize = this.children.size();
        if (childrenSize > (columnCount = viewerLoc.getTable().getColumnCount() - 1)) {
            index = columnCount;
            while (index < childrenSize) {
                this.createTableViewerColumnHorizontal(index, viewerLoc);
                ++index;
            }
        } else if (childrenSize < columnCount) {
            index = columnCount;
            while (index > childrenSize) {
                viewerLoc.getTable().getColumn(index).dispose();
                --index;
            }
        }
        ArrayControlTabularHorizontalProvider transformedChildrenProvider = new ArrayControlTabularHorizontalProvider(this.arrayConfig, this.children);
        viewerLoc.setInput(transformedChildrenProvider.getHorizontalItems());
        this.updateColumnHeaders(viewerLoc);
        TableColumn headerColumn = viewerLoc.getTable().getColumn(0);
        headerColumn.pack();
        if (this.contentContainer != null) {
            this.contentContainer.requestLayout();
        }
    }

    private void updateColumnHeaders(TableViewer viewer) {
        int i = 0;
        while (i < this.children.size()) {
            IChildControl childControl = (IChildControl)this.children.get(i);
            IChild childOfArray = childControl.getChild();
            int level = -1;
            String status = null;
            status = childOfArray.getError();
            if (status != null) {
                level = 2;
            } else {
                status = childOfArray.getWarning();
                if (status != null) {
                    level = 1;
                } else {
                    status = childOfArray.getInfo();
                    if (status != null) {
                        level = 0;
                    }
                }
            }
            Image image = null;
            if (level >= 0) {
                image = ToolsImages.getStatusIcon((int)level);
            }
            int columnIndex = i + 1;
            if (viewer.getTable().getColumnCount() <= columnIndex) {
                LOGGER.log(Level.SEVERE, "[TOOL] Trying to update column {0} which does not exist", String.valueOf(columnIndex));
            } else {
                TableColumn column = viewer.getTable().getColumn(columnIndex);
                column.setImage(image);
                column.setToolTipText(status);
            }
            ++i;
        }
    }

    @Nullable IChild getChildFromItem(@NonNull TabularHorizontalItem itemLoc, int columnPosition) {
        IChild currentChild = null;
        if (itemLoc.getChildConfigs().size() > columnPosition) {
            currentChild = itemLoc.getChildConfigs().get(columnPosition);
        }
        return currentChild;
    }

    @Override
    protected @NonNull String getMoveDownDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveRight;
    }

    @Override
    protected @NonNull String getMoveUpButtonDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveLeft;
    }

    @Override
    protected @Nullable Image getMoveUpIcon() {
        return ToolsImages.getImage((String)"icons/left.png");
    }

    @Override
    protected @Nullable Image getMoveDownIcon() {
        return ToolsImages.getImage((String)"icons/right.png");
    }

    protected void createTableViewerColumnHorizontal(final int columnPosition, @NonNull TableViewer tableViewerLoc) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewerLoc, 0);
        viewerColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ArrayControlTabularHorizontal.this.updateScrollSize();
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String label = null;
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null && element instanceof TabularHorizontalItem) {
                    if (((TabularHorizontalItem)element).getHeaderName().equals("#indices#")) {
                        return currentChild.getUiName();
                    }
                    if (((TabularHorizontalItem)element).getHeaderName().equals("#state#")) {
                        return null;
                    }
                }
                if (currentChild instanceof ScalarConfig) {
                    if (currentChild.isAvailable()) {
                        ScalarConfig currentSettingLoc = (ScalarConfig)currentChild;
                        label = AArrayControlTabular.getText(currentSettingLoc);
                    } else {
                        label = "N/A";
                    }
                }
                return label;
            }

            public Font getFont(Object element) {
                ScalarConfig config;
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null && !currentChild.isAvailable()) {
                    return ArrayControlTabularHorizontal.this.italicFont;
                }
                if (currentChild instanceof ScalarConfig && (config = (ScalarConfig)currentChild).getType().equals((Object)ScalarConfig.Type.INFO)) {
                    return ArrayControlTabularHorizontal.this.italicFont;
                }
                return null;
            }

            public Image getImage(Object element) {
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null && element instanceof TabularHorizontalItem && ((TabularHorizontalItem)element).getHeaderName().equals("#indices#")) {
                    return null;
                }
                if (currentChild != null) {
                    Image image = ArrayControlTabularHorizontal.this.getImageOfLinkedSettingState(currentChild);
                    if (image != null) {
                        return image;
                    }
                    if (((TabularHorizontalItem)element).getHeaderName().equals("#state#")) {
                        return null;
                    }
                    return AArrayControlTabular.getImage(currentChild, ArrayControlTabularHorizontal.this.getControlUpdateType());
                }
                return null;
            }

            public Color getForeground(Object element) {
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null) {
                    if (!currentChild.isEnabled() || !currentChild.isAvailable()) {
                        return DISABLED_TEXT_COLOR;
                    }
                    if (currentChild.isOptionSet("UI_SETTING_LINK")) {
                        if (!currentChild.isOptionAvailable("UI_SETTING_LINK")) {
                            return DISABLED_TEXT_COLOR;
                        }
                        return LINK_COLOR;
                    }
                }
                return super.getForeground(element);
            }

            public Color getBackground(Object element) {
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null) {
                    if (element instanceof TabularHorizontalItem) {
                        if (((TabularHorizontalItem)element).getHeaderName().equals("#indices#")) {
                            return AArrayControlTabular.getBackgroundColor(currentChild);
                        }
                        if (((TabularHorizontalItem)element).getHeaderName().equals("#state#")) {
                            return super.getBackground(element);
                        }
                    }
                    return AArrayControlTabular.getBackgroundColor(currentChild);
                }
                return super.getBackground(element);
            }

            public String getToolTipText(Object element) {
                IChild currentChild = ArrayControlTabularHorizontal.this.getChild(element, columnPosition);
                if (currentChild != null) {
                    return ArrayControlTabularHorizontal.getToolTip(currentChild);
                }
                return null;
            }
        });
        this.addEditingSupport(tableViewerLoc, viewerColumn, columnPosition);
        TableColumn column = viewerColumn.getColumn();
        column.pack();
        this.setColumnWidth(column, columnPosition + 1);
        if (column.getWidth() > 180) {
            column.setWidth(180);
        }
    }

    @Override
    protected IChild editingSupportSelectChild(Object element, int index) {
        this.setSelectedChild(this.getChildren().get(index));
        return this.getChild(element, index);
    }

    @Override
    protected void editingSupportPostAction(@NonNull TableViewer viewer, @NonNull TableViewerColumn viewerColumn) {
        this.selectChildOfColumn(viewer, viewerColumn.getColumn());
    }

    @Override
    protected boolean editingSupportCanEdit(@NonNull Object element, int index) {
        boolean canEdit = true;
        if (element instanceof TabularHorizontalItem && (((TabularHorizontalItem)element).getHeaderName().equals("#indices#") || ((TabularHorizontalItem)element).getHeaderName().equals("#state#"))) {
            return false;
        }
        IChild currentChild = this.getChild(element, index);
        if (currentChild != null) {
            canEdit = ArrayControlTabularHorizontal.isCellEnabled(currentChild);
        }
        return canEdit;
    }

    @Override
    protected @Nullable Object editingSupportGetValue(@NonNull Object element, int index) {
        String selectedItem = null;
        IChild currentChild = this.getChild(element, index);
        if (currentChild != null && currentChild.isAvailable() && currentChild instanceof ScalarConfig) {
            selectedItem = AArrayControlTabular.getText((ScalarConfig)currentChild);
        }
        return selectedItem;
    }

    @Override
    protected void editingSupportSetValue(@NonNull TableViewer tableViewerLoc, @NonNull Object element, int index, @Nullable Object userInputValue) {
        ScalarConfig currentSettingLoc;
        IChild currentChild = this.getChild(element, index);
        if (currentChild instanceof ScalarConfig && !(currentSettingLoc = (ScalarConfig)currentChild).getType().equals((Object)ScalarConfig.Type.ENUM) && (currentSettingLoc.getType().equals((Object)ScalarConfig.Type.INTEGER) || currentSettingLoc.getType().equals((Object)ScalarConfig.Type.FLOAT) || currentSettingLoc.getType().equals((Object)ScalarConfig.Type.STRING))) {
            this.controllerWrapper.getController().setValue(currentSettingLoc, userInputValue == null ? "" : UtilsText.safeString((String)userInputValue.toString()), (Object)tableViewerLoc);
        }
    }

    @Override
    protected IChildControl editingSupportGetChildControl(@NonNull Object element, int index) {
        return this.getChildren().get(index);
    }

    protected void createTableViewerHeaderColumn(@NonNull TableViewer tableViewerLoc) {
        TableViewerColumn headerViewerColumn = new TableViewerColumn(tableViewerLoc, 0);
        TableColumn headerColumn = headerViewerColumn.getColumn();
        headerColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ArrayControlTabularHorizontal.this.updateScrollSize();
            }
        });
        headerColumn.setAlignment(16384);
        headerViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TabularHorizontalItem) {
                    TabularHorizontalItem item = (TabularHorizontalItem)element;
                    if (item.getHeaderName().equals("#indices#")) {
                        return ArrayControlTabularHorizontal.INDICES_LABEL;
                    }
                    if (item.getHeaderName().equals("#state#")) {
                        return "";
                    }
                    return item.getHeaderName();
                }
                return "";
            }

            public Font getFont(Object element) {
                return ArrayControlTabularHorizontal.this.boldFont;
            }

            public @Nullable Color getForeground(@NonNull Object element) {
                boolean areAllChildrenUnavailable = true;
                if (element instanceof TabularHorizontalItem) {
                    TabularHorizontalItem item = (TabularHorizontalItem)element;
                    for (IChild currentChild : item.getChildConfigs()) {
                        if (!currentChild.isEnabled() || !currentChild.isAvailable()) continue;
                        areAllChildrenUnavailable = false;
                        break;
                    }
                }
                if (areAllChildrenUnavailable) {
                    return DISABLED_TEXT_COLOR;
                }
                return super.getForeground(element);
            }
        });
        if (headerColumn.getWidth() > 180) {
            headerColumn.setWidth(180);
        }
    }

    protected @Nullable IChild getChild(@Nullable Object element, int column) {
        TabularHorizontalItem item;
        if (element instanceof TabularHorizontalItem && (item = (TabularHorizontalItem)element).getChildConfigs() instanceof ArrayList) {
            return this.getChildFromItem(item, column);
        }
        return null;
    }

    @Override
    public @Nullable ISettingConfig getSelection() {
        IChildControl selectedChildLoc = this.getSelectedChild();
        if (selectedChildLoc != null) {
            return super.getChildFromSelection((ISelection)new StructuredSelection((Object)selectedChildLoc));
        }
        return null;
    }

    @Override
    protected int computeLimitedHeightOfTable(@NonNull Table table) {
        int itemHeight = table.getItemHeight();
        int tableVisibleRows = this.getControlOptions().getTableVisibleRows() + 1 + 1 + (this.getControlOptions().isArrayIndicesHidden() ? 0 : 1);
        return tableVisibleRows * itemHeight;
    }
}

