/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.provider.analytics.ActionAnalyticsBuilder;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.utils.ValidationProblemsMenuHelper;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public class ArrayControlItemMenu {
    protected static final Logger LOGGER = LogManager.getLogger(ArrayControlItemMenu.class);
    @NonNull
    protected AArrayControlInternal owner;
    @NonNull
    protected IArrayControlItemMenuControl control;
    @NonNull
    private MenuManager menuManager;
    @NonNull
    private Control parent;
    private IMenuListener menuListener;

    public ArrayControlItemMenu(@NonNull AArrayControlInternal owner, @NonNull IArrayControlItemMenuControl control, @NonNull Control parent) {
        this.owner = owner;
        this.control = control;
        this.parent = parent;
        MenuManager menuManagerLoc = new MenuManager("#Popup");
        menuManagerLoc.setRemoveAllWhenShown(true);
        this.menuManager = menuManagerLoc;
        this.fillManager(IChildControl.UpdateType.NORMAL);
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public @NonNull Menu getMenu() {
        return this.menuManager.createContextMenu(this.parent);
    }

    public void showUnder(@NonNull Rectangle bounds, @NonNull Control parent, @NonNull Display display) {
        Menu menuLoc = this.getMenu();
        Event event = new Event();
        event.x = bounds.x;
        event.y = bounds.y + bounds.height;
        menuLoc.setVisible(true);
        menuLoc.notifyListeners(22, event);
    }

    public void fillManager(final  @Nullable IChildControl.UpdateType updateType) {
        IMenuListener listenerLoc;
        this.menuManager.removeAll();
        if (this.menuListener != null) {
            this.menuManager.removeMenuListener(this.menuListener);
        }
        this.menuListener = listenerLoc = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean allowed = updateType != IChildControl.UpdateType.FORCE_DISABLE;
                boolean first = ArrayControlItemMenu.this.owner.isControlFirst(ArrayControlItemMenu.this.control.getSelectedItemHint());
                boolean last = ArrayControlItemMenu.this.owner.isControlLast(ArrayControlItemMenu.this.control.getSelectedItemHint());
                boolean isArrayHorizontal = ArrayControlItemMenu.this.owner.getControlOptions().isArrayHorizontal();
                IChild selectedSetting = ArrayControlItemMenu.this.control.getSelectedSettingHint();
                if (selectedSetting != null) {
                    ArrayList<@NonNull E> problems = new ArrayList();
                    problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)selectedSetting, (int)3));
                    problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)selectedSetting, (int)2));
                    problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)selectedSetting, (int)1));
                    ArrayList<@NonNull E> mergedProblems = new ArrayList(problems.size());
                    ValidationProblemsMenuHelper.mergeProblems(problems, mergedProblems);
                    if (!mergedProblems.isEmpty()) {
                        for (IBaseProblem problem : mergedProblems) {
                            if (!(problem instanceof IValidationProblem)) continue;
                            IValidationProblem validationProblem = (IValidationProblem)problem;
                            MenuManager problemMenuManager = new MenuManager(validationProblem.getDependency().getDescription());
                            ValidationProblemsMenuHelper.createPopupMenu((IBaseProblem)validationProblem, (MenuManager)problemMenuManager, (boolean)false);
                            manager.add((IContributionItem)problemMenuManager);
                        }
                        manager.add((IContributionItem)new Separator());
                    }
                }
                String message = isArrayHorizontal ? UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveLeft) : UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveUp);
                manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.moveItemFront(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), message, allowed && ArrayControlItemMenu.this.owner.isUiArrayReorderSpecified() && !first));
                message = isArrayHorizontal ? UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveRight) : UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveDown);
                manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.moveItemBack(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), message, allowed && ArrayControlItemMenu.this.owner.isUiArrayReorderSpecified() && !last));
                message = isArrayHorizontal ? UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveLeftmost) : UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveTop);
                manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.moveItemBeginning(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), message, allowed && ArrayControlItemMenu.this.owner.isUiArrayReorderSpecified() && !first));
                message = isArrayHorizontal ? UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveRightmost) : UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_MoveBottom);
                manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.moveItemEnd(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), message, allowed && ArrayControlItemMenu.this.owner.isUiArrayReorderSpecified() && !last));
                if (ArrayControlItemMenu.this.control.getSelectedSettingHint() != null) {
                    manager.add((IContributionItem)new Separator());
                    message = isArrayHorizontal ? UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_SetAllCols) : UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_SetAllRows);
                    if (ArrayControlItemMenu.this.owner.isSetAllSettingsToSupported(ArrayControlItemMenu.this.control)) {
                        manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.setAllSettingsTo(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), message, selectedSetting != null && selectedSetting.isAvailable()));
                    }
                }
                manager.add((IContributionItem)new Separator());
                manager.add(ArrayControlItemMenu.this.createMenuManagerItem(() -> ArrayControlItemMenu.this.owner.removeItem(ArrayControlItemMenu.this, ArrayControlItemMenu.this.control), UtilsText.safeString((String)Messages.get().ArrayControl_ItemMenu_Remove), allowed && !ArrayControlItemMenu.this.owner.isUiArrayFixedSpecified() && ArrayControlItemMenu.this.owner.getChild().canRemoveItem()));
                ISettingConfig currentItemConfig = ArrayControlItemMenu.this.owner.getCurrentItemConfig(ArrayControlItemMenu.this.control);
                if (currentItemConfig != null) {
                    String clipboardString = "";
                    Clipboard clipBoard = new Clipboard(ArrayControlItemMenu.this.getMenu().getDisplay());
                    Object clipboardContent = clipBoard.getContents((Transfer)TextTransfer.getInstance());
                    if (clipboardContent instanceof String) {
                        clipboardString = (String)clipboardContent;
                    }
                    String clipboardStringFinal = clipboardString;
                    Runnable copyAction = () -> {
                        String stringCopyResult = ArrayControlItemMenu.this.owner.getControllerWrapper().getController().copy(currentItemConfig);
                        if (UtilsText.isEmpty((String)stringCopyResult)) {
                            LOGGER.log(Level.SEVERE, "Copy did not produce String for the clipboard");
                            return;
                        }
                        clipBoard.setContents(new Object[]{stringCopyResult}, new Transfer[]{TextTransfer.getInstance()});
                    };
                    Runnable pasteAction = () -> {
                        ArrayControlItemMenu.this.owner.getControllerWrapper().getController().paste(currentItemConfig, clipboardStringFinal);
                        clipBoard.setContents(new Object[]{" "}, new Transfer[]{TextTransfer.getInstance()});
                    };
                    manager.add(ArrayControlItemMenu.this.createMenuManagerItem(copyAction, UtilsText.safeString((String)Messages.get().ChildControl_Copy), allowed && ArrayControlItemMenu.this.owner.getControllerWrapper().getController().canCopy(currentItemConfig)));
                    manager.add(ArrayControlItemMenu.this.createMenuManagerItem(pasteAction, UtilsText.safeString((String)Messages.get().ChildControl_Paste), allowed && ArrayControlItemMenu.this.owner.getControllerWrapper().getController().canPaste(currentItemConfig, clipboardStringFinal)));
                }
            }
        };
        this.menuManager.addMenuListener(listenerLoc);
    }

    @NonNull IAction createMenuManagerItem(@NonNull Runnable runnable, @NonNull String label, boolean enabled) {
        return this.createMenuManagerItem(runnable, label, enabled, null, null, null);
    }

    @NonNull IAction createMenuManagerItem(@NonNull Runnable runnable, @NonNull String label, boolean enabled, @Nullable String tooltip, @Nullable String testId, @Nullable ImageDescriptor imageDescriptor) {
        ActionAnalyticsBuilder builder = ActionAnalyticsBuilder.action((Runnable)runnable).text(label).enabled(enabled).image(imageDescriptor);
        if (tooltip != null) {
            builder.tooltip(tooltip);
        }
        if (testId != null) {
            builder.id(testId);
        }
        return builder.build();
    }
}

