/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.QuickSelectionControl;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StructControl
extends ChildProvidableControlBase {
    @Nullable
    protected Control label;
    @Nullable
    protected QuickSelectionControl quickSelection;

    public StructControl(@NonNull StructConfig structConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super((IChildProvidable)structConfig, controlOptions, controllerWrapper);
        if (this.getChild().getModelData().hasQuickSelections()) {
            this.quickSelection = new QuickSelectionControl((IPresettable)structConfig, controllerWrapper);
        }
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        Control labelControlLoc;
        super.create(composite, colSpan);
        Control mainControlLoc = this.mainControl;
        if (mainControlLoc != null) {
            mainControlLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, colSpan, 1));
        }
        if ((labelControlLoc = this.labelControl) != null) {
            labelControlLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, colSpan, 1));
            this.registerCopyPasteMenuOnLabel();
        }
    }

    @Override
    public void update(@NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        super.update(updateType);
        QuickSelectionControl quickSelectionControl = this.quickSelection;
        if (quickSelectionControl != null) {
            quickSelectionControl.update(updateType);
        }
    }

    @Override
    public @Nullable Control createLabelControl(@NonNull Composite composite) {
        QuickSelectionControl quickSelectionLoc = this.quickSelection;
        if (quickSelectionLoc != null && !quickSelectionLoc.isEmpty()) {
            Composite labelComposite = new Composite(composite, 0);
            labelComposite.setLayout((Layout)new GridLayoutComponents(2, false));
            Control labelLoc = super.createLabelControl(labelComposite);
            if (labelLoc != null) {
                FontFactory.changeStyle((Control)labelLoc, (int)1);
                Label actualLabel = this.labelControlInternal;
                if (actualLabel != null) {
                    this.createErrorDecoration((Control)actualLabel, 16512);
                }
                labelLoc.setLayoutData((Object)new GridDataComponents(4, 1024, true, false));
                this.label = labelLoc;
            }
            quickSelectionLoc.create(labelComposite, labelLoc == null ? 2 : 1);
            return labelComposite;
        }
        Control labelLoc = super.createLabelControl(composite);
        if (labelLoc != null) {
            FontFactory.changeStyle((Control)labelLoc, (int)1);
            Label actualLabel = this.labelControlInternal;
            if (actualLabel != null) {
                this.createErrorDecoration((Control)actualLabel, 16512);
            }
            this.label = labelLoc;
        }
        return labelLoc;
    }

    @Override
    protected void updateLabelContent(@NonNull Control labelCtrl, @NonNull IChildControl.UpdateType updateType) {
        Control labelLoc = this.label;
        if (labelLoc != null) {
            this.controlOptions.labelBold(true);
            super.updateLabelContent(labelLoc, updateType);
            String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)this.child));
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(labelLoc, toolTipText);
        }
    }

    @Override
    protected void fillTopOfMainControl(@NonNull Composite composite, int numColumns) {
        QuickSelectionControl quickSelectionLoc = this.quickSelection;
        if (this.controlOptions.isLabelHidden() && quickSelectionLoc != null && !quickSelectionLoc.isEmpty()) {
            quickSelectionLoc.create(composite, numColumns);
        }
    }

    @Override
    public void dispose() {
        if (this.quickSelection != null) {
            this.quickSelection.dispose();
        }
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        super.dispose();
    }

    public @NonNull StructConfig getChild() {
        return (StructConfig)super.getChild();
    }
}

