/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import animations.swt.ColorChanger;
import animations.swt.EaseSelector;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.controller.UiValueIdHolder;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.AScalarComboControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.text.TextBoxHelper;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScalarComboControl
extends AScalarComboControl {
    private static final int ANIMATION_TIME = 1500;
    @Nullable
    InstantSearchList combo;
    @NonNull
    private @NonNull Function<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TextBoxHelper.Status> checkFunction = newVal -> {
        String valueString;
        Object value = this.getChild().getValue();
        if (value instanceof String && (valueString = (String)value).startsWith("custom:")) {
            boolean isPredefined;
            InstantSearchList comboLoc = this.combo;
            boolean bl = isPredefined = comboLoc != null && !comboLoc.isDisposed() && comboLoc.getItems().contains(newVal);
            if (!this.getChild().isCustomValueValid(newVal) && !isPredefined) {
                return TextBoxHelper.Status.INVALID;
            }
        }
        return TextBoxHelper.Status.OK;
    };

    public ScalarComboControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public void update( @NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        String valueName = String.valueOf(this.getChild().getValue());
        if (valueName.equals("custom")) {
            SetSetting.CustomItem customItem = this.getChild().getCustomItem();
            DynamicEnumSetting.CustomValueSupport customValueSupport = this.getChild().getCustomValueSupport();
            if (customItem != null && customValueSupport != null) {
                customItem.setValue(customValueSupport.getDefaultValue());
            }
        }
        super.update(updateType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void updateMainContent(@NonNull Control contentControl, IChildControl.UpdateType updateType) {
        InstantSearchList comboLoc = this.combo;
        if (comboLoc != null) {
            if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
                String valueName;
                Text textBox = comboLoc.getTextBox();
                if (comboLoc.isAllowCustomValue()) {
                    TextBoxHelper.removeListenersOfType((Text)textBox, (int)24);
                    TextBoxHelper.removeListenersOfType((Text)textBox, (int)27);
                }
                @NonNull List items = this.controllerWrapper.getController().getEnumItems((ISettingConfig)this.getChild());
                Object[] arrayOfItems = (String[])items.stream().map(x -> x.getUiValue()).toArray(String[]::new);
                if (!Arrays.equals(comboLoc.getItems().toArray(), arrayOfItems)) {
                    comboLoc.setData("input", (Object)items);
                    comboLoc.setItems((String[])arrayOfItems);
                    ToolTipableImplementation tooltip = new ToolTipableImplementation();
                    ToolTipableMarkdownDescriptionDecorator decoratedTooltip = new ToolTipableMarkdownDescriptionDecorator((IToolTipable)tooltip);
                    for (UiValueIdHolder uiValueIdHolder : items) {
                        tooltip.setDescription(uiValueIdHolder.getDescription());
                        String itemDescription = UtilsText.safeString((String)decoratedTooltip.getDescription());
                        if (itemDescription.isEmpty()) continue;
                        comboLoc.addItemToolTip(uiValueIdHolder.getUiValue(), itemDescription);
                    }
                }
                if ((valueName = String.valueOf(this.getChild().getValue())).startsWith("custom:")) {
                    valueName = "custom";
                    comboLoc.setAllowCustomValue(true);
                }
                String value = this.controllerWrapper.getController().getEnumItemById((ISettingConfig)this.getChild(), valueName).getUiValue();
                if (!Objects.equals(comboLoc.getText(), value)) {
                    comboLoc.select(value);
                }
                if (comboLoc.isAllowCustomValue()) {
                    TextBoxHelper.attachModifyErrorListener(() -> SetSetting.CustomItem.parseValueFromStorableString((String)this.getChild().getStringValue()), (Text)textBox, this.checkFunction, () -> this.updateErrorDecoration((Control)comboLoc));
                }
            }
            if (this.mainControlInternal != null) {
                this.updateErrorDecoration(this.mainControlInternal);
            }
            this.updateErrorDecoration((Control)comboLoc);
        }
    }

    @Override
    protected void updateErrorDecoration(@NonNull Control controlWithDecoration) {
        InstantSearchList searchList;
        super.updateErrorDecoration(controlWithDecoration);
        if (controlWithDecoration instanceof InstantSearchList && !(searchList = (InstantSearchList)controlWithDecoration).isDisposed()) {
            String text = UtilsText.safeString((String)searchList.getText());
            boolean errorFlag = false;
            Color background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_list_BG");
            Color foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG");
            searchList.setData("state", (Object)"ok");
            if (this.child.getError() != null || this.checkFunction.apply(text) == TextBoxHelper.Status.INVALID) {
                background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
                foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG");
                searchList.setData("state", (Object)"error");
                errorFlag = true;
            } else if (this.child.getWarning() != null) {
                background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.warning_FG");
                foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.black_FG");
                searchList.setData("state", (Object)"warning");
                errorFlag = true;
            }
            if (KEPreferences.isAnimationsEnabled() && errorFlag) {
                ColorChanger cc = new ColorChanger((Control)searchList, background, EaseSelector.SPIKE);
                cc.play(1500);
            } else {
                searchList.setBackground(background);
            }
            searchList.setForeground(foreground);
        }
    }

    @Override
    protected @NonNull Composite createComposite(@NonNull Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridLayoutComponents comboCompositeLayout = new GridLayoutComponents();
        comboCompositeLayout.marginHeight = 0;
        comboCompositeLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)comboCompositeLayout);
        return comboComposite;
    }

    @Override
    protected void createControls(@NonNull Composite composite) {
        this.combo = this.createComboBox(composite);
    }

    @Override
    protected void addComboSelectionListener() {
        final InstantSearchList comboLoc = this.combo;
        if (comboLoc != null) {
            comboLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void widgetSelected(SelectionEvent e) {
                    String text = comboLoc.getText();
                    @NonNull List items = (List)Objects.requireNonNull(comboLoc.getData("input"));
                    SetSetting.CustomItem customItem = ScalarComboControl.this.getChild().getCustomItem();
                    for (UiValueIdHolder item : items) {
                        if (item.getId().equals("custom") && text.equals("Custom...")) {
                            if (customItem != null && customItem.isInDefaultState()) {
                                comboLoc.setAllowCustomValue(true);
                                customItem.setAsUsed();
                                DynamicEnumSetting.CustomValueSupport customValueSupport = ScalarComboControl.this.getChild().getCustomValueSupport();
                                if (customValueSupport != null) {
                                    text = customValueSupport.getDefaultValue();
                                }
                                comboLoc.setText(text);
                            }
                            ScalarComboControl.this.changeModelValue(SetSetting.CustomItem.getStorableFormat((String)text));
                            comboLoc.setSelection(new Point(0, text.length()));
                            ScalarComboControl.this.updateErrorDecoration((Control)comboLoc);
                            return;
                        }
                        if (!item.getUiValue().equals(text) || item.getId().equals("custom")) continue;
                        comboLoc.setAllowCustomValue(false);
                        if (customItem != null) {
                            customItem.setAsNotUsed();
                            customItem.setValue(UtilsText.safeString((String)"Custom..."));
                        }
                        if (Objects.equals(ScalarComboControl.this.getChild().getValue(), item.getId())) break;
                        ScalarComboControl.this.changeModelValue(item.getId());
                        break;
                    }
                    if (comboLoc.isAllowCustomValue()) {
                        String storableFormat = SetSetting.CustomItem.getStorableFormat((String)UtilsText.safeString((String)text));
                        if (!ScalarComboControl.this.getChild().getStringValue().equals(storableFormat)) {
                            ScalarComboControl.this.changeModelValue(storableFormat);
                        }
                    }
                    ScalarComboControl.this.updateErrorDecoration((Control)comboLoc);
                }
            });
        }
    }

    @Override
    protected void addSpecificListeners() {
    }
}

