/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.HtmlTooltip;
import com.nxp.swtools.common.ui.utils.swt.ITooltipProvider2;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ConfigSetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class ChildProvidableControlBase
extends ChildControlBase {
    @NonNull
    protected final @NonNull List<@NonNull IChildControl> children = new ArrayList<IChildControl>();
    @NonNull
    public static final String KEY_TAB_CHILD_CONTROL = String.valueOf(ChildProvidableControlBase.class.getCanonicalName()) + ".key_tab_child_control";
    @Nullable
    protected IChildControl selectedChild;
    protected int selectedChildIdx = -1;
    @Nullable
    protected CTabFolder tabFolder;
    @Nullable
    private SelectionListener tabSelectionListener;

    public ChildProvidableControlBase(@NonNull IChildProvidable childProvidable, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper, boolean createChildren) {
        super((IChild)childProvidable, controlOptions, controllerWrapper);
        if (createChildren) {
            for (IChild subChild : childProvidable.getChildren()) {
                ControlOptions overrideOptions;
                IChildControl subChildControl = ChildControlFactory.create(subChild, overrideOptions = this.createControlOptionsForChild(subChild), controllerWrapper);
                if (subChildControl == null) continue;
                this.children.add(subChildControl);
            }
        }
    }

    public ChildProvidableControlBase(@NonNull IChildProvidable childProvidable, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        this(childProvidable, controlOptions, controllerWrapper, true);
    }

    protected @NonNull ControlOptions createControlOptionsForChild(@NonNull IChild subChild) {
        ControlOptions overrideOptions = new ControlOptions();
        if (this.getControlOptions().isArrayIndicesHidden()) {
            overrideOptions.labelHidden(true);
        }
        if (ControlOptions.ShowContentAs.TABS.equals((Object)this.getControlOptions().getShowContentAs())) {
            if (subChild instanceof IChildProvidable) {
                overrideOptions.borderHidden(true);
                overrideOptions.labelHidden(true);
            }
        } else if (ControlOptions.ShowContentAs.TABLE.equals((Object)this.getControlOptions().getShowContentAs())) {
            overrideOptions = overrideOptions.borderHidden(true);
        } else if (ControlOptions.ShowContentAs.RADIO_GROUP.equals((Object)this.getControlOptions().getShowContentAs())) {
            overrideOptions.showContentAs(ControlOptions.ShowContentAs.RADIO_GROUP);
        } else if (ControlOptions.ShowContentAs.MASTER_DETAIL.equals((Object)this.getControlOptions().getShowContentAs())) {
            overrideOptions = overrideOptions.labelHidden(true);
        }
        return overrideOptions;
    }

    @Override
    public void update(@NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        IChildControl.UpdateType updateChildrenType = this.child.isEnabled() ? updateType : IChildControl.UpdateType.FORCE_DISABLE;
        this.updateStoredUpdateType(updateChildrenType);
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            if (!this.getChild().isAvailable()) {
                this.disposeContentOfOtherTabs(null);
            } else {
                this.updateTabs();
            }
        }
        super.update(updateType);
        for (IChildControl childControl : this.children) {
            childControl.update(updateChildrenType);
        }
        Control mainControlLoc = this.mainControl;
        if (mainControlLoc != null && !mainControlLoc.isDisposed()) {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(mainControlLoc, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateTabs() {
        tabFolderLoc = this.tabFolder;
        tabSelectionListenerLoc = this.tabSelectionListener;
        if (tabFolderLoc != null && tabSelectionListenerLoc != null) {
            tabFolderLoc.removeSelectionListener(tabSelectionListenerLoc);
        }
        childrenOfConfigIterator = this.getChild().getChildren().iterator();
        childrenIterator = this.children.iterator();
        childOfConfig = childrenOfConfigIterator.hasNext() != false ? (IChild)childrenOfConfigIterator.next() : null;
        childControl = childrenIterator.hasNext() != false ? childrenIterator.next() : null;
        ** GOTO lbl20
        {
            v0 = childOfConfig = childrenOfConfigIterator.hasNext() != false ? (IChild)childrenOfConfigIterator.next() : null;
            do {
                if (childOfConfig != null && "variable".equals(childOfConfig.getTypeName())) continue block0;
                if (childControl.getChild().equals(childOfConfig)) {
                    childOfConfig = childrenOfConfigIterator.hasNext() != false ? (IChild)childrenOfConfigIterator.next() : null;
                } else {
                    this.removeTabWithControl(childControl);
                    childControl.dispose();
                    childrenIterator.remove();
                }
                v1 = childControl = childrenIterator.hasNext() != false ? childrenIterator.next() : null;
lbl20:
                // 2 sources

            } while (childControl != null);
        }
        while (childOfConfig != null) {
            overrideOptions = this.createControlOptionsForChild(childOfConfig);
            subChildControl = ChildControlFactory.create(childOfConfig, overrideOptions, this.controllerWrapper);
            if (subChildControl != null) {
                this.children.add(subChildControl);
                this.createTabItem(subChildControl, 3);
            }
            v2 = childOfConfig = childrenOfConfigIterator.hasNext() != false ? (IChild)childrenOfConfigIterator.next() : null;
        }
        if (tabFolderLoc != null) {
            tabIndex = 0;
            i = 0;
            while (i < this.children.size()) {
                childControl = this.children.get(i);
                childLoc = childControl.getChild();
                shouldBeVisible = childLoc.isAvailable();
                if (shouldBeVisible) {
                    if (tabIndex >= tabFolderLoc.getItemCount()) {
                        this.createTabItem(childControl, 3, tabIndex);
                    } else {
                        tabItem = tabFolderLoc.getItem(tabIndex);
                        if (!tabItem.isDisposed()) {
                            if (tabItem.getData(ChildProvidableControlBase.KEY_TAB_CHILD_CONTROL) != childControl) {
                                this.createTabItem(childControl, 3, tabIndex);
                            } else {
                                tabItem.setText(childControl.getChild().getUiName());
                            }
                        }
                    }
                    ++tabIndex;
                } else {
                    this.removeTabWithControl(childControl);
                }
                ++i;
            }
            if (tabSelectionListenerLoc != null) {
                tabFolderLoc.addSelectionListener(tabSelectionListenerLoc);
            }
            i = 0;
            while (i < tabFolderLoc.getItemCount()) {
                tabItem = tabFolderLoc.getItem(i);
                tabChildControl = tabItem.getData(ChildProvidableControlBase.KEY_TAB_CHILD_CONTROL);
                if (!tabItem.isDisposed() && !this.children.contains(tabChildControl)) {
                    if (tabChildControl instanceof Control) {
                        ((Control)tabChildControl).dispose();
                    }
                    tabItem.dispose();
                }
                ++i;
            }
            tabToSelect = this.getTabToSelect();
            if (tabToSelect == null && tabFolderLoc.getItemCount() > 0) {
                tabToSelect = tabFolderLoc.getItem(0);
            }
            if (tabToSelect != null && !tabToSelect.isDisposed()) {
                tabFolderLoc.setSelection(tabToSelect);
                this.updateChildSelection(3);
            }
            if (!tabFolderLoc.isDisposed()) {
                this.updateErrorDecoration((Control)tabFolderLoc);
                tabFolderLoc.requestLayout();
            }
        }
    }

    private void removeTabWithControl(IChildControl childControl) {
        CTabFolder tabFolderLoc = this.tabFolder;
        if (tabFolderLoc == null) {
            return;
        }
        CTabItem[] cTabItemArray = tabFolderLoc.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (!tabItem.isDisposed() && tabItem.getData(KEY_TAB_CHILD_CONTROL) == childControl) {
                tabItem.dispose();
            }
            ++n2;
        }
    }

    @Override
    protected void updateErrorDecoration(@NonNull Control controlWithDecoration) {
        super.updateErrorDecoration(controlWithDecoration);
        if (controlWithDecoration instanceof CTabFolder) {
            CTabItem[] cTabItemArray = ((CTabFolder)controlWithDecoration).getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tabItem = cTabItemArray[n2];
                Object data = tabItem.getData(KEY_TAB_CHILD_CONTROL);
                if (data instanceof IChildControl) {
                    IChildControl childControl = (IChildControl)data;
                    IChild tabChild = childControl.getChild();
                    int highestSeverityProblemLevel = tabChild.getHighestSeverityProblemLevel();
                    if (highestSeverityProblemLevel >= 0 && highestSeverityProblemLevel <= 3) {
                        tabItem.setImage(ToolsImages.getStatusDecoratorImg((int)highestSeverityProblemLevel));
                    } else {
                        tabItem.setImage(null);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IChildControl childControl : this.children) {
            childControl.dispose();
        }
        this.tabFolder = null;
    }

    public @NonNull IChildProvidable getChild() {
        return (IChildProvidable)this.child;
    }

    public @NonNull List<@NonNull IChildControl> getChildren() {
        return CollectionsUtils.safeList(Collections.unmodifiableList(this.children));
    }

    @Override
    public @Nullable Control createMainControl(final @NonNull Composite composite) {
        Composite contentComposite = ControlOptions.ShowContentAs.TABS.equals((Object)this.getControlOptions().getShowContentAs()) ? this.createControlTabs(composite, 3, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildProvidableControlBase.this.updateChildSelection(3);
                ScrolledCompositeHelper.updateScrollSize((Composite)composite);
            }
        }) : this.createControlStandard(composite, 3);
        return contentComposite == composite ? null : contentComposite;
    }

    public @NonNull Composite createComposite(@NonNull Composite parentComposite, int numColumns) {
        return this.createComposite(parentComposite, numColumns, this, true);
    }

    public @NonNull Composite createComposite(@NonNull Composite parentComposite, int numColumns, @NonNull IChildControl childControl, boolean optimize) {
        GridLayoutComponents layout = new GridLayoutComponents(numColumns, false);
        if (optimize && childControl.getControlOptions().isBorderHidden() && !ControlOptions.ShowContentAs.TABS.equals((Object)this.getControlOptions().getShowContentAs())) {
            if (!this.getControlOptions().isLabelHidden() && !this.getControlOptions().isExpandGroupHidden()) {
                layout.marginWidth = 8;
                return ChildProvidableControlBase.createNewComposite(parentComposite, childControl, layout);
            }
            return parentComposite;
        }
        layout.marginWidth = 8;
        return ChildProvidableControlBase.createNewComposite(parentComposite, childControl, layout);
    }

    private static @NonNull Composite createNewComposite(@NonNull Composite parentComposite, @NonNull IChildControl childControl, @NonNull GridLayoutComponents layout) {
        int style = ChildProvidableControlBase.getSwtStyle(childControl);
        layout.horizontalSpacing = 8;
        Composite composite = new Composite(parentComposite, style);
        composite.setLayout((Layout)layout);
        return composite;
    }

    public @NonNull Composite createControlStandard(@NonNull Composite parentComposite, int numColumns) {
        Composite contentComposite = this.createComposite(parentComposite, numColumns);
        this.fillTopOfMainControl(contentComposite, numColumns);
        for (IChildControl childControl : this.children) {
            childControl.create(contentComposite, numColumns);
        }
        return contentComposite;
    }

    protected void fillTopOfMainControl(@NonNull Composite composite, int numColumns) {
    }

    public @NonNull Composite createControlTabs(@NonNull Composite parentComposite, int numColumns, @NonNull SelectionListener selectionListener) {
        CTabFolder tabFolderLoc;
        this.fillTopOfMainControl(parentComposite, numColumns);
        this.tabFolder = tabFolderLoc = new CTabFolder(parentComposite, 2048);
        ChildProvidableControlBase.createHtmlTooltipFolder(tabFolderLoc);
        tabFolderLoc.setLayoutData((Object)new GridDataComponents(4, 4, true, true));
        tabFolderLoc.addSelectionListener(selectionListener);
        tabFolderLoc.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                CTabFolder tabFolderFromEvent = (CTabFolder)e.widget;
                Point tabRelativeLocation = tabFolderLoc.toControl(new Point(e.x, e.y));
                CTabItem clickedTab = tabFolderFromEvent.getItem(tabRelativeLocation);
                if (clickedTab == null) {
                    return;
                }
                Object data = clickedTab.getData(KEY_TAB_CHILD_CONTROL);
                if (!(data instanceof ChildControlBase)) {
                    return;
                }
                ChildControlBase childControl = (ChildControlBase)data;
                IChild childInChildControl = childControl.getChild();
                if (!(childInChildControl instanceof ISettingConfig)) {
                    return;
                }
                ISettingConfig settingConfig = (ISettingConfig)childInChildControl;
                Menu menu = ChildProvidableControlBase.this.createCopyPasteMenu((Control)tabFolderLoc, settingConfig);
                tabFolderFromEvent.setMenu(menu);
                menu.setLocation(new Point(e.x, e.y));
                menu.setVisible(true);
            }
        });
        this.tabSelectionListener = selectionListener;
        this.restoreSelectionFromStorage();
        return tabFolderLoc;
    }

    protected void restoreSelectionFromStorage() {
        ProvidableSettingsSelectionStorageHelper selectionStorageHelper = ProvidableSettingsSelectionStorageHelper.getInstance();
        if (selectionStorageHelper.isStored(this)) {
            IChildControl childToSelect;
            String childId = selectionStorageHelper.getSelectedChild(this);
            IChildControl iChildControl = childToSelect = childId == null ? null : (IChildControl)CollectionsUtils.nullableOptionalGet(this.children.stream().filter(x -> x.getChild().getName().equals(childId)).findAny());
            if (childToSelect != null) {
                this.setSelectedChild(childToSelect);
            }
        }
    }

    public void updateChildSelection(int colSpan) {
        Object itemData;
        CTabItem selection;
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()) != null && (itemData = selection.getData(KEY_TAB_CHILD_CONTROL)) instanceof IChildControl) {
            Control selectionControl;
            IChildControl previouslySelectedChild = this.getSelectedChild();
            IChildControl childControl = (IChildControl)itemData;
            this.setSelectedChild(childControl);
            if ((childControl.isDisposed() || childControl instanceof ConfigSetControl && this.getControlOptions().shouldLayoutAsTabs()) && (selectionControl = selection.getControl()) instanceof Composite) {
                this.disposeContentOfOtherTabs(childControl);
                ControlOptions options = this.createControlOptionsForChild(childControl.getChild());
                childControl.getControlOptions().merge(options);
                childControl.create((Composite)selectionControl, colSpan);
                childControl.update(this.getControlUpdateType());
            }
            if (previouslySelectedChild == null || !previouslySelectedChild.equals(itemData)) {
                Composite control = (Composite)Objects.requireNonNull(selection.getControl());
                Objects.requireNonNull(control.getParent()).requestLayout();
                control.layout();
                Objects.requireNonNull(Objects.requireNonNull(this.parent).getParent()).pack();
            }
        }
    }

    private void disposeContentOfOtherTabs(@Nullable IChildControl controlToKeep) {
        for (IChildControl childLoc : this.children) {
            if (childLoc == controlToKeep || childLoc.isDisposed()) continue;
            childLoc.dispose();
        }
    }

    private @Nullable CTabItem getTabToSelect() {
        IChildControl childToSelect = this.getChildToSelect();
        if (this.tabFolder != null) {
            CTabItem[] cTabItemArray = this.tabFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (!item.isDisposed() && item.getData(KEY_TAB_CHILD_CONTROL) == childToSelect) {
                    return item;
                }
                ++n2;
            }
        }
        return null;
    }

    public @Nullable IChildControl getSelectedChild() {
        return this.selectedChild;
    }

    public @Nullable IChildControl getChildToSelect() {
        int newSelectionIdx = 0;
        IChildControl selectedChildLoc = this.selectedChild;
        int lastSelectionIdx = this.children.indexOf(selectedChildLoc);
        if (lastSelectionIdx < 0 && selectedChildLoc != null) {
            String selectedChildName = selectedChildLoc.getChild().getName();
            IChildControl childWithSameName = (IChildControl)CollectionsUtils.nullableOptionalGet(this.children.stream().filter(ch -> ch.getChild().getName().equals(selectedChildName)).findFirst());
            lastSelectionIdx = this.children.indexOf(childWithSameName);
            if (lastSelectionIdx < 0) {
                lastSelectionIdx = this.selectedChildIdx;
            }
        }
        if (lastSelectionIdx >= this.children.size()) {
            lastSelectionIdx = this.children.size() - 1;
        }
        if (lastSelectionIdx < 0) {
            lastSelectionIdx = 0;
        }
        if (lastSelectionIdx >= 0 && lastSelectionIdx < this.children.size()) {
            newSelectionIdx = lastSelectionIdx;
            if (!this.children.get(lastSelectionIdx).getChild().isAvailable()) {
                while (newSelectionIdx < this.children.size() && !this.children.get(newSelectionIdx).getChild().isAvailable()) {
                    ++newSelectionIdx;
                }
                if (newSelectionIdx >= this.children.size()) {
                    newSelectionIdx = lastSelectionIdx - 1;
                    while (newSelectionIdx >= 0 && !this.children.get(newSelectionIdx).getChild().isAvailable()) {
                        --newSelectionIdx;
                    }
                }
            }
        }
        return newSelectionIdx >= 0 && newSelectionIdx < this.children.size() ? this.children.get(newSelectionIdx) : null;
    }

    public void createTabItem(@NonNull IChildControl childControl, int numColumns) {
        this.createTabItem(childControl, numColumns, -1);
    }

    public void createTabItem(@NonNull IChildControl childControl, int numColumns, int index) {
        CTabFolder tabFolderLoc = this.tabFolder;
        if (tabFolderLoc != null) {
            if (index < 0 || index > tabFolderLoc.getItemCount()) {
                index = tabFolderLoc.getItemCount();
            }
            CTabItem tabItem = new CTabItem(tabFolderLoc, 0, index);
            Composite contentComposite = this.createComposite((Composite)tabFolderLoc, numColumns, childControl, true);
            tabItem.setControl((Control)contentComposite);
            tabItem.setText(childControl.getChild().getUiName());
            tabItem.setData(KEY_TAB_CHILD_CONTROL, (Object)childControl);
            tabItem.setToolTipText("");
            contentComposite.requestLayout();
        }
    }

    public void setSelectedChild(@Nullable IChildControl selectedChild) {
        this.selectedChild = selectedChild;
        this.selectedChildIdx = this.children.indexOf(selectedChild);
        ProvidableSettingsSelectionStorageHelper.getInstance().setSelectedChild(this, selectedChild != null ? selectedChild.getChild().getName() : null);
    }

    public void selectChildTab(@NonNull IChildControl selectedChild) {
        CTabFolder tabFolderLoc = this.tabFolder;
        if (tabFolderLoc != null) {
            int i = 0;
            while (i < tabFolderLoc.getItems().length) {
                Object itemData = tabFolderLoc.getItem(i).getData(KEY_TAB_CHILD_CONTROL);
                if (selectedChild.equals(itemData)) {
                    tabFolderLoc.setSelection(i);
                    return;
                }
                ++i;
            }
        }
    }

    private static void createHtmlTooltipFolder(final @NonNull CTabFolder folder) {
        HtmlTooltip htmlTooltip = SWTFactoryProxy.INSTANCE.createHtmlTooltip((Control)folder, (Object)new ITooltipProvider2(){

            public String getToolTipText(Event event) {
                Object property;
                CTabItem item = folder.getItem(new Point(event.x, event.y));
                if (item != null && (property = item.getData(KEY_TAB_CHILD_CONTROL)) instanceof IChildControl) {
                    return ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)((IChildControl)property).getChild()));
                }
                return null;
            }

            public String getToolTipText() {
                return null;
            }
        });
        folder.setData("SWTFactory.HtmlToolTip", (Object)htmlTooltip);
    }

    @Override
    public boolean isCollapsible() {
        IChildControl parentChildControl = this.getParentChildControl();
        return parentChildControl == null || !parentChildControl.getControlOptions().isMultiColumn();
    }

    @Override
    public void setParentControl(IChildControl parentChildControl) {
        super.setParentControl(parentChildControl);
        for (IChildControl childLoc : this.children) {
            childLoc.setParentControl(this);
        }
    }
}

