/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

@NonNullByDefault
public class MigrationReportDialog
extends Dialog {
    private static final Logger LOGGER = LogManager.getLogger(MigrationReportDialog.class);
    private Shell parentShell;
    private String pathToFile = "";
    private int severesCount = 0;
    private int warningsCount = 0;
    private int infosCount = 0;

    protected @NonNull Control createDialogArea(@NonNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        MigrationReportDialog.createInfoRow(composite);
        this.createStatusRow(composite);
        this.createLinkRow(composite, this.pathToFile);
        return composite;
    }

    private static void createInfoRow(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.get().MigrationReportDialog_InfoRow_Message);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)label);
    }

    private Composite createStatusRow(Composite parent) {
        Composite statusRow = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(15, 5).applyTo(statusRow);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)statusRow);
        MigrationReportDialog.createStatusLevelWidgets(statusRow, 2, String.valueOf(this.severesCount));
        MigrationReportDialog.createStatusLevelWidgets(statusRow, 1, String.valueOf(this.warningsCount));
        MigrationReportDialog.createStatusLevelWidgets(statusRow, 0, String.valueOf(this.infosCount));
        return statusRow;
    }

    private static Composite createStatusLevelWidgets(Composite parent, int level, String count) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label icon = new Label(composite, 0);
        icon.setImage(ToolsImages.getStatusDecoratorImg((int)level));
        GridDataFactory.fillDefaults().applyTo((Control)icon);
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format("{0}: {1}", MigrationReportDialog.getErrorLevelString(level), count));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        return composite;
    }

    private static String getErrorLevelString(int level) {
        switch (level) {
            case 0: {
                return Messages.get().MigrationReportDialog_StatusRow_Infos;
            }
            case 1: {
                return Messages.get().MigrationReportDialog_StatusRow_Warnings;
            }
        }
        return Messages.get().MigrationReportDialog_StatusRow_Severes;
    }

    private Composite createLinkRow(Composite parent, final String pathToReportFile) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.get().MigrationReportDialog_LinkRow_PathToFile);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)label);
        Link link = new Link(composite, 0);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)link, "periphsMigrationReportDialogLink");
        link.setText(MessageFormat.format("<a href=\"{0}\">{0}</a>", pathToReportFile));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent event) {
                File file = new File(pathToReportFile);
                if (!file.exists()) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Migration report file \"{0}\" does not exist", pathToReportFile);
                    return;
                }
                try {
                    URL url = file.toURI().toURL();
                    IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    MigrationReportDialog.this.tryOpenUrlInBrowser(url, externalBrowser);
                }
                catch (MalformedURLException e) {
                    MessageDialog.openError((Shell)MigrationReportDialog.this.getShell(), (String)Messages.get().MigrationReportDialog_ErrorDialog_Title, (String)MessageFormat.format(Messages.get().MigrationReportDialog_ErrorDialog_MalformedURL, e.getLocalizedMessage()));
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)MigrationReportDialog.this.getShell(), (String)Messages.get().MigrationReportDialog_ErrorDialog_Title, (String)MessageFormat.format(Messages.get().MigrationReportDialog_ErrorDialog_NoExternalBrowser, e.getLocalizedMessage()));
                }
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)link);
        final Button copyToClipboardButton = new Button(composite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)copyToClipboardButton, "periphsMigrationReportDialogCopyButton");
        copyToClipboardButton.setImage(ToolsImages.getImage((String)"icons/copy.png"));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)copyToClipboardButton, Messages.get().ScalarCopyControl_Button_Text);
        copyToClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(copyToClipboardButton.getDisplay());
                clipboard.setContents(new Object[]{pathToReportFile}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)copyToClipboardButton);
        return composite;
    }

    protected MigrationReportDialog(Shell parentShell, String pathToFile, int severesCount, int warningsCount, int infosCount) {
        super(parentShell);
        this.parentShell = parentShell;
        this.pathToFile = pathToFile;
        this.severesCount = severesCount;
        this.warningsCount = warningsCount;
        this.infosCount = infosCount;
    }

    protected void configureShell(@NonNull Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().MigrationReportDialog_Dialog_Title);
        newShell.setMinimumSize(500, 200);
        ShellProvider.centerShell((Shell)newShell, (Shell)this.parentShell);
    }

    protected void createButtonsForButtonBar(@NonNull Composite composite) {
        this.createButton(composite, 0, Messages.get().MigrationReportDialog_Dialog_Close, true);
    }

    private void tryOpenUrlInBrowser(URL url, IWebBrowser externalBrowser) {
        try {
            externalBrowser.openURL(url);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.get().MigrationReportDialog_ErrorDialog_Title, (String)MessageFormat.format(Messages.get().MigrationReportDialog_ErrorDialog_CouldNotOpenLink, e.getLocalizedMessage()));
        }
    }

    public static int open(Shell shell, String pathToFile, int severesCount, int warningsCount, int infosCount) {
        MigrationReportDialog dialog = new MigrationReportDialog(shell, pathToFile, severesCount, warningsCount, infosCount);
        dialog.setBlockOnOpen(true);
        return dialog.open();
    }

    public static int open(Shell shell, String pathToFile, int[] messagescount) {
        if (messagescount.length != 3) {
            return 1;
        }
        MigrationReportDialog dialog = new MigrationReportDialog(shell, pathToFile, messagescount[0], messagescount[1], messagescount[2]);
        dialog.setBlockOnOpen(true);
        return dialog.open();
    }
}

