/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import org.eclipse.cdt.dsf.debug.service.IRunControl.IExecutionDMContext;
import com.freescale.system.browser2.OSAwarenessData2;

public class OSAwarenessData2 {
	public static final String DEFAULT_OS_CONTRIBUTOR_ID = "my_os";//$NON-NLS-1$
	private static final OSAwarenessData2 DUMMY_DATA = new OSAwarenessData2(null);

	private final IExecutionDMContext context;
	private ISimpleTableDataProvider2 link = null;

	public static OSAwarenessData2 getDummyData() {
		return DUMMY_DATA;
	}

	public OSAwarenessData2(IExecutionDMContext newContext) {
		context = newContext;
	}

	public final IExecutionDMContext getContext() {
		return context;
	}

	public final void setLink(ISimpleTableDataProvider2 fTaskData) {
		assert (fTaskData != null);
		link = fTaskData;
	}

	public ISimpleTableDataProvider2 getLink() {
		return link;
	}
}
