/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.freescale.system.browser.epl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IFilter;
import com.freescale.system.browser.epl.help.SectionDescriptorEpl;
import com.freescale.system.browser.epl.help.ICustomSectionDescriptorEpl;
import com.freescale.system.browser.epl.ISectionEpl;
import com.freescale.system.browser.epl.help.ICustomSectionDescriptorEpl;
import com.freescale.system.browser.epl.help.SectionDescriptorEpl;


/**
 * Embodies the description of a section in the systemContributor extension
 * (XML).
 */
public class CustomSectionDescriptorEpl extends SectionDescriptorEpl
		implements ICustomSectionDescriptorEpl {
		
	private static final String ATT_AFTER_SECTION = "afterSection"; //$NON-NLS-1$

	private static final String ATT_CLASS = "class"; //$NON-NLS-1$

	private static final String ATT_SECTION_FILTER = "filter"; //$NON-NLS-1$	

	private static final String TOP = "top"; //$NON-NLS-1$
	
	/**
	 * A section can optionally specify that it appear after another section, by
	 * section ID
	 */
	private String fAfterSection;

	/**
	 * If a static list of input types (in XML) is insufficient to specify the
	 * applicability of a section to the active context, a filtering class can
	 * optionally be specified (in XML) in lieu or in addition to the static
	 * list.
	 */
	private IFilter fFilter;


	/**
	 * Constructor for the section descriptor.
	 * 
	 * @param configurationElement
	 *            the configuration element for the section descriptor.
	 * @param typeMapper
	 *            The type mapper.
	 */
	protected CustomSectionDescriptorEpl(IConfigurationElement configurationElement) {
		super(configurationElement);
		
		if (getId() == null || getTargetTab() == null) {
			// the section id and tab are mandatory - log error
			handleSectionError(null);
		}
		
		fAfterSection = getConfigurationElement().getAttribute(ATT_AFTER_SECTION);		
		if (getAfterSection() == null) {
			fAfterSection = TOP;
		}
	}

	/* (non-Javadoc)
	 * @see com.freescale.system.browser.ui.tabbed.ISectionDescriptor#getFilter()
	 */
	@Override
	public final IFilter getFilter() {
		if (fFilter == null) {
			try {
				if (getConfigurationElement().getAttribute(ATT_SECTION_FILTER) != null) {
					fFilter = (IFilter)getConfigurationElement().createExecutableExtension(ATT_SECTION_FILTER);
				}
			} catch (CoreException exception) {
				handleSectionError(exception);
			}
		}
		return fFilter;
	}
	
	/* (non-Javadoc)
	 * @see com.freescale.system.browser.ui.tabbed.ISectionDescriptor#getAfterSection()
	 */
	public String getAfterSection() {
		return fAfterSection;
	}

	/* (non-Javadoc)
	 * @see com.freescale.system.browser.ui.tabbed.ISectionDescriptor#getSection()
	 */
	@Override
	public final ISectionEpl getSection() {
		ISectionEpl section = null;

		try {
			section = (ISectionEpl)getConfigurationElement().createExecutableExtension(ATT_CLASS);
		} catch (CoreException exception) {
			handleSectionError(exception);
		}

		return section;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getId();
	}
}
