/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator.utils;

import java.util.LinkedList;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class Utils {
    public static String quotePath(String path) {
        if (!Utils.isQuoted(path)) {
            return "\"" + path + "\"";
        }
        return path;
    }

    public static String removeQuotes(String path) {
        if (Utils.isQuoted(path)) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static boolean containsSpecialCharacters(String path) {
        return path.matches(".*(\\s|[\\{\\}\\(\\)\\$\\@%=;]).*");
    }

    public static String removeEscapeSequence(String path) {
        String sequence = "\\ ";
        int index = path.indexOf(sequence);
        while (index > -1) {
            path = String.valueOf(path.substring(0, index)) + path.substring(index + 1);
            index = path.indexOf(sequence);
        }
        return path;
    }

    public static String getPrefixBeforeQuotes(String value) {
        int index = 0;
        int lastIndex = 0;
        if (value.contains("\\\"")) {
            index = value.indexOf("\\\"");
            lastIndex = value.lastIndexOf("\\\"");
        } else {
            index = value.indexOf("\"");
            lastIndex = value.lastIndexOf("\"");
        }
        if (index != -1 && index != lastIndex) {
            return value.substring(0, index);
        }
        return null;
    }

    public static boolean isQuoted(String path) {
        return path.startsWith("\"") && path.endsWith("\"");
    }

    public static boolean isPathEscaped(String path) {
        return path.indexOf("\\ ") > -1;
    }

    public static boolean pathEquals(IPath first, IPath second) {
        if (Platform.getOS().equals("win32")) {
            return first.toOSString().toLowerCase().equals(second.toOSString().toLowerCase());
        }
        return first.equals((Object)second);
    }

    public static String getDefaultOutputName(ITool tool, IPath path) {
        String[] extensions;
        IOutputType[] types;
        IOutputType outputType;
        String outputName = null;
        IPath tmpOutputName = path.removeFileExtension();
        if (tmpOutputName.lastSegment().endsWith(".")) {
            String segment = tmpOutputName.lastSegment();
            tmpOutputName = tmpOutputName.removeLastSegments(1).append(segment.substring(0, segment.lastIndexOf(".")));
        }
        if ((outputType = tool.getPrimaryOutputType()) != null && outputType.getOutputExtensionsAttribute() != null && outputType.getOutputExtensionsAttribute().length > 0) {
            outputName = tmpOutputName.addFileExtension(outputType.getOutputExtensionsAttribute()[0]).lastSegment();
        }
        if (outputName == null && (types = tool.getOutputTypes()) != null && types.length > 0 && types[0].getOutputExtensionsAttribute() != null && types[0].getOutputExtensionsAttribute().length > 0) {
            outputName = tmpOutputName.addFileExtension(types[0].getOutputExtensionsAttribute()[0]).lastSegment();
        }
        if (outputName == null && (extensions = tool.getAllOutputExtensions()) != null && extensions.length > 0) {
            outputName = tmpOutputName.addFileExtension(extensions[0]).lastSegment();
        }
        if (outputName == null) {
            outputName = tmpOutputName.lastSegment();
        }
        return outputName;
    }

    public static String[] mergeLinesWithQuotes(String[] lines) {
        LinkedList<String> result = new LinkedList<String>();
        String currentLine = null;
        int i = 0;
        while (i < lines.length) {
            if (currentLine != null) {
                currentLine = String.valueOf(currentLine) + " " + lines[i];
                if (lines[i].indexOf("\"") != -1) {
                    result.addLast(currentLine);
                    currentLine = null;
                }
            } else if (lines[i].indexOf("\"") != -1 && lines[i].lastIndexOf("\"") == lines[i].indexOf("\"")) {
                currentLine = lines[i];
            } else {
                result.add(lines[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[] mergeLinesWithEscape(String[] lines) {
        LinkedList<String> result = new LinkedList<String>();
        String currentLine = null;
        int i = 0;
        while (i < lines.length) {
            if (currentLine != null) {
                currentLine = String.valueOf(currentLine) + " " + lines[i];
                if (!lines[i].endsWith("\\")) {
                    result.addLast(currentLine);
                    currentLine = null;
                } else {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
            } else if (lines[i].endsWith("\\")) {
                currentLine = lines[i].substring(0, lines[i].length() - 1);
            } else {
                result.add(lines[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static boolean isShielded(String value) {
        return value.contains("\\\"");
    }
}

