/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry;

import com.nxp.s32ds.cle.runtime.hardware.registry.ClusterDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class DeviceRegistryImplementation
extends BaseRegistry
implements DeviceRegistry {
    private final Map<String, DeviceDescriptor> deviceDescriptors = new HashMap<String, DeviceDescriptor>();
    private final Map<String, String> deviceSubstitution = new HashMap<String, String>();
    private final Map<String, DeviceCoreDescriptor> deviceCoreDescriptors = new HashMap<String, DeviceCoreDescriptor>();
    private final Map<String, String> deviceCoreSubstitution = new HashMap<String, String>();
    private final Map<String, Collection<DeviceCoreDescriptor>> device2deviceCoreDescriptors = new HashMap<String, Collection<DeviceCoreDescriptor>>();
    private final Map<String, Collection<String>> device2deviceRevisions = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<DeviceCoreDescriptor>> core2deviceCoreDescriptors = new HashMap<String, Collection<DeviceCoreDescriptor>>();
    private final Map<String, ClusterDescriptor> clusterDescriptors = new HashMap<String, ClusterDescriptor>();
    private final Map<String, String> clusterSubstitution = new HashMap<String, String>();

    @Override
    public List<ClusterDescriptor> getClusterDescriptors() {
        return new ArrayList<ClusterDescriptor>(this.clusterDescriptors.values());
    }

    @Override
    public void addClusterDescriptor(ClusterDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.clusterDescriptors, ClusterDescriptor.class);
    }

    @Override
    public void addClusterSubstitution(String key, String value) {
        this.clusterSubstitution.put(key, value);
    }

    @Override
    public ClusterDescriptor getClusterDescriptor(String clusterId) {
        return this.clusterDescriptors.get(clusterId);
    }

    @Override
    public ClusterDescriptor getClusterDescriptorByName(String clusterName) {
        for (ClusterDescriptor cluster : this.clusterDescriptors.values()) {
            if (!cluster.getName().equals(clusterName)) continue;
            return cluster;
        }
        return null;
    }

    @Override
    public List<DeviceDescriptor> getDeviceDescriptors() {
        return new ArrayList<DeviceDescriptor>(this.deviceDescriptors.values());
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(String deviceId) {
        String substituteValue = this.deviceSubstitution.get(deviceId);
        if (substituteValue == null) {
            substituteValue = deviceId;
        }
        return this.deviceDescriptors.get(substituteValue);
    }

    @Override
    public void addDeviceDescriptor(DeviceDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.deviceDescriptors, DeviceDescriptor.class);
        this.addDeviceRevision(descriptor);
    }

    private void addDeviceRevision(DeviceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        String revision = descriptor.getRevision();
        if (revision != null && !revision.isEmpty()) {
            this.device2deviceRevisions.computeIfAbsent(descriptor.getId(), revisions -> new ArrayList()).add(revision);
        }
    }

    @Override
    public Collection<String> getRevisionByDevice(String deviceId) {
        return this.device2deviceRevisions.getOrDefault(deviceId, Collections.emptyList());
    }

    @Override
    public void removeDeviceDescriptor(DeviceDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.deviceDescriptors, DeviceDescriptor.class);
    }

    @Override
    public void addDeviceSubstitution(String key, String value) {
        this.deviceSubstitution.put(key, value);
    }

    @Override
    public List<DeviceCoreDescriptor> getDeviceCoreDescriptors() {
        return new ArrayList<DeviceCoreDescriptor>(this.deviceCoreDescriptors.values());
    }

    @Override
    public DeviceCoreDescriptor getDeviceCoreDescriptor(String deviceCoreId) {
        String substituteValue = this.deviceCoreSubstitution.get(deviceCoreId);
        if (substituteValue == null) {
            substituteValue = deviceCoreId;
        }
        return this.deviceCoreDescriptors.get(substituteValue);
    }

    @Override
    public void addDeviceCoreSubstitution(String key, String value) {
        this.deviceCoreSubstitution.put(key, value);
    }

    @Override
    public void addDeviceCoreDescriptor(DeviceCoreDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.deviceCoreDescriptors, DeviceCoreDescriptor.class);
        this.addReferenceDescriptor(descriptor, this.device2deviceCoreDescriptors, this.core2deviceCoreDescriptors, DeviceCoreDescriptor.class);
    }

    @Override
    public void removeDeviceCoreDescriptor(DeviceCoreDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.deviceCoreDescriptors, DeviceCoreDescriptor.class);
        this.removeReferenceDescriptor(descriptor, this.device2deviceCoreDescriptors, this.core2deviceCoreDescriptors, DeviceCoreDescriptor.class);
    }

    @Override
    public List<DeviceCoreDescriptor> getDeviceCoreDescriptorsByCoreId(String coreId) {
        return this.getReferenceDescriptorsByTargetId(coreId, this.core2deviceCoreDescriptors, DeviceCoreDescriptor.class);
    }

    @Override
    public List<DeviceCoreDescriptor> getDeviceCoreDescriptorsByDeviceId(String deviceId) {
        return this.getReferenceDescriptorsBySourceId(deviceId, this.device2deviceCoreDescriptors, DeviceCoreDescriptor.class);
    }
}

