/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.implementation;

import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerCategory;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerComponent;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerRequiredComponent;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SoftwareManagerPackageDescriptorImplementation
implements SoftwareManagerPackageDescriptor {
    private final String id;
    private final String name;
    private final String version;
    private String description;
    private final Collection<SoftwareManagerComponent> components = new ArrayList<SoftwareManagerComponent>();
    private final Collection<SoftwareManagerRequiredComponent> requiredComponents = new ArrayList<SoftwareManagerRequiredComponent>();
    private final Set<SoftwareManagerVariable> managerVariables = new HashSet<SoftwareManagerVariable>();
    private final Collection<SoftwareManagerCategory> managerCategories = new HashSet<SoftwareManagerCategory>();

    SoftwareManagerPackageDescriptorImplementation(String id, String name, String version) {
        this.id = id;
        this.name = name;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<SoftwareManagerComponent> getComponents() {
        return new ArrayList<SoftwareManagerComponent>(this.components);
    }

    public Collection<SoftwareManagerRequiredComponent> getRequiredComponents() {
        return new ArrayList<SoftwareManagerRequiredComponent>(this.requiredComponents);
    }

    public Set<SoftwareManagerVariable> getVariables() {
        return new HashSet<SoftwareManagerVariable>(this.managerVariables);
    }

    public Collection<SoftwareManagerCategory> getCategories() {
        return new ArrayList<SoftwareManagerCategory>(this.managerCategories);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void addComponent(SoftwareManagerComponent component) {
        if (component != null) {
            this.components.add(component);
        }
    }

    public void addRequiredComponent(SoftwareManagerRequiredComponent requiredComponent) {
        if (requiredComponent != null) {
            this.requiredComponents.add(requiredComponent);
        }
    }

    public void addSoftwareManagerVariable(SoftwareManagerVariable softwareManagerVariable) {
        this.managerVariables.add(softwareManagerVariable);
    }

    public void addCategory(SoftwareManagerCategory softwareManagerCategory) {
        this.managerCategories.add(softwareManagerCategory);
    }

    public void removeComponent(SoftwareManagerComponent component) {
        this.components.remove(component);
    }

    public void removeRequiredComponent(SoftwareManagerRequiredComponent requiredComponent) {
        this.requiredComponents.remove(requiredComponent);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoftwareManagerPackageDescriptorImplementation)) {
            return false;
        }
        SoftwareManagerPackageDescriptorImplementation softwareManagerPackageDescriptorImplementation = (SoftwareManagerPackageDescriptorImplementation)o;
        return Objects.equals(this.id, softwareManagerPackageDescriptorImplementation.getId());
    }

    public String toString() {
        return "id=" + this.id + " name=" + this.name + " version=" + this.version;
    }
}

