/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.PIWriter;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.Messages;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.jaxb.Export;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.net.URI;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectInfoExporter {
    private final ProjectInfoExportSettings settings;

    public ProjectInfoExporter(ProjectInfoExportSettings settings) {
        this.settings = settings;
    }

    public boolean writeProjectInfo() {
        Path path = this.settings.getOutputFile();
        try {
            JAXBContext ctx = OrbitJAXBContextFactory.createContext(Export.class);
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Export export = new PIWriter(this.settings).createExport();
            marshaller.marshal((Object)export, path.toFile());
            ResourcesUtil.refreshWorkspaceFiles((URI)URIUtil.toURI((String)path.toString()));
        }
        catch (Exception e) {
            String error = e.getMessage() != null ? NLS.bind((String)Messages.ProjectInfoExporter_export_error, (Object)e.getMessage()) : NLS.bind((String)Messages.ProjectInfoExporter_export_error, (Object)Messages.ProjectInfoExporter_export_error_unknown);
            PIActivator.getDefault().logError(error);
            try {
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler(PIActivator.HANDLER_ID_EXPORT_ERROR).handleStatus((IStatus)new Status(1, PIActivator.getDefault().getBundleId(), error), (Object)this);
            }
            catch (CoreException ex) {
                PIActivator.getDefault().log(ex.getStatus());
            }
            return false;
        }
        return true;
    }

    public static boolean canExportProject(IProject project) {
        block6: {
            block5: {
                if (project.hasNature(ManagedCProjectNature.MNG_NATURE_ID)) break block5;
                PIActivator.getDefault().logWarning(NLS.bind((String)Messages.ProjectInfoExporter_trying_to_export_unmanaged_project, (Object)project));
                return false;
            }
            if (!project.hasNature("org.eclipse.cdt.core.cnature")) break block6;
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                PIActivator.getDefault().logWarning(NLS.bind((String)Messages.ProjectInfoExporter_trying_to_export_cpp_nature_project, (Object)project));
                return false;
            }
            return true;
        }
        try {
            PIActivator.getDefault().logWarning(NLS.bind((String)Messages.ProjectInfoExporter_trying_to_export_no_c_nature_project, (Object)project));
        }
        catch (Exception e) {
            PIActivator.getDefault().logError(e.getMessage());
        }
        return false;
    }
}

