/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;

public class Refresh
extends AbstractCommand {
    public static final String PARAM_ACT_ID = "actid";

    public Refresh(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_ACT_ID, "Software Activation Code for product");
    }

    @Override
    public String getName() {
        return "refresh";
    }

    @Override
    public String getOneLineDesc() {
        return "Refresh license feature information.";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam(PARAM_ACT_ID) == null) {
            return "Software Activation Code is not set";
        }
        return null;
    }

    @Override
    public int execute() {
        CLLReason result;
        block5: {
            try {
                super.initLicenseLocation();
                super.setupProxy();
                if (this.isTestFNO()) {
                    if (this.getSettings().isDebugModeOn()) {
                        System.out.println("use test FNO");
                    }
                    this.getCll().setFNOUrlForTesting(true);
                }
                String actID = this.getSettings().getParam(PARAM_ACT_ID);
                result = this.getCll().refreshLicense(actID, false, "", 0L, 0L);
                if (result != null) break block5;
                return 0;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
        System.err.println(result);
        return 1;
    }
}

