/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.DiagsOverlapView;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsFigure;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.json.JSONException;
import org.json.JSONObject;

public class VDiagsOverlayFigure
extends VDiagsFigure {
    private static final Logger LOGGER = LogManager.getLogger(VDiagsOverlayFigure.class);
    private static final String FREQ_ID = "frequency";
    private static final String CONNECT_KEY = "connect";
    private static final String CONNECT_FILE_NAME = "connect";
    public static final String UI = "UI";
    public static final String PS = "ps";
    public static final int UI_TICK_UNIT = 2;
    public static final int PS_TICK_UNIT = 35;
    public static final int UI_LIMIT_GAP = 1;
    public static final int PS_LIMIT_GAP = 10;
    public static final double VREF_LIMIT_GAP = 0.01;
    public static final double VREF_TICK_UNIT = 0.05;
    public static final Integer NORMALIZED_CENTER_DELAY = 0;
    private static int freqValue;
    @Nullable
    private CustomLineChart lineChart;
    @Nullable
    private HBox hBoxCheckBoxes;
    @Nullable
    private TableView<DiagsOverlapView.EyeResult> eyeResultTable;
    private double lowerYBound;
    private double upperYBound;

    public VDiagsOverlayFigure(VTable vTable) {
        super(vTable);
    }

    public boolean drawOverlappedCharts() {
        ArrayList crtDiagsData = this.diagsData;
        CustomLineChart lineChartLoc = this.lineChart;
        if (crtDiagsData != null && lineChartLoc != null) {
            VDiagsOverlayFigure.setFreqValue();
            int count = -1;
            ArrayList<XYChart.Data<Number, Number>> centerDataList = new ArrayList<XYChart.Data<Number, Number>>();
            HashMap<CheckBox, ObservableList<XYChart.Series<Number, Number>>> byteLaneMap = new HashMap<CheckBox, ObservableList<XYChart.Series<Number, Number>>>();
            int byteLane = -1;
            CheckBox checkBox = null;
            ObservableList dataEyeResults = FXCollections.observableArrayList();
            DiagsOverlapView.EyeResult eyeResult = null;
            this.lowerYBound = 10.0;
            this.upperYBound = 0.0;
            for (DiagsEyeResultHandler.EyeTable table : crtDiagsData) {
                ObservableList byteSeriesList;
                XYChart.Series currentSeries = (XYChart.Series)lineChartLoc.getData().get(++count);
                String seriesName = String.format(Messages.DefaultDq, table.dq());
                currentSeries.setName(seriesName);
                HashMap delayMap = new HashMap();
                delayMap.put(UI, new ArrayList());
                delayMap.put(PS, new ArrayList());
                lineChartLoc.getDqMap().put(seriesName, delayMap);
                int bitLane = table.bitLane();
                if (byteLane != table.byteLane()) {
                    byteLane = table.byteLane();
                    checkBox = this.addByteCheckBox(byteLane);
                    byteLaneMap.put(checkBox, (ObservableList<XYChart.Series<Number, Number>>)FXCollections.observableArrayList());
                }
                eyeResult = new DiagsOverlapView.EyeResult(String.valueOf(byteLane), String.valueOf(bitLane), String.valueOf(table.goldenVref()), String.valueOf(table.tapDelay()), "", 0, "", "");
                dataEyeResults.add((Object)eyeResult);
                if (checkBox != null && (byteSeriesList = (ObservableList)byteLaneMap.get(checkBox)) != null) {
                    byteSeriesList.add((Object)currentSeries);
                }
                this.parseEye(table, centerDataList, (XYChart.Series<Number, Number>)currentSeries, eyeResult);
                double yCoordinate = ((Number)centerDataList.get(count).getYValue()).doubleValue();
                XYChart.Data centerPoint = new XYChart.Data((Object)NORMALIZED_CENTER_DELAY, (Object)yCoordinate);
                centerPoint.setNode((Node)new HoveredThresholdNode((XYChart.Data<Number, Number>)centerPoint, yCoordinate, true));
                currentSeries.getData().add((Object)centerPoint);
                eyeResult.setTableCellValues(String.valueOf(bitLane));
            }
            if (!centerDataList.isEmpty()) {
                lineChartLoc.setCenterPoints(centerDataList);
            }
            lineChartLoc.setByteMap(byteLaneMap);
            lineChartLoc.addLegendListener();
            lineChartLoc.extractOxBounds(UI);
            lineChartLoc.extractOxBounds(PS);
            lineChartLoc.setOxBounds(UI);
            lineChartLoc.setOyBounds(this.lowerYBound, this.upperYBound, 0.01);
            if (dataEyeResults != null) {
                this.populateTableView((ObservableList<DiagsOverlapView.EyeResult>)dataEyeResults);
                this.addByteLaneBoxListener(byteLaneMap, (ObservableList<DiagsOverlapView.EyeResult>)dataEyeResults);
            }
            return true;
        }
        return false;
    }

    public void populateTableView(final ObservableList<DiagsOverlapView.EyeResult> dataEyeResults) {
        Optional.ofNullable(this.eyeResultTable).ifPresent(table -> {
            table.setItems(dataEyeResults);
            table.setRowFactory(tableView -> new TableRow<DiagsOverlapView.EyeResult>(){

                protected void updateItem(DiagsOverlapView.EyeResult item, boolean empty) {
                    double minDeltaVrefValue = VDiagsOverlayFigure.findWorstEye((ObservableList<DiagsOverlapView.EyeResult>)dataEyeResults);
                    if (empty) {
                        this.setStyle("");
                    } else {
                        super.updateItem((Object)item, empty);
                        if (minDeltaVrefValue != Double.MAX_VALUE && item.getDeltaVrefAsDouble() - minDeltaVrefValue <= 1.0E-5) {
                            this.setStyle("-fx-background-color: #ffe6cc;");
                        } else {
                            this.setStyle("");
                        }
                    }
                }
            });
            table.refresh();
        });
    }

    public static double findWorstEye(ObservableList<DiagsOverlapView.EyeResult> dataEyeResults) {
        return dataEyeResults.stream().mapToDouble(eyeResult -> eyeResult.getDeltaVrefAsDouble()).min().orElse(Double.MAX_VALUE);
    }

    public void parseEye(DiagsEyeResultHandler.EyeTable table, List<XYChart.Data<Number, Number>> centerDataList, XYChart.Series<Number, Number> currentSeries,  @Nullable DiagsOverlapView.EyeResult eyeResult) {
        String seriesName;
        ArrayList yAxis = table.yAxis();
        ArrayList xAxis = table.xAxis();
        int[][] data = table.data();
        if (xAxis == null || yAxis == null || data == null) {
            LOGGER.severe(Messages.InvalidDataMessage);
            return;
        }
        int dataHeight = yAxis.size();
        int dataWidth = xAxis.size();
        double goldenVref = table.goldenVref();
        int tapDelay = table.tapDelay();
        ParsedEyeResults parsedEye = new ParsedEyeResults();
        parsedEye.parseEye(data, dataHeight, dataWidth, goldenVref, yAxis, xAxis, tapDelay, centerDataList);
        ArrayList<XYChart.Data<Number, Number>> leftMarginList = parsedEye.getLeftMarginList();
        ArrayList<XYChart.Data<Number, Number>> rightMarginList = parsedEye.getRightMarginList();
        currentSeries.getData().addAll(leftMarginList);
        currentSeries.getData().addAll(rightMarginList);
        this.updateYBounds(leftMarginList);
        String closestOyMargin = this.getClosestOyMargin(data, parsedEye.getVrefPos(), dataHeight, parsedEye.getTapDelayPos(), yAxis);
        String closestOxMargin = parsedEye.getClosestOXMargin();
        String deltaVrefString = VDiagsOverlayFigure.getClosestDeltaVref(closestOyMargin, goldenVref);
        String deltaDelayString = VDiagsOverlayFigure.getClosestDeltaDelay(parsedEye, closestOxMargin);
        String goldenVrefFormatted = VDiagsOverlayFigure.formatNumber(goldenVref);
        if (eyeResult != null) {
            eyeResult.addBitProperties(table.bitLane(), goldenVrefFormatted, tapDelay, closestOyMargin, closestOxMargin, deltaVrefString, deltaDelayString, parsedEye.getUnitMap());
        }
        if ((seriesName = currentSeries.getName()) != null) {
            this.addOxCoordinatesToMap(leftMarginList, rightMarginList, seriesName);
        }
    }

    public void addOxCoordinatesToMap(List<XYChart.Data<Number, Number>> leftMarginList, List<XYChart.Data<Number, Number>> rightMarginList, String seriesName) {
        int coordinate;
        ArrayList<Integer> delaysUi = new ArrayList<Integer>();
        ArrayList<Integer> delaysPs = new ArrayList<Integer>();
        for (XYChart.Data<Number, Number> leftMarginObject : leftMarginList) {
            coordinate = ((Number)leftMarginObject.getXValue()).intValue();
            delaysUi.add(coordinate);
            delaysPs.add(VDiagsOverlayFigure.convertUiToPSeconds(coordinate));
        }
        for (XYChart.Data<Number, Number> rightMarginObject : rightMarginList) {
            coordinate = ((Number)rightMarginObject.getXValue()).intValue();
            delaysUi.add(coordinate);
            delaysPs.add(VDiagsOverlayFigure.convertUiToPSeconds(coordinate));
        }
        delaysUi.add(NORMALIZED_CENTER_DELAY);
        delaysPs.add(NORMALIZED_CENTER_DELAY);
        if (this.lineChart != null) {
            CustomLineChart lineChartLoc = this.lineChart;
            lineChartLoc.addDelayValuesToMap(seriesName, delaysUi, UI);
            lineChartLoc.addDelayValuesToMap(seriesName, delaysPs, PS);
        }
    }

    public void updateYBounds(List<XYChart.Data<Number, Number>> leftMarginList) {
        if (!leftMarginList.isEmpty()) {
            double currentUpperYBound;
            double currentLowerYBound = ((Number)leftMarginList.get(0).getYValue()).doubleValue();
            if (this.lowerYBound > currentLowerYBound) {
                this.lowerYBound = currentLowerYBound;
            }
            if (this.upperYBound < (currentUpperYBound = ((Number)leftMarginList.get(leftMarginList.size() - 1).getYValue()).doubleValue())) {
                this.upperYBound = currentUpperYBound;
            }
        }
    }

    public static String addClosestOxMargin(int firstDataX, int lastDataX, int leftLimit, int rightLimit, int tapDelay, Map<String, List<String>> unitMap) {
        String closestOxMarginPs;
        String closestOxMarginUi;
        int rightMargin;
        int leftMargin = Math.abs(firstDataX);
        if (leftMargin <= (rightMargin = Math.abs(lastDataX))) {
            if (leftLimit != 0) {
                closestOxMarginUi = String.valueOf(firstDataX);
                closestOxMarginPs = String.valueOf(VDiagsOverlayFigure.convertUiToPSeconds(firstDataX));
            } else if (leftMargin == rightMargin && rightLimit != 0) {
                closestOxMarginUi = String.valueOf(lastDataX);
                closestOxMarginPs = String.valueOf(VDiagsOverlayFigure.convertUiToPSeconds(lastDataX));
            } else {
                closestOxMarginUi = String.valueOf("~" + firstDataX);
                closestOxMarginPs = String.valueOf("~" + VDiagsOverlayFigure.convertUiToPSeconds(firstDataX));
            }
        } else if (rightLimit != 0) {
            closestOxMarginUi = String.valueOf(lastDataX);
            closestOxMarginPs = String.valueOf(VDiagsOverlayFigure.convertUiToPSeconds(lastDataX));
        } else {
            closestOxMarginUi = String.valueOf("~" + lastDataX);
            closestOxMarginPs = String.valueOf("~" + VDiagsOverlayFigure.convertUiToPSeconds(lastDataX));
        }
        ArrayList<String> uiList = new ArrayList<String>();
        uiList.add(String.valueOf(tapDelay));
        uiList.add(closestOxMarginUi);
        ArrayList<String> psList = new ArrayList<String>();
        psList.add(String.valueOf(VDiagsOverlayFigure.convertUiToPSeconds(tapDelay)));
        psList.add(closestOxMarginPs);
        unitMap.put(UI, uiList);
        unitMap.put(PS, psList);
        return closestOxMarginUi;
    }

    public String getClosestOyMargin(int[][] data, int vrefPos, int dataHeight, int delayPos, List<Double> yAxis) {
        int upMarginCounts = 0;
        int downMarginCounts = 0;
        int k = vrefPos + 1;
        while (k < dataHeight) {
            if (data[k][delayPos] == 0) {
                ++downMarginCounts;
            } else if (downMarginCounts > 0) break;
            ++k;
        }
        k = vrefPos - 1;
        while (k >= 0) {
            if (data[k][delayPos] == 0) {
                ++upMarginCounts;
            } else if (upMarginCounts > 0) break;
            --k;
        }
        String closestOyValue = downMarginCounts <= upMarginCounts ? (data[dataHeight - 1][delayPos] != 0 ? String.valueOf(yAxis.get(vrefPos + downMarginCounts + 1)) : (downMarginCounts == upMarginCounts && data[0][delayPos] != 0 ? String.valueOf(yAxis.get(vrefPos - upMarginCounts - 1)) : String.valueOf("~" + yAxis.get(vrefPos + downMarginCounts + 1)))) : (data[0][delayPos] != 0 ? String.valueOf(yAxis.get(vrefPos - upMarginCounts - 1)) : String.valueOf("~" + yAxis.get(vrefPos - upMarginCounts - 1)));
        return closestOyValue;
    }

    public static String getClosestDeltaVref(String closestOyMargin, double vrefCenter) {
        String deltaVrefString = closestOyMargin.contains("~") ? String.valueOf("~" + VDiagsOverlayFigure.formatNumber(Math.abs(Double.parseDouble(closestOyMargin.substring(1)) - vrefCenter))) : String.valueOf(VDiagsOverlayFigure.formatNumber(Math.abs(Double.parseDouble(closestOyMargin) - vrefCenter)));
        return deltaVrefString;
    }

    public static String getClosestDeltaDelay(ParsedEyeResults parsedEye, String closestOxMargin) {
        List<String> uiList;
        String deltaDelayString;
        int deltaDelay;
        if (closestOxMargin.contains("~")) {
            deltaDelay = Math.abs(Integer.parseInt(closestOxMargin.substring(1)));
            deltaDelayString = String.valueOf("~" + deltaDelay);
        } else {
            deltaDelay = Math.abs(Integer.parseInt(closestOxMargin));
            deltaDelayString = String.valueOf(deltaDelay);
        }
        Map<String, List<String>> unitMapDelta = parsedEye.getUnitMap();
        if (unitMapDelta.containsKey(UI) && (uiList = unitMapDelta.get(UI)) != null) {
            uiList.add(String.valueOf(deltaDelay));
        }
        if (unitMapDelta.containsKey(PS) && (uiList = unitMapDelta.get(PS)) != null) {
            uiList.add(String.valueOf(VDiagsOverlayFigure.convertUiToPSeconds(deltaDelay)));
        }
        return deltaDelayString;
    }

    public CheckBox addByteCheckBox(int byteLane) {
        CheckBox checkBox = new CheckBox("Byte Lane " + byteLane);
        checkBox.setSelected(true);
        checkBox.setPrefWidth(125.0);
        checkBox.setPrefHeight(30.0);
        checkBox.setId("ByteLane" + byteLane);
        if (this.hBoxCheckBoxes != null) {
            this.hBoxCheckBoxes.getChildren().add((Object)checkBox);
        }
        return checkBox;
    }

    public void addByteLaneBoxListener(Map<CheckBox, ObservableList<XYChart.Series<Number, Number>>> byteLaneMap, ObservableList<DiagsOverlapView.EyeResult> dataEyeResults) {
        CustomLineChart lineChartLoc = this.lineChart;
        ObservableList eyeResultList = FXCollections.observableArrayList(dataEyeResults);
        for (Map.Entry<CheckBox, ObservableList<XYChart.Series<Number, Number>>> entry : byteLaneMap.entrySet()) {
            CheckBox checkBox = entry.getKey();
            checkBox.selectedProperty().addListener((observable, oldValue, newValue) -> {
                ObservableList seriesList = (ObservableList)entry.getValue();
                ArrayList<DiagsOverlapView.EyeResult> tempEyeResults = new ArrayList<DiagsOverlapView.EyeResult>();
                for (DiagsOverlapView.EyeResult eyeResult : dataEyeResults) {
                    if (!checkBox.getText().contains(eyeResult.getByteLane())) continue;
                    tempEyeResults.add(eyeResult);
                }
                if (newValue.booleanValue()) {
                    eyeResultList.addAll(tempEyeResults);
                    if (lineChartLoc != null) {
                        lineChartLoc.setListOfSeriesVisibility((ObservableList<XYChart.Series<Number, Number>>)seriesList, true, true);
                    }
                } else {
                    eyeResultList.removeAll(tempEyeResults);
                    if (lineChartLoc != null) {
                        lineChartLoc.setListOfSeriesVisibility((ObservableList<XYChart.Series<Number, Number>>)seriesList, false, true);
                    }
                }
                this.populateTableView((ObservableList<DiagsOverlapView.EyeResult>)eyeResultList);
            });
        }
    }

    public static int convertUiToPSeconds(int delayValue) {
        return (int)((double)delayValue * Math.pow(10.0, 6.0)) / (64 * freqValue);
    }

    public static void setFreqValue() {
        String connFilePath = String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + "connect" + ".json";
        try {
            String connContent = new String(Files.readAllBytes(Paths.get(connFilePath, new String[0])), StandardCharsets.UTF_8);
            JSONObject phyJsonObject = new JSONObject(connContent);
            freqValue = phyJsonObject.getJSONObject("connect").getInt(FREQ_ID);
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
        catch (JSONException e1) {
            LOGGER.severe(e1.getMessage());
        }
        catch (NumberFormatException e2) {
            LOGGER.severe(e2.getMessage());
        }
    }

    public void updateDiagsInfo(@Nullable CustomLineChart lineAreaChart, @Nullable HBox hBoxCheckBoxesParam, @Nullable TableView<DiagsOverlapView.EyeResult> eyeResultTableParam) {
        this.lineChart = lineAreaChart;
        this.eyeResultTable = eyeResultTableParam;
        this.hBoxCheckBoxes = hBoxCheckBoxesParam;
    }

    private static String formatNumber(double number) {
        DecimalFormat formatter = new DecimalFormat("#0.000000");
        return String.valueOf(formatter.format(number));
    }

    static class HoveredThresholdNode
    extends StackPane {
        Label label;
        Double yCoord;

        HoveredThresholdNode(XYChart.Data<Number, Number> item, double oyCenter, boolean isCenterPoint) {
            double size = isCenterPoint ? 5 : 4;
            this.setPrefSize(size, size);
            this.setOpacity(2000.0);
            int x = ((Number)item.getXValue()).intValue();
            double y = ((Number)item.getYValue()).doubleValue();
            this.yCoord = y;
            this.label = new Label();
            this.setLabelXCoord(((Number)item.getXValue()).intValue());
            this.label.getStyleClass().add((Object)"chart-node");
            this.label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            if (x < 0) {
                this.label.setTranslateX(50.0);
            } else {
                this.label.setTranslateX(-50.0);
            }
            if (y < oyCenter) {
                this.label.setTranslateY(-20.0);
            } else {
                this.label.setTranslateY(20.0);
            }
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    this.setOpacity(2000.0);
                    this.getChildren().setAll((Object[])new Node[]{label});
                    this.toFront();
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    this.getChildren().clear();
                }
            });
        }

        public void setLabelXCoord(Integer xUnit) {
            this.label.setText(String.format(Messages.CoordinatesLabel, xUnit, this.yCoord));
        }
    }

    static class ParsedEyeResults {
        ArrayList<XYChart.Data<Number, Number>> leftMarginList = new ArrayList();
        ArrayList<XYChart.Data<Number, Number>> rightMarginList = new ArrayList();
        Map<String, List<String>> unitMap = new HashMap<String, List<String>>();
        int vrefPos = -1;
        int delayPos = -1;
        String closestOxMargin = "";

        ParsedEyeResults() {
        }

        public void parseEye(int[][] data, int dataHeight, int dataWidth, double goldenVref, List<Double> yAxis, List<Integer> xAxis, int tapDelay, List<XYChart.Data<Number, Number>> centerDataList) {
            int prevLeftMargin = -1000;
            int prevRightMargin = 1000;
            int currentLeftMargin = 0;
            int currentRightMargin = 0;
            int centerCount = 0;
            this.vrefPos = -1;
            this.delayPos = -1;
            boolean centerReached = false;
            XYChart.Data leftMargin = new XYChart.Data();
            XYChart.Data rightMargin = new XYChart.Data();
            int i = 0;
            while (i < dataHeight) {
                int maxCount = 0;
                int counter = 0;
                int firstX = 0;
                int j = 0;
                while (j < dataWidth) {
                    if (data[i][j] == 0) {
                        if (firstX == 0) {
                            firstX = j;
                        }
                        ++counter;
                    } else if (data[i][j] == -1) {
                        if (yAxis.get(i) == goldenVref || centerCount == 1) {
                            this.vrefPos = i;
                            this.delayPos = j;
                            XYChart.Data centerData = new XYChart.Data((Object)xAxis.get(j), (Object)yAxis.get(i));
                            centerDataList.add((XYChart.Data<Number, Number>)centerData);
                        }
                        ++centerCount;
                        ++counter;
                    } else {
                        if (counter > maxCount) {
                            maxCount = counter;
                            leftMargin = new XYChart.Data((Object)(xAxis.get(firstX) - tapDelay), (Object)yAxis.get(i));
                            rightMargin = new XYChart.Data((Object)(xAxis.get(j - 1) - tapDelay), (Object)yAxis.get(i));
                        }
                        firstX = 0;
                        counter = 0;
                    }
                    ++j;
                }
                if (maxCount > 1 || maxCount == 0 && firstX != 0) {
                    boolean smallerMargin;
                    if (counter > maxCount || maxCount == 0) {
                        leftMargin = new XYChart.Data((Object)(xAxis.get(firstX) - tapDelay), (Object)yAxis.get(i));
                        rightMargin = new XYChart.Data((Object)(xAxis.get(dataWidth - 1) - tapDelay), (Object)yAxis.get(i));
                    }
                    currentLeftMargin = ((Number)leftMargin.getXValue()).intValue();
                    currentRightMargin = ((Number)rightMargin.getXValue()).intValue();
                    boolean smallerLeftMargin = currentLeftMargin <= prevLeftMargin && currentRightMargin >= prevLeftMargin + 1;
                    boolean biggerRightMargin = currentRightMargin >= prevRightMargin && currentLeftMargin <= prevRightMargin - 1;
                    boolean bl = smallerMargin = currentLeftMargin > prevLeftMargin && currentRightMargin < prevRightMargin;
                    if (smallerLeftMargin || biggerRightMargin || smallerMargin) {
                        leftMargin.setNode((Node)new HoveredThresholdNode((XYChart.Data<Number, Number>)leftMargin, goldenVref, false));
                        this.leftMarginList.add((XYChart.Data<Number, Number>)leftMargin);
                        rightMargin.setNode((Node)new HoveredThresholdNode((XYChart.Data<Number, Number>)rightMargin, goldenVref, false));
                        this.rightMarginList.add((XYChart.Data<Number, Number>)rightMargin);
                        if (i == this.vrefPos) {
                            this.closestOxMargin = VDiagsOverlayFigure.addClosestOxMargin(currentLeftMargin, currentRightMargin, data[i][0], data[i][dataWidth - 1], tapDelay, this.unitMap);
                            centerReached = true;
                        }
                    } else {
                        if (centerReached) break;
                        this.leftMarginList.clear();
                        this.leftMarginList.add((XYChart.Data<Number, Number>)leftMargin);
                        this.rightMarginList.clear();
                        this.rightMarginList.add((XYChart.Data<Number, Number>)rightMargin);
                    }
                    prevLeftMargin = currentLeftMargin;
                    prevRightMargin = currentRightMargin;
                } else if (centerReached) break;
                ++i;
            }
            Collections.reverse(this.rightMarginList);
        }

        public int getVrefPos() {
            return this.vrefPos;
        }

        public int getTapDelayPos() {
            return this.delayPos;
        }

        public ArrayList<XYChart.Data<Number, Number>> getRightMarginList() {
            return this.rightMarginList;
        }

        public ArrayList<XYChart.Data<Number, Number>> getLeftMarginList() {
            return this.leftMarginList;
        }

        public String getClosestOXMargin() {
            return this.closestOxMargin;
        }

        public Map<String, List<String>> getUnitMap() {
            return this.unitMap;
        }
    }
}

