/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.nxp.s32ds.cle.cdt.sdk.condition.Condition;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionGroup;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionGroupImpl
implements ConditionGroup {
    private final Map<String, Condition> conditions;
    private String sdkId;
    private String toolChainId;

    private ConditionGroupImpl() {
        this.conditions = Collections.emptyMap();
    }

    public ConditionGroupImpl(Element conditionsElement, String sdkId, String toolChainId) {
        this.conditions = new HashMap<String, Condition>();
        this.sdkId = sdkId;
        this.toolChainId = toolChainId;
        this.initialize(conditionsElement);
    }

    public Map<String, Condition> getConditions() {
        return Collections.unmodifiableMap(this.conditions);
    }

    public Condition getCondition(String conditionId) {
        return this.conditions.get(conditionId);
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public void convertToXml(Document document, Element holderElement) {
        Element conditionsElement = document.createElement("conditions");
        this.conditions.values().forEach(condition -> condition.convertToXml(document, conditionsElement));
        holderElement.appendChild(conditionsElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
        result = 31 * result + (this.toolChainId == null ? 0 : this.toolChainId.hashCode());
        result = 31 * result + (this.conditions == null ? 0 : this.conditions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionGroup)) {
            return false;
        }
        ConditionGroup other = (ConditionGroup)obj;
        if (this.sdkId == null ? other.getSdkId() != null : !this.sdkId.equals(other.getSdkId())) {
            return false;
        }
        if (this.toolChainId == null ? other.getToolChainId() != null : !this.toolChainId.equals(other.getToolChainId())) {
            return false;
        }
        return !(this.conditions == null ? other.getConditions() != null : !this.conditions.equals(other.getConditions()));
    }

    public boolean isEmpty() {
        return this.conditions == null || this.conditions.isEmpty();
    }

    public static ConditionGroupImpl emptyGroup() {
        return new ConditionGroupImpl();
    }

    private void initialize(Element conditionsElement) {
        NodeList conditionElements = conditionsElement.getElementsByTagName("condition");
        int i = 0;
        while (i < conditionElements.getLength()) {
            Node conditionNode = conditionElements.item(i);
            if (conditionsElement.equals(conditionNode.getParentNode())) {
                ConditionImpl condition = new ConditionImpl((Element)conditionNode);
                this.conditions.put(condition.getId(), condition);
            }
            ++i;
        }
    }
}

