/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.OptionUpdateValueChangeListener;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.collectors.IncludePathsCollector;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.SettingsChangeEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public class SdkProjectIncludePathsUpdateValueChangeListener
extends OptionUpdateValueChangeListener {
    public void settingsChanged(SettingsChangeEvent settingsChangeEvent) {
        IOption option = settingsChangeEvent.getOption();
        try {
            if (4 != option.getValueType()) {
                return;
            }
            IConfiguration configuration = this.getConfiguration(option);
            if (configuration == null) {
                return;
            }
            IProject project = configuration.getOwner().getProject();
            List<SdkDescriptor> attachedSdks = SdkAttachDataHolder.verboseProjectAttachData(project, new HashMap<String, String>(), new HashMap<String, String>());
            if (attachedSdks == null || attachedSdks.isEmpty()) {
                return;
            }
            SdkProjectIncludePathsUpdateValueChangeListener.reorderIncludePaths(option, project, configuration, attachedSdks);
        }
        catch (BuildException be) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to re-order {0} option's values due to internal error.", (Object)option.getName()), be);
        }
    }

    private static void reorderIncludePaths(IOption option, IProject project, IConfiguration config, List<SdkDescriptor> attachedSdks) throws BuildException {
        LinkedHashSet<String> sdksIncludePaths = new LinkedHashSet<String>();
        List<String> initialIncludePaths = Arrays.asList(option.getIncludePaths());
        ArrayList<String> reorderedIncludePaths = new ArrayList<String>(initialIncludePaths);
        for (SdkDescriptor attachedSdk : attachedSdks) {
            Collection<String> sdkIncludePaths = SdkProjectIncludePathsUpdateValueChangeListener.getInclugePathsStrings(attachedSdk, project, config);
            if (sdkIncludePaths.isEmpty()) continue;
            Iterator it = reorderedIncludePaths.iterator();
            while (it.hasNext()) {
                String optionValue = (String)it.next();
                if (optionValue == null || !sdkIncludePaths.contains(optionValue)) continue;
                sdksIncludePaths.add(optionValue);
                it.remove();
            }
        }
        reorderedIncludePaths.addAll(sdksIncludePaths);
        if (!initialIncludePaths.equals(reorderedIncludePaths)) {
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)option.getOptionHolder(), (IOption)option, (String[])reorderedIncludePaths.toArray(new String[0]));
        }
    }

    private static Collection<String> getInclugePathsStrings(SdkDescriptor sdkDescriptor, IProject project, IConfiguration configuration) {
        HashSet<String> result = new HashSet<String>();
        ProjectCompatibleSdksFilter filter = new ProjectCompatibleSdksFilter(project);
        result.addAll(new IncludePathsCollector("c", Collections.emptyMap()).collect(sdkDescriptor, (SdkFilter)filter, configuration));
        result.addAll(new IncludePathsCollector("cpp", Collections.emptyMap()).collect(sdkDescriptor, (SdkFilter)filter, configuration));
        result.addAll(new IncludePathsCollector("asm", Collections.emptyMap()).collect(sdkDescriptor, (SdkFilter)filter, configuration));
        return result;
    }
}

