/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderAction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class ProjectResourceFolderRemoveAction
extends ProjectResourceFolderAction {
    public ProjectResourceFolderRemoveAction(Element element) {
        super(element);
        this.isBackupResource = Boolean.parseBoolean(element.getAttribute("backup"));
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        if (!project.isAccessible()) {
            return new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceRemoveAction_error_project_not_accessible, (Object)this.pathsToString(), (Object)project));
        }
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        if (this.isBackupResource) {
            result.addAll(this.backupResource(project));
        }
        ProjectSettingsUpdater sourceEntriesUpdater = ProjectSettingsUpdaters.getSourceEntriesUpdater();
        for (IResource resource : this.getResources(project)) {
            IFolder folder = (IFolder)resource;
            try {
                folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
                sourceEntriesUpdater.update(configuration, null, folder.getFullPath().toString(), UpdateOperation.REMOVE);
            }
            catch (CoreException e) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceRemoveAction_error_execute_exception, (Object)folder.getProjectRelativePath().toOSString()), (Throwable)e));
            }
        }
        return result;
    }

    @Override
    protected String getElementName() {
        return "removeProjectFolder";
    }
}

