/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SdkArchiveValidator
implements IValidator<String> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus validate(String archiveFileName) {
        if (Objects.toString(archiveFileName, "").isEmpty()) {
            return ValidationStatus.error((String)Messages.SdkArchiveValidator_error_file_name_empty);
        }
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (ZipFile zipFile = new ZipFile(archiveFileName);){
                ByteArrayInputStream bais;
                InputStream zfis;
                block30: {
                    ZipEntry sourceXmlEntry = zipFile.getEntry("sources.xml");
                    if (sourceXmlEntry == null) {
                        return ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_descriptor_missed, (Object)"sources.xml", (Object)archiveFileName));
                    }
                    if (sourceXmlEntry.getSize() == 0L) {
                        return ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_descriptor_structure, (Object)"sources.xml", (Object)archiveFileName));
                    }
                    Throwable throwable2 = null;
                    Object var7_13 = null;
                    try {
                        IStatus iStatus;
                        zfis = zipFile.getInputStream(sourceXmlEntry);
                        try {
                            block31: {
                                bais = new ByteArrayInputStream(SdkManagementUtils.getSdksManifestXml(zfis).getBytes(StandardCharsets.UTF_8));
                                try {
                                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                                    documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                                    documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                                    documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                                    DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                                    Element root = parser.parse(bais).getDocumentElement();
                                    if ("sdks".equals(root.getNodeName())) break block30;
                                    iStatus = ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_descriptor_invalid_root_tag, (Object)"sources.xml", (Object)archiveFileName));
                                    if (bais == null) break block31;
                                }
                                catch (Throwable throwable3) {
                                    if (bais == null) throw throwable3;
                                    bais.close();
                                    throw throwable3;
                                }
                                bais.close();
                            }
                            if (zfis == null) return iStatus;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            if (zfis == null) throw throwable2;
                            zfis.close();
                            throw throwable2;
                        }
                        zfis.close();
                        return iStatus;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                            throw throwable2;
                        }
                        if (throwable2 == throwable5) throw throwable2;
                        throwable2.addSuppressed(throwable5);
                        throw throwable2;
                    }
                }
                if (bais != null) {
                    bais.close();
                }
                if (zfis == null) return Status.OK_STATUS;
                zfis.close();
                return Status.OK_STATUS;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfe) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_file_not_found, (Object)archiveFileName), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_file_processing, (Object)archiveFileName), (Throwable)ioe);
        }
        catch (ParserConfigurationException | SAXException e) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkArchiveValidator_error_descriptor_structure, (Object)"sources.xml", (Object)archiveFileName), (Throwable)e);
        }
    }
}

