/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.resource.collectors;

import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourcesHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.collectors.AbstractSdkResourcesCollector;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.runtime.Path;

public class LibrariesCollector
extends AbstractSdkResourcesCollector {
    private String libraryPrefix;
    private String librarySuffix;

    public LibrariesCollector(String langId, Map<String, String> params) {
        super(langId, params);
        this.initLibraryPrefixAndSuffix(params);
    }

    public Collection<String> collect(SdkDescriptor sdkDescriptor, SdkFilter filter, IConfiguration configuration) {
        return this.prepareLibrariesPaths(ResourcesHandler.getBinaryFilesPaths(sdkDescriptor, filter, configuration, ""));
    }

    private Collection<String> prepareLibrariesPaths(Map<String, Boolean> libPaths) {
        ArrayList<String> resultLibPaths = new ArrayList<String>();
        for (Map.Entry<String, Boolean> e : libPaths.entrySet()) {
            String libPath = e.getKey();
            boolean hasPrefix = e.getValue();
            String resultLibPath = new Path(libPath).lastSegment();
            if (resultLibPath.startsWith("\"")) {
                resultLibPath = resultLibPath.substring(1);
            }
            if (resultLibPath.endsWith("\"")) {
                resultLibPath = resultLibPath.substring(0, resultLibPath.length() - 1);
            }
            if (hasPrefix) {
                resultLibPath = String.valueOf(this.libraryPrefix) + resultLibPath + this.librarySuffix;
            }
            resultLibPaths.add(resultLibPath);
        }
        return resultLibPaths;
    }

    private void initLibraryPrefixAndSuffix(Map<String, String> params) {
        String prefix = params.get("libraryPrefix");
        this.libraryPrefix = prefix != null ? prefix.trim() : "";
        String suffix = params.get("librarySuffix");
        this.librarySuffix = suffix != null ? suffix.trim() : "";
    }

    @Override
    protected Collection<String> collectCommonResources(SdkDescriptor sdkDescriptor, SdkFilter filter, IConfiguration configuration) {
        return Collections.emptySet();
    }
}

