/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.AbstractSdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsImplementation;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.filtering.SdkFilteringUtils;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public class ProjectCompatibleSdksFilter
extends AbstractSdkSmartFilter {
    private IProject project;

    public ProjectCompatibleSdksFilter(IProject project) {
        this.project = project;
    }

    public boolean accept(SdkDescriptor sdk) {
        ProjectSdkDescriptor projectLocalSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)sdk.getId());
        if (projectLocalSdk != null) {
            return this.project != null && this.project.getName().equals(projectLocalSdk.getProjectName());
        }
        return true;
    }

    @Override
    public FilterOptions options() {
        return ProjectCompatibleSdksFilter.options(this.project);
    }

    public static FilterOptions options(IProject project) {
        IToolChain[] toolChains = (IToolChain[])ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().map(configuration -> configuration.getToolChain().getSuperClass()).filter(Objects::nonNull).collect(Collectors.toList()).toArray(IToolChain[]::new);
        FilterOptions options = ProjectCompatibleSdksFilter.createFilterOptions(toolChains, project);
        if (options == null) {
            options = ProjectCompatibleSdksFilter.createCompatiableFilterOptions(toolChains, project);
        }
        return options;
    }

    private static FilterOptions createCompatiableFilterOptions(IToolChain[] toolChains, IProject project) {
        ProjectSettings ps = new ProjectSettings(project, "com.freescale.s32ds.cross.wizard");
        String processorId = ps.load("processor");
        String coreTypeId = ps.load("coreType");
        if (processorId.isEmpty() || coreTypeId.isEmpty()) {
            return null;
        }
        String coreKindId = null;
        if (coreTypeId.toLowerCase().startsWith(processorId.toLowerCase())) {
            coreKindId = coreTypeId.substring(processorId.length() + 1);
        }
        if (coreKindId == null) {
            coreKindId = SdkFilteringUtils.unifyCoreKind(coreTypeId);
        }
        processorId = SdkFilteringUtils.unifyProcessor(processorId);
        return new FilterOptionsImplementation(ProjectCompatibleSdksFilter.getLangs(ps.load("language")), Arrays.asList(toolChains), String.format("%s:%s", processorId, coreKindId), "");
    }

    private static FilterOptions createFilterOptions(IToolChain[] toolChains, IProject project) {
        ProjectContextSettings projectContext = new ProjectContextSettings(project);
        String deviceId = projectContext.getDevice2Context();
        String deviceCoreId = projectContext.getDeviceCore2Context();
        String coreId = projectContext.getCore2Context();
        String revisionId = projectContext.getDeviceRevision2Context();
        String familyId = projectContext.getFamily2Context();
        String langId = projectContext.getLang2Context();
        if (!(deviceId.isEmpty() && deviceCoreId.isEmpty() && coreId.isEmpty() && langId.isEmpty())) {
            Map<String, Set<String>> projectHardwareOptions = FilterOptionsUtils.createHardwareParams(deviceId, deviceCoreId, coreId, revisionId);
            HashMap<String, Set<String>> projectHardwareSettings = new HashMap<String, Set<String>>();
            if (projectContext.isLibrary() && deviceId.isEmpty() && deviceCoreId.isEmpty() && !familyId.isEmpty() && !coreId.isEmpty()) {
                List devicesByFamily = FamilyDescriptors.getDeviceDescriptors((String)familyId);
                for (DeviceDescriptor dd : devicesByFamily) {
                    FilterOptionsUtils.collectHardwareParams(DeviceDescriptors.getDeviceCoreDescriptors((String)dd.getId(), (String)coreId), revisionId, projectHardwareSettings);
                }
            }
            if (projectHardwareSettings.isEmpty()) {
                projectHardwareSettings.putAll(projectHardwareOptions);
            }
            return new FilterOptionsImplementation(ProjectCompatibleSdksFilter.getLangs(langId), Arrays.asList(toolChains), projectHardwareSettings, projectContext.getPlatform2Context(), Platform.getOS());
        }
        return null;
    }

    private static LangSdkKind getLangs(String langId) {
        return langId.equalsIgnoreCase(LangSdkKind.C.getLang()) ? LangSdkKind.C : LangSdkKind.CPP;
    }

    public static ProjectCompatibleSdksFilter getNoOptionsFilter(IProject project) {
        return new ProjectCompatibleSdksFilter(project){

            @Override
            public boolean accept(SdkDescriptor sdk) {
                return true;
            }

            @Override
            public FilterOptions options() {
                return null;
            }
        };
    }
}

