/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.checkers.files;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.ConflictingSdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.MissingSdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.SdkProjectFilesCheckStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.SdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public abstract class AbstractSdkProjectFilesChecker
implements SdkProjectFilesChecker {
    private SdkDescriptor sdk;
    private IPath sdkBasePath;
    private IProject project;

    protected AbstractSdkProjectFilesChecker(SdkDescriptor sdk, IProject project) {
        this.sdk = Objects.requireNonNull(sdk, "SDK must not be null");
        this.sdkBasePath = Objects.requireNonNull(EnvironmentSdkCore.getResolvedSdkPath((String)sdk.getId()));
        this.project = Objects.requireNonNull(project, "Project must not be null");
    }

    public static SdkProjectFilesChecker getMissingProjectFilesChecker(SdkDescriptor sdk, IProject project) {
        return new MissingSdkProjectFilesChecker(sdk, project);
    }

    public static SdkProjectFilesChecker getConflictingProjectFilesChecker(SdkDescriptor sdk, IProject project) {
        return new ConflictingSdkProjectFilesChecker(sdk, project);
    }

    public static Map<String, Set<ResourceSdkDescriptor>> getConflictingFiles(SdkDescriptor sdkDescriptor, IProject project) {
        IStatus checkFilesStatus = AbstractSdkProjectFilesChecker.getConflictingProjectFilesChecker(sdkDescriptor, project).checkFiles();
        return !checkFilesStatus.isOK() ? ((SdkProjectFilesCheckStatus)checkFilesStatus).getResultFiles() : Collections.emptyMap();
    }

    @Override
    public IStatus checkFiles() {
        Map<String, Set<ResourceSdkDescriptor>> resultFiles = this.findFiles(this.collectSDKFiles());
        return resultFiles.isEmpty() ? Status.OK_STATUS : new SdkProjectFilesCheckStatus(4, resultFiles, "");
    }

    protected abstract boolean checkFile(IFile var1);

    protected boolean checkPathAndType(ResourceSdkDescriptor resource, ResourceSdkGroup type) {
        return true;
    }

    private Map<String, Map<ResourceSdkGroup, List<ResourceSdkDescriptor>>> collectSDKFiles() {
        String toolChainId = ProjectConfigurationUtils.getDefaultToolChainId((IProject)this.project);
        if (toolChainId == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Map<ResourceSdkGroup, List<ResourceSdkDescriptor>>> sdkFiles = new LinkedHashMap<String, Map<ResourceSdkGroup, List<ResourceSdkDescriptor>>>();
        sdkFiles.put(this.sdk.getId(), AbstractSdkProjectFilesChecker.getSdkResourcesPaths(this.sdk, toolChainId));
        ProjectCompatibleSdksFilter filter = new ProjectCompatibleSdksFilter(this.project);
        SdkModulesHelper.getRefModulesSdksDescriptors(this.sdk.getId(), (SdkFilter)filter).stream().forEach(refSdk -> {
            Map<ResourceSdkGroup, List<ResourceSdkDescriptor>> map2 = sdkFiles.put(refSdk.getId(), AbstractSdkProjectFilesChecker.getSdkResourcesPaths(refSdk, toolChainId));
        });
        return sdkFiles;
    }

    private static Map<ResourceSdkGroup, List<ResourceSdkDescriptor>> getSdkResourcesPaths(SdkDescriptor refSdk, String toolchainId) {
        Map resources = ResourceSdkDescriptors.getResourceSdkDescriptors((String)refSdk.getId(), (String)toolchainId, (boolean)true);
        LinkedHashMap<ResourceSdkGroup, List<ResourceSdkDescriptor>> sdkFiles = new LinkedHashMap<ResourceSdkGroup, List<ResourceSdkDescriptor>>();
        sdkFiles.put(ResourceSdkGroup.SOURCE_RESOURCES, (List)resources.get(ResourceSdkGroup.SOURCE_RESOURCES));
        sdkFiles.put(ResourceSdkGroup.HEADER_RESOURCES, (List)resources.get(ResourceSdkGroup.HEADER_RESOURCES));
        sdkFiles.put(ResourceSdkGroup.BINARY_RESOURCES, (List)resources.get(ResourceSdkGroup.BINARY_RESOURCES));
        sdkFiles.put(ResourceSdkGroup.LINKER_RESOURCES, (List)resources.get(ResourceSdkGroup.LINKER_RESOURCES));
        sdkFiles.put(ResourceSdkGroup.UNSPECIFIED_RESOURCES, (List)resources.get(ResourceSdkGroup.UNSPECIFIED_RESOURCES));
        return sdkFiles;
    }

    private Map<String, Set<ResourceSdkDescriptor>> findFiles(Map<String, Map<ResourceSdkGroup, List<ResourceSdkDescriptor>>> pathMap) {
        LinkedHashMap<String, Set<ResourceSdkDescriptor>> foundFiles = new LinkedHashMap<String, Set<ResourceSdkDescriptor>>();
        for (Map.Entry<String, Map<ResourceSdkGroup, List<ResourceSdkDescriptor>>> pathsBySdkId : pathMap.entrySet()) {
            String checkSdkId = pathsBySdkId.getKey();
            Map<ResourceSdkGroup, List<ResourceSdkDescriptor>> pathsByTypeMap = pathsBySdkId.getValue();
            for (Map.Entry<ResourceSdkGroup, List<ResourceSdkDescriptor>> pathsByType : pathsByTypeMap.entrySet()) {
                ResourceSdkGroup fileType = pathsByType.getKey();
                List<ResourceSdkDescriptor> resource = pathsByType.getValue();
                if (resource == null) continue;
                resource.stream().filter(path -> this.performCheck((ResourceSdkDescriptor)path, checkSdkId, fileType)).forEach(path -> {
                    boolean bl = foundFiles.computeIfAbsent(checkSdkId, s -> new LinkedHashSet()).add(path);
                });
            }
        }
        return foundFiles;
    }

    private boolean performCheck(ResourceSdkDescriptor resource, String checkSdkId, ResourceSdkGroup fileType) {
        IPath path = Path.fromOSString((String)resource.getPath());
        if (!path.toFile().isDirectory() && this.checkPathAndType(resource, fileType)) {
            if (this.sdkBasePath.isPrefixOf(path)) {
                if (!ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)this.sdk.getId()).isEmpty()) {
                    return this.checkModuleSdksFiles(resource, checkSdkId);
                }
                IFile file = SdkProjectResourcesUtils.getTargetFile((ResourceSdkDescriptor)resource, (SdkDescriptor)this.sdk, (IProject)this.project);
                if (file == null || this.checkFile(file)) {
                    return true;
                }
            } else {
                return this.checkModuleSdksFiles(resource, checkSdkId);
            }
        }
        return false;
    }

    private boolean checkModuleSdksFiles(ResourceSdkDescriptor resource, String checkSdkId) {
        IFile file;
        IPath refSdkBasePath;
        IPath path = Path.fromOSString((String)resource.getPath());
        SdkDescriptor refSdk = SdkDescriptors.getSdkDescriptor((String)checkSdkId);
        return refSdk != null && (refSdkBasePath = EnvironmentSdkCore.getResolvedSdkPath((String)refSdk.getId())) != null && refSdkBasePath.isPrefixOf(path) && ((file = (IFile)SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)refSdk, (IProject)this.project, (SdkDescriptor)this.sdk)) == null || this.checkFile(file));
    }
}

