/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ScalarInfoControl
extends ScalarControl {
    @Nullable
    private Control controlWhichChanges;

    public ScalarInfoControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        if (this.getChild().isOptionSet("UI_SETTING_LINK")) {
            Composite linkComposite = new Composite(composite, 0);
            GridLayoutComponents linkCompositeLayout = new GridLayoutComponents();
            linkCompositeLayout.marginHeight = 0;
            linkCompositeLayout.marginWidth = 0;
            linkComposite.setLayout((Layout)linkCompositeLayout);
            GridDataComponents linktCompositeLayoutData = new GridDataComponents(4, 0x1000000, true, false);
            Link link = new Link(linkComposite, 0);
            link.setLayoutData((Object)linktCompositeLayoutData);
            this.createErrorDecoration((Control)link, 16512);
            link.setBackground(composite.getBackground());
            link.addListener(13, new Listener(){

                public void handleEvent(@NonNull Event event) {
                    Object optionValue = ScalarInfoControl.this.getChild().getOptionValue("UI_SETTING_LINK");
                    if (optionValue instanceof IChild) {
                        ScalarInfoControl.this.handleLinkToSetting((IChild)optionValue, ScalarInfoControl.class);
                    }
                }
            });
            this.mainControlInternal = link;
            this.controlWhichChanges = link;
            ScalarInfoControl.addScrollListener((Control)link, composite);
            return linkComposite;
        }
        if (this.getControlOptions().isLineBreak()) {
            Composite lineBreakComposite = new Composite(composite, 0);
            String valueString = this.getChild().getValue().toString();
            if (valueString.isEmpty()) {
                lineBreakComposite.setLayout((Layout)new GridLayout(1, false));
                Label line = new Label(lineBreakComposite, 258);
                line.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.mainControlInternal = line;
            } else {
                lineBreakComposite.setLayout((Layout)new GridLayout(3, false));
                Label lineLeft = new Label(lineBreakComposite, 258);
                lineLeft.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                Label label = new Label(lineBreakComposite, 0);
                this.controlWhichChanges = label;
                Label lineRight = new Label(lineBreakComposite, 258);
                lineRight.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.mainControlInternal = label;
            }
            return lineBreakComposite;
        }
        Composite textComposite = new Composite(composite, 0);
        GridLayoutComponents textCompositeLayout = new GridLayoutComponents();
        textCompositeLayout.marginHeight = 0;
        textCompositeLayout.marginWidth = 0;
        textComposite.setLayout((Layout)textCompositeLayout);
        GridDataComponents textCompositeLayoutData = new GridDataComponents(4, 0x1000000, true, false);
        Text text = new Text(textComposite, 72);
        text.setLayoutData((Object)textCompositeLayoutData);
        this.createErrorDecoration((Control)text, 16512);
        this.controlWhichChanges = text;
        this.mainControlInternal = text;
        ScalarInfoControl.addScrollListener((Control)text, composite);
        return textComposite;
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl,  @NonNull IChildControl.UpdateType updateType) {
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            String valueString = this.child.getValue().toString();
            Control controlWhichChangesLoc = this.controlWhichChanges;
            if (controlWhichChangesLoc instanceof Text) {
                ((Text)controlWhichChangesLoc).setText(ScalarConfig.replaceMarksWithMeanings((String)valueString));
            } else if (controlWhichChangesLoc instanceof Link) {
                boolean linkAvailable = this.getChild().isOptionAvailable("UI_SETTING_LINK");
                Link link = (Link)controlWhichChangesLoc;
                link.setText(UtilsText.createHyperLinkString((String)valueString, null));
                link.setEnabled(linkAvailable && this.getChild().isEnabled());
            } else if (controlWhichChangesLoc instanceof Label) {
                ((Label)controlWhichChangesLoc).setText(valueString);
            }
        }
        if (this.mainControlInternal != null) {
            this.updateErrorDecoration(this.mainControlInternal);
        }
        this.updateErrorDecoration(contentControl);
    }

    @Override
    protected int getStatusLevel() {
        int currentChildLevel = super.getStatusLevel();
        if (!this.child.isOptionSet("UI_SETTING_LINK") || !this.child.isOptionAvailable("UI_SETTING_LINK")) {
            return currentChildLevel;
        }
        Object optionValue = this.child.getOptionValue("UI_SETTING_LINK");
        if (!(optionValue instanceof IChild)) {
            return currentChildLevel;
        }
        IChild linkedChild = (IChild)optionValue;
        int linkedChildLevel = -1;
        if (linkedChild.getError() != null) {
            linkedChildLevel = 2;
        } else if (linkedChild.getWarning() != null) {
            linkedChildLevel = 1;
        } else if (linkedChild.getInfo() != null) {
            linkedChildLevel = 0;
        }
        return Math.max(currentChildLevel, linkedChildLevel);
    }

    @Override
    protected String getDecoratorStatus(int statusLevel) {
        String currentChildStatus = super.getDecoratorStatus(statusLevel);
        if (!this.child.isOptionSet("UI_SETTING_LINK") || !this.child.isOptionAvailable("UI_SETTING_LINK")) {
            return currentChildStatus;
        }
        Object optionValue = this.child.getOptionValue("UI_SETTING_LINK");
        if (!(optionValue instanceof IChild)) {
            return currentChildStatus;
        }
        IChild linkedChild = (IChild)optionValue;
        String linkedChildStatus = null;
        if (statusLevel >= 2) {
            linkedChildStatus = linkedChild.getError();
        } else if (statusLevel == 1) {
            linkedChildStatus = linkedChild.getWarning();
        } else if (statusLevel == 0) {
            linkedChildStatus = linkedChild.getInfo();
        }
        if (linkedChildStatus == null) {
            return currentChildStatus;
        }
        if (currentChildStatus == null) {
            return linkedChildStatus;
        }
        return String.valueOf(currentChildStatus) + "\n" + linkedChildStatus;
    }
}

