/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialog;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialogProperties;
import com.nxp.swtools.periphs.gui.view.APeriphsViewBase;
import com.nxp.swtools.periphs.gui.view.AddComponentDialog;
import com.nxp.swtools.periphs.gui.view.ComponentMenuCreator;
import com.nxp.swtools.periphs.gui.view.ComponentsView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.provider.PeripheralInitResolveHandler;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.text.TextBoxHelper;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ProblemUtils;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemListenerAdapter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;

public class PeripheralsView
extends APeriphsViewBase {
    @NonNull
    private static final String FILTER_USED_OR_REQUESTED_PERIPHERALS = "filterUsedOrRequestedPeripherals";
    @NonNull
    private static final String TOOL_ITEM_ACTION = "Action";
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.peripheralsView";
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(PeripheralsView.class);
    @Nullable
    Composite mainComposite;
    @Nullable
    Composite twComposite;
    @Nullable
    CheckboxTableViewer tw;
    private static final int COLUMN_MIN_WIDTH = 120;
    private static final int PERIPHERAL_COL_WEIGHT = 20;
    private static final int USED_IN_COL_WEIGHT = 80;
    private static final int PERIPHERAL_COL_IDX = 0;
    public static final int USED_IN_COL_IDX = 1;
    @NonNull
    String filterString = "";
    @Nullable
    private Text filterBox;
    boolean filterShowUsedOrRequestedPeripherals = false;
    @Nullable
    private ToolItem usedOrRequestedPeripheralToolItem;
    @NonNull
    private ValidationProblemListenerAdapter validationsListener = new ValidationProblemListenerAdapter(){

        public void validationProblemsChanged(Collection<@NonNull IValidationProblem> problems) {
            CheckboxTableViewer viewer = PeripheralsView.this.tw;
            if (viewer != null && !viewer.getTable().isDisposed()) {
                viewer.refresh();
            }
        }
    };

    public void createPartControl(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        this.mainComposite = composite;
        this.createFilterPart(composite);
        this.createTableViewer(composite);
        this.createContextMenu();
    }

    private void createTableViewer(@NonNull Composite parent) {
        this.twComposite = new Composite(parent, 0);
        this.twComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(new Table(Objects.requireNonNull(this.twComposite), 66336));
        Table table = tableViewer.getTable();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)table, "periphsPeriphsTable");
        this.tw = tableViewer;
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)tableViewer);
        this.setupTableProperties(table);
        this.addMouseDoubleClickListener(table);
        this.setupTableViewer();
        ValidationEngineFactory.addListener((IValidationProblemListener)this.validationsListener);
    }

    void createContextMenu() {
        ComponentMenuCreator.IComponentSelectionProvider selectionProvider = new ComponentMenuCreator.IComponentSelectionProvider(){

            @Override
            public Collection<? extends @NonNull IChild> getSelection() {
                Object firstElement;
                Object object = firstElement = PeripheralsView.this.tw != null ? PeripheralsView.this.tw.getStructuredSelection().getFirstElement() : null;
                if (firstElement instanceof TableViewerDataModel) {
                    return ((TableViewerDataModel)firstElement).getComponentInstanceConfigs();
                }
                return CollectionsUtils.emptyList();
            }
        };
        ComponentMenuCreator.IPeripheralSelectionProvider peripheralProvider = new ComponentMenuCreator.IPeripheralSelectionProvider(){

            @Override
            public @Nullable String getSelection() {
                Object firstElement;
                Object object = firstElement = PeripheralsView.this.tw != null ? PeripheralsView.this.tw.getStructuredSelection().getFirstElement() : null;
                if (firstElement instanceof TableViewerDataModel) {
                    return ((TableViewerDataModel)firstElement).getPeripheral();
                }
                return null;
            }
        };
        CheckboxTableViewer viewer = this.tw;
        if (viewer != null) {
            new ComponentMenuCreator(selectionProvider, peripheralProvider, new ComponentMenuCreator.ComponentMenuOptions(true), this.controllerWrapper).createMenu((Viewer)viewer, this.getViewSite());
        }
    }

    private void createFilterPart(@NonNull Composite parent) {
        Composite filterComposite = new Composite(parent, 0);
        GridLayout filterCompositeLayout = new GridLayout(3, false);
        filterCompositeLayout.horizontalSpacing = 10;
        filterCompositeLayout.marginHeight = 0;
        filterCompositeLayout.marginWidth = 0;
        filterComposite.setLayout((Layout)filterCompositeLayout);
        filterComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createFilterButtons(filterComposite);
        this.createFilterTextBox(filterComposite);
        Button button = new Button(filterComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsOpenReorderDialog");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().InitializationOrderDialog_OpenDialogButtonTooltip);
        button.setImage(ToolsImages.getImage((String)"icons/reorder.png"));
        button.setLayoutData((Object)new GridData(131072, 4, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PeripheralsView.this.getSiteNonNull().getShell();
                if (shell != null) {
                    InitializationOrderDialog.open(new InitializationOrderDialogProperties(shell, PeripheralsView.this.controllerWrapper));
                }
            }
        });
    }

    private void createFilterTextBox(@NonNull Composite filterComposite) {
        final Text filterBoxLoc = new Text(filterComposite, 128);
        filterBoxLoc.setLayoutData((Object)new GridData(4, 128, true, false));
        filterBoxLoc.setMessage(UtilsText.safeString((String)com.nxp.swtools.utils.Messages.get().RegistersView_TypeFilterText));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)filterBoxLoc, "periphsPeriphsFilterText");
        TextBoxHelper.attachModifyListeners((Text)filterBoxLoc, s -> this.getFilterStringAndRefresh(filterBoxLoc));
        filterBoxLoc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PeripheralsView.this.getFilterStringAndRefresh(filterBoxLoc);
            }
        });
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)filterBoxLoc, Messages.get().PeripheralsView_FilterTooltip);
        this.filterBox = filterBoxLoc;
    }

    private void createFilterButtons(@NonNull Composite filterComposite) {
        SelectionAdapter toolbarItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckboxTableViewer tableViewer;
                block8: {
                    String action;
                    Object src = e.getSource();
                    if (!(src instanceof ToolItem)) break block8;
                    ToolItem toolItem = (ToolItem)src;
                    boolean selected = toolItem.getSelection();
                    switch (action = (String)Objects.requireNonNull(toolItem.getData(PeripheralsView.TOOL_ITEM_ACTION))) {
                        case "filterUsedOrRequestedPeripherals": {
                            PeripheralsView.this.filterShowUsedOrRequestedPeripherals = selected;
                        }
                    }
                }
                if ((tableViewer = PeripheralsView.this.tw) != null) {
                    tableViewer.refresh();
                }
            }
        };
        ToolBar filterButtonsBar = new ToolBar(filterComposite, 0x800000);
        filterButtonsBar.setLayoutData((Object)new GridData(4, 4, false, false));
        ToolItem usedOrRequestedPeripheralToolItemLoc = new ToolItem(filterButtonsBar, 32);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)usedOrRequestedPeripheralToolItemLoc, "periphsPeriphsFilterInitializedButton");
        usedOrRequestedPeripheralToolItemLoc.setImage(ToolsImages.getImage((String)"icons/filter.png"));
        usedOrRequestedPeripheralToolItemLoc.setToolTipText(Messages.get().PeripheralsView_ShowOnlyUsedOrRequestedPeripherals);
        usedOrRequestedPeripheralToolItemLoc.setSelection(this.filterShowUsedOrRequestedPeripherals);
        usedOrRequestedPeripheralToolItemLoc.setData(TOOL_ITEM_ACTION, (Object)FILTER_USED_OR_REQUESTED_PERIPHERALS);
        usedOrRequestedPeripheralToolItemLoc.addSelectionListener((SelectionListener)toolbarItemListener);
        this.usedOrRequestedPeripheralToolItem = usedOrRequestedPeripheralToolItemLoc;
    }

    private void setupTableViewer() {
        CheckboxTableViewer tableViewer = this.tw;
        if (tableViewer != null) {
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.addFilter();
            this.setCheckStateProvider();
            this.addCheckStateListener();
            this.registerListener(3, new IEventListener((TableViewer)tableViewer){
                private final /* synthetic */ TableViewer val$tableViewer;
                {
                    this.val$tableViewer = tableViewer;
                }

                public void handle(@NonNull ToolEvent event) {
                    this.val$tableViewer.setInput(PeripheralsView.this.getDataForTableViewer());
                }

                public void handle(@NonNull Collection<@NonNull ToolEvent> events) {
                    boolean hasChangeEvent = events.stream().anyMatch(e -> e.isType(3));
                    if (hasChangeEvent) {
                        this.val$tableViewer.setInput(PeripheralsView.this.getDataForTableViewer());
                    } else {
                        this.val$tableViewer.refresh();
                    }
                }
            });
            tableViewer.setInput(this.getDataForTableViewer());
        }
    }

    private void addCheckStateListener() {
        final CheckboxTableViewer tableViewer = this.tw;
        if (tableViewer != null) {
            tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    TableViewerDataModel row = (TableViewerDataModel)event.getElement();
                    String peripheral = row.getPeripheral();
                    List<@NonNull IComponentInstanceConfig> configs = row.getComponentInstanceConfigs();
                    if (event.getChecked()) {
                        if (configs.isEmpty()) {
                            PeripheralsView.configurePeripheral(peripheral, Controller.getInstance().getFunctionalGroup(), (Object)PeripheralsView.this, PeripheralsView.this.controllerWrapper);
                        } else {
                            ProgressUtils.run(m -> PeripheralsView.this.controllerWrapper.getController().setComponentInstancesEnabled((Collection)configs, true, (Object)PeripheralsView.this));
                        }
                    } else {
                        ProgressUtils.run(m -> PeripheralsView.this.controllerWrapper.getController().setComponentInstancesEnabled((Collection)configs, false, (Object)PeripheralsView.this));
                    }
                    if (!tableViewer.getTable().isDisposed()) {
                        if (OSDetect.isMac()) {
                            tableViewer.setSelection((ISelection)new StructuredSelection((Object)row));
                        }
                        tableViewer.refresh();
                    }
                }
            });
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void configurePeripheral(@NonNull String peripheral, @NonNull IFunctionalGroup group, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapper) {
        IViewSite viewSite;
        APeriphController controller = controllerWrapper.getController();
        boolean openView = PerspectivesHelper.isPerspectiveActive((String)"com.nxp.swtools.periphs.gui.perspective") && controller.getFunctionalGroup() == group;
        IViewPart viewPart = ComponentSettingViewHelper.getViewPart();
        IViewSite iViewSite = viewSite = viewPart == null ? null : viewPart.getViewSite();
        if (viewSite == null) {
            LOGGER.severe("[TOOL] Could not configure peripheral due to no view found");
            return;
        }
        @NonNull List components = controller.getComponentsOfPeripheral(peripheral);
        AddComponentDialog.filterNonDisplayableComponents(components, controller.getProfile());
        if (components.size() == 1 && AddComponentDialog.getProblemMessage((ConfigurationComponentTypeId)components.get(0), controllerWrapper, group.getName(), peripheral) == null && !AddComponentDialog.componentHasTemplates((ConfigurationComponentTypeId)components.get(0), controllerWrapper)) {
            AddComponentDialog.createComponent((ConfigurationComponentTypeId)components.get(0), peripheral, viewSite, group.getName(), openView, caller, controllerWrapper);
        } else {
            if (components.size() > 0) {
                ConfigurationComponentTypeId alreadyUsedComponent;
                String typeOfFirstComponent = ((ConfigurationComponentTypeId)components.get(0)).getType();
                boolean onlyOneComponentType = components.stream().allMatch(compTypeId -> compTypeId.getType().equals(typeOfFirstComponent));
                if (onlyOneComponentType && (alreadyUsedComponent = controller.getProfile().getActiveComponents().getComponentTypeIdByType(typeOfFirstComponent)) != null && !AddComponentDialog.componentHasTemplates(alreadyUsedComponent, controllerWrapper)) {
                    AddComponentDialog.createComponent(alreadyUsedComponent, peripheral, viewSite, group.getName(), openView, caller, controllerWrapper);
                    return;
                }
            }
            AddComponentDialog.open(viewSite, peripheral, group.getName(), openView, true, controllerWrapper);
        }
    }

    private void setCheckStateProvider() {
        CheckboxTableViewer tableViewer = this.tw;
        if (tableViewer != null) {
            tableViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isGrayed(Object element) {
                    TableViewerDataModel row = (TableViewerDataModel)element;
                    List<@NonNull IComponentInstanceConfig> configs = row.getComponentInstanceConfigs();
                    if (!configs.isEmpty()) {
                        boolean firstEnabled = configs.get(0).isEnabled();
                        boolean difference = configs.stream().anyMatch(c -> c.isEnabled() ^ firstEnabled);
                        return difference;
                    }
                    return false;
                }

                public boolean isChecked(Object element) {
                    TableViewerDataModel row = (TableViewerDataModel)element;
                    List<@NonNull IComponentInstanceConfig> configs = row.getComponentInstanceConfigs();
                    return configs.size() > 0 && configs.stream().anyMatch(IChild::isEnabled);
                }
            });
        }
    }

    private void addFilter() {
        CheckboxTableViewer tableViewer = this.tw;
        if (tableViewer != null) {
            tableViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    boolean showAllAvailable;
                    TableViewerDataModel row = (TableViewerDataModel)element;
                    boolean peripheralIsInitialized = !row.getComponentInstanceConfigs().isEmpty();
                    boolean instancesNameMatchesFilterString = row.getComponentInstanceConfigs().stream().anyMatch(instance -> UtilsText.containsIgnoreCase((String)instance.getUiName(), (String)PeripheralsView.this.filterString));
                    boolean peripheralNameMatchesFilterString = UtilsText.containsIgnoreCase((String)row.getPeripheral(), (String)PeripheralsView.this.filterString);
                    boolean rowMatchesFilterString = peripheralNameMatchesFilterString || instancesNameMatchesFilterString;
                    boolean peripheralSupported = !PeripheralsView.this.controllerWrapper.getController().getComponentsOfPeripheral(row.getPeripheral()).isEmpty();
                    boolean rowPassedFiltering = peripheralSupported && rowMatchesFilterString;
                    boolean peripheralRequested = PeripheralsView.getRequestedPeripherals().contains(row.getPeripheral());
                    boolean showUsedOrRequested = PeripheralsView.this.filterShowUsedOrRequestedPeripherals && (peripheralIsInitialized || peripheralRequested);
                    boolean bl = showAllAvailable = !PeripheralsView.this.filterShowUsedOrRequestedPeripherals;
                    return rowPassedFiltering && (showUsedOrRequested || showAllAvailable);
                }
            });
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @NonNull List<@NonNull String> getRequestedPeripherals() {
        ArrayList<@NonNull String> peripherals = new ArrayList<String>();
        @NonNull Collection problems = ValidationEngineFactory.getValidationProblemsCollection();
        for (IValidationProblem problem : problems) {
            if (!PeripheralInitResolveHandler.INSTANCE.canHandle((IBaseProblem)problem)) continue;
            peripherals.add(problem.getDependency().getResourceId());
        }
        return peripherals;
    }

    private void addMouseDoubleClickListener(Table table) {
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TableViewerDataModel row;
                List<IComponentInstanceConfig> instances;
                ViewerCell viewerCell;
                Point pt = new Point(event.x, event.y);
                CheckboxTableViewer tableViewer = PeripheralsView.this.tw;
                if (tableViewer != null && (viewerCell = tableViewer.getCell(pt)) != null && !(instances = (row = (TableViewerDataModel)viewerCell.getElement()).getComponentInstanceConfigs()).isEmpty()) {
                    PeripheralsView.this.openView(instances.get(0));
                }
            }
        });
    }

    private void setupTableProperties(Table table) {
        this.createColumns();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite composite = this.twComposite;
        if (composite != null) {
            composite.setLayout((Layout)tableColumnLayout);
        }
        if (table.getColumn(0) != null) {
            tableColumnLayout.setColumnData((Widget)table.getColumn(0), (ColumnLayoutData)new ColumnWeightData(20, 120, true));
        }
        if (table.getColumn(1) != null) {
            tableColumnLayout.setColumnData((Widget)table.getColumn(1), (ColumnLayoutData)new ColumnWeightData(80, 120, true));
        }
    }

    public void setFocus() {
        Composite composite = this.twComposite;
        if (composite != null) {
            composite.setFocus();
        }
    }

    private void createColumns() {
        TableViewerColumn col = this.createTableViewerColumn(UtilsText.safeString((String)Messages.get().PeripheralsView_PeripheralColumn));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableViewerDataModel row = (TableViewerDataModel)element;
                return row.getPeripheral();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public Image getImage(Object element) {
                if (element instanceof TableViewerDataModel) {
                    TableViewerDataModel model = (TableViewerDataModel)element;
                    @NonNull @NonNull @NonNull Map problems = ValidationHelper.collectValidationProblemsOnPeripheralsTool();
                    @NonNull List problemsOfPeripheral = (List)problems.get(model.getPeripheral());
                    if (problemsOfPeripheral == null) {
                        return null;
                    }
                    IValidationProblem problem = (IValidationProblem)ProblemUtils.getHighestSeverityProblem(problemsOfPeripheral.stream());
                    if (problem == null) {
                        return null;
                    }
                    return ToolsImages.getStatusIcon((int)problem.getProblemLevel());
                }
                return null;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public String getToolTipText(Object element) {
                if (element instanceof TableViewerDataModel) {
                    TableViewerDataModel model = (TableViewerDataModel)element;
                    @NonNull @NonNull @NonNull Map problems = ValidationHelper.collectValidationProblemsOnPeripheralsTool();
                    ToolTipableImplementation tooltip = new ToolTipableImplementation();
                    StringBuilder errorBuilder = new StringBuilder();
                    StringBuilder warningBuilder = new StringBuilder();
                    StringBuilder infoBuilder = new StringBuilder();
                    @NonNull List problemsOfPeripheral = (List)problems.get(model.getPeripheral());
                    ArrayList<@NonNull String> usedErrorDescriptions = new ArrayList<String>();
                    ArrayList<@NonNull String> usedWarningDescriptions = new ArrayList<String>();
                    ArrayList<@NonNull String> usedInfoDescriptions = new ArrayList<String>();
                    if (problemsOfPeripheral != null) {
                        block5: for (IValidationProblem problem : problemsOfPeripheral) {
                            String dependencyText = this.createDependencyText(problem);
                            switch (problem.getProblemLevel()) {
                                case 2: 
                                case 3: {
                                    if (usedErrorDescriptions.contains(dependencyText)) continue block5;
                                    usedErrorDescriptions.add(dependencyText);
                                    errorBuilder.append(dependencyText);
                                    break;
                                }
                                case 1: {
                                    if (usedWarningDescriptions.contains(dependencyText)) continue block5;
                                    usedWarningDescriptions.add(dependencyText);
                                    warningBuilder.append(dependencyText);
                                    break;
                                }
                                case 0: {
                                    if (usedInfoDescriptions.contains(dependencyText)) continue block5;
                                    usedInfoDescriptions.add(dependencyText);
                                    infoBuilder.append(dependencyText);
                                }
                            }
                        }
                    }
                    tooltip.setError(errorBuilder.toString());
                    tooltip.setWarning(warningBuilder.toString());
                    tooltip.setInfo(infoBuilder.toString());
                    ToolTipableMarkdownDescriptionDecorator decoratedTooltip = new ToolTipableMarkdownDescriptionDecorator((IToolTipable)tooltip);
                    String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)decoratedTooltip);
                    String id = model.getPeripheral();
                    String name = model.getFullNameOfPeripheral();
                    if (!toolTipText.isEmpty() || !name.equals(id)) {
                        tooltip.setUiName(name);
                        tooltip.setId(id);
                    }
                    return (toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)decoratedTooltip)).isEmpty() ? null : toolTipText;
                }
                return null;
            }

            private @NonNull String createDependencyText(@NonNull IValidationProblem problem) {
                StringBuilder builder = new StringBuilder(200);
                builder.append(problem.getDependency().getDescription());
                builder.append(" ");
                builder.append("(");
                builder.append(Messages.get().PeripheralsView_Dependency_RequiredBy);
                builder.append(" ");
                builder.append(problem.getDependency().getSource());
                builder.append(")");
                builder.append("\r\n");
                return UtilsText.safeString((String)builder.toString());
            }
        });
        col = this.createTableViewerColumn(UtilsText.safeString((String)Messages.get().PeripheralsView_UsedInColumn));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            private @NonNull String fullTextLabel(@NonNull IComponentInstanceConfig instanceConfig) {
                return instanceConfig.isEnabled() ? instanceConfig.getName() : MessageFormat.format(UtilsText.safeString((String)Messages.get().PeripheralsView_DisabledComponentLabel), instanceConfig.getName());
            }

            public String getText(Object element) {
                TableViewerDataModel row = (TableViewerDataModel)element;
                String instanceNames = (String)row.getComponentInstanceConfigs().stream().map(this::fullTextLabel).collect(CollectorsUtils.joining((CharSequence)", "));
                if (PeripheralsView.this.controllerWrapper.getController().isPeripheralMarkedAsUsed(row.getPeripheral())) {
                    return MessageFormat.format("{0}[{1}]", instanceNames, Messages.get().PeripheralsView_UserInitSuffix);
                }
                return instanceNames;
            }

            public String getToolTipText(Object element) {
                if (element instanceof TableViewerDataModel) {
                    TableViewerDataModel model = (TableViewerDataModel)element;
                    List<@NonNull IComponentInstanceConfig> instances = model.getComponentInstanceConfigs();
                    String result = UtilsText.join(instances.stream().map(x -> UtilsText.safeString((String)ComponentsView.getTooltipText((IChild)x, PeripheralsView.this.controllerWrapper.getController().getCategories()))), (String)"<br/><br/>");
                    return result.isEmpty() ? null : result;
                }
                return null;
            }

            public Image getImage(Object element) {
                Image image = null;
                if (element instanceof TableViewerDataModel) {
                    TableViewerDataModel model = (TableViewerDataModel)element;
                    List<@NonNull IComponentInstanceConfig> instances = model.getComponentInstanceConfigs();
                    for (IComponentInstanceConfig instance : instances) {
                        String comment = instance.getComment();
                        if (!comment.isEmpty()) {
                            image = ToolsImages.getImage((String)"icons/legend.png");
                        }
                        if (!ValidationHelper.getDriverValidationProblems((IChild)instance, (int)2).isEmpty()) {
                            return ToolsImages.getStatusIcon((int)2);
                        }
                        int problemLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)instance);
                        if (instance.getError() != null || problemLevel >= 2) {
                            image = ToolsImages.getStatusIcon((int)2);
                            continue;
                        }
                        if (instance.getWarning() != null || problemLevel == 1) {
                            image = ToolsImages.getStatusIcon((int)1);
                            continue;
                        }
                        if (instance.getInfo() == null && problemLevel != 0) continue;
                        image = ToolsImages.getStatusIcon((int)0);
                    }
                }
                return image;
            }
        });
    }

    private @NonNull TableViewerColumn createTableViewerColumn(@NonNull String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.tw, 4);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        return viewerColumn;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull TableViewerDataModel> getDataForTableViewer() {
        ArrayList<@NonNull TableViewerDataModel> dataCollection = new ArrayList<TableViewerDataModel>();
        @NonNull List peripheralInstances = this.controllerWrapper.getController().getActiveCorePeripherals();
        IRegistersDatabaseAPI registersDb = this.controllerWrapper.getController().getMcu().getRegistersDb();
        Iterator iterator = peripheralInstances.iterator();
        while (iterator.hasNext()) {
            IRegParentPeripheralAPI peripheral;
            String peripheralInstanceName;
            String fullPeripheralName = peripheralInstanceName = (String)iterator.next();
            if (registersDb != null && (peripheral = registersDb.getPeripheral(peripheralInstanceName)) != null) {
                fullPeripheralName = peripheral.getFullName();
            }
            dataCollection.add(new TableViewerDataModel(peripheralInstanceName, fullPeripheralName, this.controllerWrapper.getController().getComponentInstanceConfigs(peripheralInstanceName)));
        }
        return dataCollection;
    }

    protected void resetView() {
        super.resetView();
        this.filterString = "";
        if (this.filterBox != null) {
            this.filterBox.setText("");
        }
        this.filterShowUsedOrRequestedPeripherals = false;
        if (this.usedOrRequestedPeripheralToolItem != null) {
            this.usedOrRequestedPeripheralToolItem.setSelection(false);
        }
        if (this.tw != null) {
            this.tw.refresh();
        }
    }

    @Override
    public void dispose() {
        ValidationEngineFactory.removeListener((IValidationProblemListener)this.validationsListener);
        super.dispose();
    }

    void getFilterStringAndRefresh(@NonNull Text filterBoxLoc) {
        this.filterString = UtilsText.safeString((String)filterBoxLoc.getText());
        CheckboxTableViewer tableViewer = this.tw;
        if (tableViewer != null) {
            tableViewer.refresh();
        }
    }

    private static class TableViewerDataModel {
        @NonNull
        private String peripheral;
        @NonNull
        private String fullNameOfPeripheral;
        @NonNull
        private @NonNull List<@NonNull IComponentInstanceConfig> componentInstanceConfigs;

        TableViewerDataModel(@NonNull String peripheral, @NonNull String fullNameOfPeripheral, @NonNull List<@NonNull IComponentInstanceConfig> compConfigs) {
            this.peripheral = peripheral;
            this.componentInstanceConfigs = compConfigs;
            this.fullNameOfPeripheral = fullNameOfPeripheral;
        }

        public @NonNull String getPeripheral() {
            return this.peripheral;
        }

        public @NonNull String getFullNameOfPeripheral() {
            return this.fullNameOfPeripheral;
        }

        public @NonNull List<@NonNull IComponentInstanceConfig> getComponentInstanceConfigs() {
            return this.componentInstanceConfigs;
        }

        public int hashCode() {
            return Objects.hash(this.peripheral);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableViewerDataModel other = (TableViewerDataModel)obj;
            return Objects.equals(this.peripheral, other.peripheral);
        }
    }
}

